/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis;

import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.utils.LogUtil;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.Activator;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.mu.client.ClientAdapter;
import com.ez.workspace.mu.client.Utils;
import com.ez.workspace.mu.client.commands.Command;
import com.ez.workspace.mu.client.commands.VerifyLicenseCommand;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EZAbstractAnalysis
implements EZAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(EZAbstractAnalysis.class);
    protected ClientAdapter client;
    protected String serverHost;
    protected int serverPort = -1;
    protected boolean jobFinished = false;
    protected Integer requestID;
    protected String serverHost4Licensing;
    protected Integer serverPort4Licensing;
    private Map<String, Object> inputContext = new HashMap<String, Object>();

    @Override
    public void addContextValue(String key, Object value) {
        this.inputContext.put(key, value);
    }

    @Override
    public void addAllContextValues(Map<String, Object> context) {
        this.inputContext.putAll(context);
    }

    @Override
    public Object getContextValue(String key) {
        return this.inputContext.get(key);
    }

    @Override
    public List getContextListValue(String key) {
        Object o = this.inputContext.get(key);
        if (o instanceof List) {
            return (List)o;
        }
        return null;
    }

    @Override
    public Set getContextSetValue(String key) {
        Object o = this.inputContext.get(key);
        if (o instanceof Set) {
            return (Set)o;
        }
        return null;
    }

    @Override
    public Object hasContextKey(String key) {
        return this.inputContext.containsKey(key);
    }

    @Override
    public Object removeContextValue(String key) {
        return this.inputContext.remove(key);
    }

    @Override
    public void clearContext() {
        this.inputContext.clear();
    }

    @Override
    public void execute() {
        this.client = ClientAdapter.getClient();
        try {
            if (this.checkBeforeExecuteCommand()) {
                if (this.scopeIsShared()) {
                    Command command = this.getCommandToExec();
                    command.execute();
                    EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult = command.getResult();
                    this.handleCommandResult(commResult);
                } else {
                    this.verifyLicenseForLocal();
                }
            } else {
                String anName = this.getType() != null ? this.getType().toString() : this.getAnalysisType().toString();
                WorkspaceLogUtil.info(Messages.getString(EZAbstractAnalysis.class, "errorlog.infoMessage.analysisCanceled", new String[]{anName}));
                L.debug("{} was canceled", (Object)this.getAnalysisType().toString());
            }
        }
        catch (Exception e) {
            LogUtil.displayErrorMessage((Throwable)e, (String)Messages.getString(EZAbstractAnalysis.class, "errorlog.errorMessage.executionStoppedError"), (String)"execution stopped", (Plugin)Activator.getDefault(), (boolean)false);
            L.debug("execution was stopped because an error has occurred", (Throwable)e);
        }
    }

    protected boolean checkBeforeExecuteCommand() {
        return true;
    }

    protected abstract AnalysisType getAnalysisType();

    @Override
    public AnalysisType getOperationType() {
        return this.getAnalysisType();
    }

    public abstract boolean scopeIsShared();

    public abstract Command getCommandToExec();

    protected abstract void handleCommandResult(EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> var1);

    protected abstract void continueAnalysisForShared();

    protected void verifyLicenseForLocal() {
        boolean useDummy;
        L.debug("Verifying license for local analysis");
        Map<String, Integer> serversMap = Utils.getServerPorts();
        Integer licenseStatus = -1;
        EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult = new EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object>(RequestConstants.AnalysisRequestReturnKeys.class);
        for (String serverHost : serversMap.keySet()) {
            Integer serverPort = serversMap.get(serverHost);
            L.debug("Verifying license through server: {}, port: {}", (Object)serverHost, (Object)serverPort);
            VerifyLicenseCommand command = new VerifyLicenseCommand(serverHost, serverPort, this.client.getClientStub(), this.getAnalysisType());
            ((Command)command).execute();
            commResult = command.getResult();
            RequestConstants.RequestStatus status = (RequestConstants.RequestStatus)commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS);
            this.requestID = (Integer)commResult.get(RequestConstants.AnalysisRequestReturnKeys.ANALYSIS_KEY_REQUEST_ID);
            switch (status) {
                case STATUS_ACTIVE: {
                    licenseStatus = 1;
                    this.serverHost4Licensing = serverHost;
                    this.serverPort4Licensing = serverPort;
                    break;
                }
                case STATUS_DENIED: {
                    Object reason = commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_DENIED_REASON);
                    if (reason == null || !reason.equals("Client is not licensed.")) break;
                    licenseStatus = 0;
                    break;
                }
            }
            if (licenseStatus >= 0) break;
        }
        if (useDummy = Boolean.getBoolean("useDummy")) {
            licenseStatus = 1;
        }
        switch (licenseStatus) {
            case 1: {
                this.continueAnalysisForLocal();
                break;
            }
            case 0: {
                commResult.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, (Object)RequestConstants.RequestStatus.STATUS_DENIED);
                commResult.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_DENIED_REASON, (Object)"Client is not licensed.");
                this.analysisDenied(commResult);
                break;
            }
            case -1: {
                commResult.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS, (Object)RequestConstants.RequestStatus.STATUS_DENIED);
                commResult.put(RequestConstants.AnalysisRequestReturnKeys.RETURN_DENIED_REASON, (Object)"License validation failed.");
                this.analysisDenied(commResult);
                break;
            }
        }
    }

    protected abstract void continueAnalysisForLocal();

    public void analysisDenied(EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult) {
        String msg = Messages.getString(EZAbstractAnalysis.class, "notAllowed.message");
        Object reason = commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_DENIED_REASON);
        if (reason != null) {
            if (reason.equals("wrong licence for server")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "licenseServerInvalid.message");
            } else if (reason.equals("notOwner")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "notOwner.message");
            } else if (reason.equals("Project not exist")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "projectNotOpen.message");
            } else if (reason.equals("project already exist")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "projectExists.message");
            } else if (reason.equals(RequestConstants.DENIED_REASON_KIND_USER)) {
                msg = Messages.getString(EZAbstractAnalysis.class, "createProjectNotAllowed.message");
            } else if (reason.equals(RequestConstants.DENIED_REASON_CLIENT_NOT_DEFINED)) {
                msg = Messages.getString(EZAbstractAnalysis.class, "connectServerNotAllowed.message");
            } else if (reason.equals("server is obsolete")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "serverObsolete.message");
            } else if (reason.equals("client is obsolete")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "clientObsolete.message");
            } else if (reason.equals("sapConfigWillBeDeleted")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "sharedSAPConfigurationDeleting.message");
            } else if (reason.equals(RequestConstants.DENIED_REASON_ACQUIRE_IN_PROGRESS)) {
                msg = Messages.getString(EZAbstractAnalysis.class, "acquireInProgressOnOtherServer.message");
            } else if (reason.equals(RequestConstants.DENIED_REASON_NEW_ANALYSIS)) {
                msg = Messages.getString(EZAbstractAnalysis.class, "newServerRequired.message");
            } else if (reason.equals("Client is not licensed.")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "operationDenied.message");
            } else if (reason.equals("License validation failed.")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "licenseValidationFailed.message");
            }
        } else {
            reason = commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_ERROR_REASON);
            if (reason != null && reason.equals("wrong format version")) {
                msg = Messages.getString(EZAbstractAnalysis.class, "wrongVersionFormat.message");
            }
        }
        L.debug("denied message: {}", (Object)msg);
        final String message = msg;
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                Shell shell = window.getShell();
                String title = Messages.getString(EZAbstractAnalysis.class, "requestDenied.title");
                MessageDialog.openWarning((Shell)shell, (String)title, (String)message);
            }
        });
        this.jobFinished = true;
    }

    public String getAnalysisTitle(Integer reqID) {
        return "";
    }
}

