/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis;

import com.ez.internal.id.EZEntityID;
import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.analysis.EZAbstractAnalysis;
import com.ez.workspace.analysis.IFinishListener;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.mu.client.commands.CancelledCommand;
import com.ez.workspace.mu.client.commands.Command;
import com.ez.workspace.mu.client.commands.FinishedCommand;
import com.ez.workspace.utils.WorkspaceLogUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSharedAnalysis
extends EZAbstractAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractSharedAnalysis.class);
    protected Object waitObj;
    protected EZEntityID id;
    protected boolean cancelled = false;
    private List<IFinishListener> finishListeners = new ArrayList<IFinishListener>();

    public void cancellRequest(Integer requestID) {
        if (!this.wasCancelled(requestID)) {
            if (requestID == null) {
                requestID = this.requestID;
            }
            L.debug("trying to cancel request with id={}", (Object)requestID);
            if (requestID != null) {
                String server = this.serverHost != null ? this.serverHost : this.serverHost4Licensing;
                Integer port = this.serverHost != null ? this.serverPort : this.serverPort4Licensing;
                CancelledCommand command = new CancelledCommand(server, port, this.client.getClientStub(), requestID, this.getAnalysisType());
                ((Command)command).execute();
                EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult = command.getResult();
                requestID = (Integer)commResult.get(RequestConstants.AnalysisRequestReturnKeys.ANALYSIS_KEY_REQUEST_ID);
                RequestConstants.RequestStatus status = (RequestConstants.RequestStatus)commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS);
                switch (status) {
                    case STATUS_ACTIVE: {
                        this.client.removeRequest(requestID);
                        this.setCanceled(requestID, true);
                        break;
                    }
                    case STATUS_PENDING: 
                    case STATUS_DENIED: {
                        break;
                    }
                    case STATUS_ERROR: {
                        this.analysisError(commResult);
                        break;
                    }
                }
            } else {
                L.warn("cannot report cancel for a job without ID");
            }
            L.debug("job cancelled {}", (Object)this.cancelled);
            this.jobFinished = true;
            this.notifyFinish();
        } else {
            L.debug("job was already cancelled");
        }
    }

    public void analysisError(EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult) {
        Object err = commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_ERROR_CODE);
        Exception ex = null;
        if (err instanceof Exception) {
            ex = (Exception)err;
        } else if (err instanceof RequestConstants.RequestErrorType) {
            RequestConstants.RequestErrorType errCode = (RequestConstants.RequestErrorType)err;
            switch (errCode) {
                case ERROR_CORE_EXCEPTION: {
                    L.debug("coreException occured");
                    break;
                }
                case ERROR_CANCELLED_EXCEPTION: {
                    L.debug("operation cancelled");
                    break;
                }
            }
        } else {
            ex = new Exception(err.toString());
        }
        L.warn("analysis return from server with error: {}", err, (Object)ex);
        WorkspaceLogUtil.err(Messages.getString(AbstractSharedAnalysis.class, "serverSideError.errorLog.message"), ex);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                Shell shell = window.getShell();
                MessageDialog.openError((Shell)shell, (String)Messages.getString(AbstractSharedAnalysis.class, "errorDialog.title"), (String)Messages.getString(AbstractSharedAnalysis.class, "errorDialog.message"));
            }
        });
        this.jobFinished = true;
    }

    public void jobFinished(Integer requestID) {
        if (this.wasCancelled(requestID)) {
            L.info("job was previously cancelled");
        } else {
            if (requestID == null) {
                requestID = this.requestID;
            }
            if (requestID != null) {
                String server = this.serverHost != null ? this.serverHost : this.serverHost4Licensing;
                Integer port = this.serverHost != null ? this.serverPort : this.serverPort4Licensing;
                FinishedCommand command = new FinishedCommand(server, port, this.client.getClientStub(), requestID, this.getAnalysisType());
                ((Command)command).execute();
                EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult = command.getResult();
                RequestConstants.RequestStatus status = (RequestConstants.RequestStatus)commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS);
                switch (status) {
                    case STATUS_ACTIVE: {
                        break;
                    }
                    case STATUS_DENIED: {
                        L.warn("finished request (id={}) was denied. Reason: {}", (Object)requestID, commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_DENIED_REASON));
                        break;
                    }
                    case STATUS_ERROR: {
                        this.analysisError(commResult);
                        break;
                    }
                }
            } else {
                L.info("cannot report finish for a job without ID");
            }
        }
        this.jobFinished = true;
        this.notifyFinish();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWaitObj(Client.NotificationType type, Integer requestID) {
        AbstractAnalysisJob job = this.getJob(this.id);
        if (job != null) {
            job.endWait();
            if (type.equals((Object)Client.NotificationType.REQUEST_DENIED)) {
                job.setDenied(true);
            }
        } else {
            L.warn("no job for id={}", (Object)this.id);
        }
        if (this.waitObj != null) {
            Object object = this.waitObj;
            synchronized (object) {
                this.waitObj.notifyAll();
            }
        }
    }

    public void requestPending(EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult, Integer requestID) {
        boolean wait;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
        }
        Shell shell = window.getShell();
        String title = String.valueOf(Messages.getString(AbstractSharedAnalysis.class, "requestPending.dialog.title")) + this.getAnalysisTitle(requestID);
        String message = Messages.getString(AbstractSharedAnalysis.class, "requestPending.dialog.message");
        final MessageDialog dialog = new MessageDialog(shell, title, null, message, 3, new String[]{Messages.getString(AbstractSharedAnalysis.class, "requestPending.dialog.okButton"), IDialogConstants.CANCEL_LABEL}, 0);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        boolean bl = wait = dialog.getReturnCode() == 0;
        if (wait) {
            if (requestID != null) {
                this.requestID = requestID;
            }
            this.client.addPending(this.requestID, this);
            this.client.managePendingNotFound(this.requestID, this);
            this.executeWaitAnalysis(this.requestID);
        } else {
            this.cancellRequest(this.requestID);
        }
    }

    protected abstract void executeWaitAnalysis(Integer var1);

    public void setWaitObj(Object waitObj) {
        this.waitObj = waitObj;
    }

    public Object getWaitObj() {
        return this.waitObj;
    }

    protected abstract AbstractAnalysisJob getJob(EZEntityID var1);

    protected abstract EZEntityID makeID();

    public EZEntityID getID() {
        return this.id;
    }

    protected abstract void addCommandInputs(Command var1);

    public boolean isJobFinished() {
        return this.jobFinished;
    }

    public void registerFinishListener(IFinishListener fListener) {
        this.finishListeners.add(fListener);
    }

    public void unregisterFinishListener(IFinishListener fListener) {
        this.finishListeners.remove(fListener);
    }

    public void notifyFinish() {
        for (IFinishListener l : this.finishListeners) {
            L.trace("analysis={} notifies listener={} about finish", (Object)this, (Object)l);
            l.analysisFinished(this);
        }
        this.finishListeners.clear();
    }

    public String getServerHost() {
        return this.serverHost;
    }

    @Override
    public List getInputs() {
        return null;
    }

    public void setRequestID(Integer reqID) {
        this.requestID = reqID;
    }

    public Integer getRequestID() {
        return this.requestID;
    }

    public boolean wasCancelled() {
        return this.wasCancelled(this.requestID);
    }

    protected boolean wasCancelled(Integer reqID) {
        return this.cancelled;
    }

    protected void setCanceled(Integer requestID, boolean canceled) {
        this.cancelled = canceled;
    }

    public void clearAnalysis() {
        this.setCanceled(null, false);
        this.jobFinished = false;
        this.waitObj = null;
    }

    @Override
    public Runnable getRunAtFinish() {
        return null;
    }

    @Override
    public void setRunAtFinish(Runnable runnable) {
    }

    public int getServerPort() {
        return this.serverPort;
    }

    @Override
    protected void handleCommandResult(EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> commResult) {
        this.requestID = (Integer)commResult.get(RequestConstants.AnalysisRequestReturnKeys.ANALYSIS_KEY_REQUEST_ID);
        RequestConstants.RequestStatus status = (RequestConstants.RequestStatus)commResult.get(RequestConstants.AnalysisRequestReturnKeys.RETURN_KEY_STATUS);
        switch (status) {
            case STATUS_ACTIVE: {
                this.continueAnalysisForShared();
                break;
            }
            case STATUS_DENIED: {
                L.debug("operation is not allowed!");
                this.analysisDenied(commResult);
                break;
            }
            case STATUS_PENDING: {
                L.debug("operation is pending!");
                this.requestPending(commResult, null);
                break;
            }
            case STATUS_ERROR: {
                this.analysisError(commResult);
                break;
            }
        }
    }
}

