/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace.analysis;

import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mu.itf.RequestConstants;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysisProperty;
import com.ez.workspace.analysis.EZAnalysisType;
import com.ez.workspace.analysis.ModelInfo;
import com.ez.workspace.analysis.audit.IAudit;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.internal.Messages;
import com.ez.workspace.model.EZProject;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.EZProjectIDSg;
import com.ez.workspace.mu.client.Utils;
import com.ez.workspace.mu.client.commands.AbstractAnalysisCommand;
import com.ez.workspace.mu.client.commands.Command;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalysis
extends AbstractSharedAnalysis
implements IAudit {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AbstractAnalysis.class);
    public static final String INPUT_LIST = "input_list";
    public static final String INPUT_NAMES = "inputs name string";
    public static final String INPUT_PROJECT_NAMES = "input_project_names";
    public static final String INPUT_SET = "input_set";
    public static final String PROJECT_INFO = "PROJECT_INFO";
    public static final String ALL_RESOURCES = "all resources selected";
    public static final String AVAILABLE_RESOURCES = "available resources";
    public static final String SELECTED_PATH = "selected path";
    public static final String separatorForWizardTitle = "  -  ";
    public static final String ANALYSIS_TYPE_INPUTS = "ANALYSIS_TYPE_INPUTS";
    protected static final String JOB_BELONGS_TO_KEY = "JOB_BELONGS_TO";
    public static final String SCOPE = "SCOPE";
    public static final String PROJECT_LIST = "PROJECT_LIST";
    public static final String AUDIT_PROJECT_NAMES = "AUDIT_PROJ_NAMES";
    public static final String DELIMITER = ", ";
    public static final String SOURCE_VIEW_ID_KEY = "sourceView";
    public static final String PROJECTS_KEY = "projects";
    public static final String NOT_COMPUTE_USAGE_RESULTS = "NOT_COMPUTE_USAGE_RESULTS";
    public static final String SHOW_RESULTS = "showResults";
    public static final String EXPORT_PATH = "exportPath";
    public static final String EXPORT_FILENAME = "exportFileName";
    @Deprecated
    protected List inputs;
    private int scopeType = -1;
    protected IWorkingSet[] scope;
    private IWorkingSet[] workingSetsScope;
    protected EZAnalysisType type;
    protected final boolean DIALOG_IS_CANCELED = true;
    @Deprecated
    protected Set inpProjNameSet = new HashSet();
    @Deprecated
    protected Set inpSet = new HashSet();
    private String labelType;
    ViewExec viewExec;
    BringToTopView bringToTopView;

    public AbstractAnalysis() {
        this.id = this.makeID();
    }

    @Override
    protected void addCommandInputs(Command command) {
        if (this.inpProjNameSet != null) {
            command.addInput(RequestConstants.AnalysisRequestKeys.ANALYSIS_KEY_PROJECT_NAME, this.inpProjNameSet);
        }
    }

    @Override
    protected void executeWaitAnalysis(Integer requestID) {
        AbstractAnalysisJob job = this.getJob(requestID);
        this.waitObj = new Object();
        job.setWaitObj(this.waitObj);
        job.schedule();
    }

    protected AbstractAnalysisJob getJob(Integer requestID) {
        return this.getJob(this.id);
    }

    protected boolean filterInputs() {
        return false;
    }

    @Override
    @Deprecated
    public void setInputs(List inputs) {
        this.addContextValue(INPUT_LIST, inputs);
    }

    @Override
    @Deprecated
    public List getInputs() {
        return this.inputs;
    }

    @Override
    public void setScope(int scopeType, Object scope) {
        this.scopeType = scopeType;
        this.scope = null;
        this.workingSetsScope = null;
        IWorkingSet ws = null;
        switch (scopeType) {
            case 0: {
                IAdaptable[] projs = EZWorkspace.getInstance().getProjectIDs();
                if (projs == null) break;
                ws = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSet("", projs);
                this.scope = new IWorkingSet[1];
                this.scope[0] = ws;
                break;
            }
            case 1: {
                Set setProj = (Set)scope;
                if (setProj == null || setProj.isEmpty()) break;
                ws = PlatformUI.getWorkbench().getWorkingSetManager().createWorkingSet("", setProj.toArray(new IAdaptable[setProj.size()]));
                this.scope = new IWorkingSet[1];
                this.scope[0] = ws;
                break;
            }
            case 2: {
                this.workingSetsScope = (IWorkingSet[])scope;
                this.scope = this.workingSetsScope;
                break;
            }
            default: {
                scopeType = -1;
            }
        }
    }

    @Override
    public void setType(EZAnalysisType type) {
        this.type = type;
    }

    @Override
    public EZAnalysisType getType() {
        return this.type;
    }

    public void checkScopeStatus(IProgressMonitor monitor) {
        switch (this.scopeType) {
            case 0: {
                break;
            }
            case 1: {
                if (this.scope == null) break;
                int i = 0;
                while (i < this.scope.length) {
                    IWorkingSet ws = this.scope[i];
                    IAdaptable[] adapts = ws.getElements();
                    if (adapts != null) {
                        int j = 0;
                        while (j < adapts.length) {
                            EZProjectIDSg prjSg = null;
                            EZEntityID id = (EZEntityID)adapts[j].getAdapter(EZEntityID.class);
                            if (id != null && (prjSg = (EZProjectIDSg)id.getSegment(EZProjectIDSg.class)) != null) {
                                EZProject prj = prjSg.getEzProject();
                                IProject prjRes = prj.getProject();
                                monitor.setTaskName(Messages.getString(AbstractAnalysis.class, "checkProject.task.name", new String[]{prjRes.getName()}));
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    @Deprecated
    public Set getInputSet() {
        return this.inpSet;
    }

    @Deprecated
    public void setInputSet(Set inpSet) {
        this.inpSet.clear();
        this.inpSet.addAll(inpSet);
    }

    public String getLabelType() {
        return this.labelType;
    }

    public void setLabelType(String labelType) {
        this.labelType = labelType;
    }

    public boolean equals(Object obj) {
        IWorkingSet[] scope2;
        boolean ret;
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        boolean bl = ret = this.type.equals(a2.type) && this.inputs.equals(a2.inputs);
        if (ret && (scope2 = a2.scope) != null && this.scope != null && this.scope.length == scope2.length) {
            ArrayList<IAdaptable> prj1 = new ArrayList<IAdaptable>();
            int i = 0;
            while (i < this.scope.length) {
                IWorkingSet ws = this.scope[i];
                IAdaptable[] adapts = ws.getElements();
                if (adapts != null) {
                    prj1.addAll(Arrays.asList(adapts));
                }
                ++i;
            }
            ArrayList<IAdaptable> prj2 = new ArrayList<IAdaptable>();
            int i2 = 0;
            while (i2 < scope2.length) {
                IWorkingSet ws = scope2[i2];
                IAdaptable[] adapts = ws.getElements();
                if (adapts != null) {
                    prj2.addAll(Arrays.asList(adapts));
                }
                ++i2;
            }
            ret = prj1.equals(prj2);
        }
        return ret;
    }

    @Override
    public IWorkingSet[] getScope() {
        return this.scope;
    }

    @Override
    public Map<EZAnalysisProperty, Object> getResults() {
        return null;
    }

    @Override
    public String getAnalysisTitle(Integer reqID) {
        return this.getClass().getSimpleName();
    }

    public ModelInfo getModelInfoForElement(Object element, int type) {
        return null;
    }

    protected boolean prerequisitesCheck() {
        return true;
    }

    @Override
    protected boolean checkBeforeExecuteCommand() {
        if (!this.prerequisitesCheck()) {
            return false;
        }
        boolean checkOk = false;
        boolean enabled = true;
        PlatformUI.getPreferenceStore().firePropertyChangeEvent("action", (Object)new Boolean(false), (Object)new Boolean(enabled));
        if (enabled) {
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            IWorkbenchWindow firstWindow = windows[0];
            IWorkbenchPage[] pages = firstWindow.getPages();
            IWorkbenchPage firstPage = pages[0];
            IWorkbenchPart activePart = firstPage.getActivePart();
            IWorkbenchPartSite site = activePart.getSite();
            IWorkbenchPage page = site.getPage();
            IWorkbenchPart analysisPart = null;
            if (this.viewExec == null) {
                this.viewExec = new ViewExec();
            }
            this.viewExec.page = page;
            String jobBelongTo = (String)this.getContextValue(JOB_BELONGS_TO_KEY);
            if (jobBelongTo == null) {
                String viewId = null;
                String secondaryId = null;
                Object startView = this.getContextValue(SOURCE_VIEW_ID_KEY);
                if (startView instanceof Pair) {
                    viewId = (String)((Pair)startView).getFirst();
                    secondaryId = (String)((Pair)startView).getSecond();
                    if (secondaryId != null && secondaryId.isEmpty()) {
                        secondaryId = null;
                    }
                } else {
                    viewId = (String)startView;
                }
                if (viewId != null) {
                    this.viewExec.idAnalysisView = viewId;
                    this.viewExec.secondaryId = secondaryId;
                }
            } else if ("REPORT_JOB".equals(jobBelongTo)) {
                this.viewExec.idAnalysisView = "com.ez.analysis.display.view.ReportsView";
            }
            Display.getDefault().syncExec((Runnable)this.viewExec);
            analysisPart = this.viewExec.analysisPart;
            boolean result = this.filterInputs();
            if (!result) {
                checkOk = true;
                if (analysisPart instanceof ViewPart) {
                    if (this.bringToTopView == null) {
                        this.bringToTopView = new BringToTopView();
                    }
                    this.bringToTopView.page = page;
                    this.bringToTopView.analysisPart = analysisPart;
                    Display.getDefault().syncExec((Runnable)this.bringToTopView);
                }
            }
        }
        return checkOk;
    }

    @Override
    public Command getCommandToExec() {
        if (this.serverHost == null) {
            this.serverHost = Utils.getDefaultServerHost();
        }
        if (this.serverPort == -1) {
            this.serverPort = Utils.getDefaultServerPort();
        }
        if (this.serverHost == null || this.serverPort == -1) {
            L.debug("serverHost and serverPort were not set before getting the command.");
        }
        AbstractAnalysisCommand command = new AbstractAnalysisCommand(this.serverHost, this.serverPort, this.client.getClientStub(), this.getAnalysisType());
        this.addCommandInputs(command);
        return command;
    }

    @Override
    protected void continueAnalysisForShared() {
        this.continueAnalysis();
    }

    @Override
    protected void continueAnalysisForLocal() {
        this.continueAnalysis();
    }

    private void continueAnalysis() {
        this.auditAnalysis();
        AbstractAnalysisJob job = this.getJob(this.id);
        job.schedule();
    }

    @Override
    public String getProjectNames4Audit() {
        String projectName = "";
        if (this.getContextValue(INPUT_PROJECT_NAMES) != null) {
            projectName = this.getContextValue(INPUT_PROJECT_NAMES).toString();
        } else if (this.getContextValue(PROJECT_INFO) != null) {
            projectName = this.getContextValue(PROJECT_INFO).toString();
        } else if (this.getContextListValue(AUDIT_PROJECT_NAMES) != null) {
            StringBuilder projectNames = new StringBuilder();
            this.getContextListValue(AUDIT_PROJECT_NAMES).stream().map(String.class::cast).forEach(pn -> {
                StringBuilder stringBuilder2 = projectNames.append((String)pn).append(DELIMITER);
            });
            if (projectNames.length() > 0) {
                projectNames.setLength(projectNames.length() - 2);
            }
            projectName = projectNames.toString();
        }
        return projectName;
    }

    @Override
    public String getOperationName() {
        return this.getAnalysisType().toString();
    }

    @Override
    public Integer getOperationCode() {
        return this.getAnalysisType().getOperationCode();
    }

    class BringToTopView
    implements Runnable {
        IWorkbenchPage page = null;
        IWorkbenchPart analysisPart = null;

        BringToTopView() {
        }

        @Override
        public void run() {
            if (!this.page.isPartVisible(this.analysisPart)) {
                L.debug("try to bring to top analysis view");
                this.page.activate(this.analysisPart);
            } else {
                L.debug(" analysis view is visible");
            }
        }
    }

    class ViewExec
    implements Runnable {
        String idAnalysisView = "com.ez.analysis.display.view.GraphsView";
        IWorkbenchPage page = null;
        IWorkbenchPart analysisPart = null;
        String secondaryId = null;

        ViewExec() {
        }

        @Override
        public void run() {
            IViewReference view = this.page.findViewReference(this.idAnalysisView, this.secondaryId);
            if (view == null) {
                try {
                    L.debug("show analysis view");
                    this.analysisPart = this.page.showView(this.idAnalysisView, this.secondaryId, 1);
                }
                catch (PartInitException pie) {
                    L.error("could not show ", (Throwable)pie);
                }
            } else {
                this.analysisPart = view.getPart(true);
            }
        }
    }
}

