/*
 * Decompiled with CFR 0.152.
 */
package com.ez.workspace;

import com.ez.internal.utils.PathUtils;
import com.ez.mu.itf.Client;
import com.ez.workspace.change.EZChangingManager;
import com.ez.workspace.model.EZResourceChangeListener;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.EZWorkspaceSaveParticipant;
import com.ez.workspace.mu.client.ClientAdapter;
import com.ez.workspace.mu.client.ClientAliveThread;
import com.ez.workspace.preferences.PreferenceUtils;
import com.ez.workspace.preferences.VerboseLogChangeListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Properties;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends AbstractUIPlugin {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L;
    public static final String PLUGIN_ID = "com.ez.workspace";
    private static final String CLIENT_ALIVE_THREAD_EXTENSION_POINT = "com.ez.workspace.client.thread";
    private static Activator plugin;
    ClientAliveThread th = null;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        L = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        L.info("~ workspace started");
        boolean wkspSet = Platform.getInstanceLocation().isSet();
        L.trace("1. worksp.Activator()::wkspSet={}", (Object)wkspSet);
        if (this.th == null) {
            this.th = this.instantiateClientAliveThread();
        }
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().equals(Activator.this.getBundle()) && event.getType() == 2) {
                    Activator.this.th.start();
                }
            }
        });
        EZWorkspace.getInstance();
        context.addBundleListener(new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                if (event.getBundle().equals(Activator.this.getBundle()) && event.getType() == 2) {
                    EZWorkspaceSaveParticipant saveParticipant = new EZWorkspaceSaveParticipant();
                    ISavedState lastState = null;
                    try {
                        lastState = ResourcesPlugin.getWorkspace().addSaveParticipant(Activator.PLUGIN_ID, (ISaveParticipant)saveParticipant);
                    }
                    catch (CoreException e) {
                        L.error("error trying to add a save participant", (Throwable)e);
                    }
                    EZResourceChangeListener resourceListener = new EZResourceChangeListener();
                    ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)resourceListener, 23);
                    if (lastState == null) {
                        L.info("====> laststate null!!");
                    } else {
                        lastState.processResourceChangeEvents((IResourceChangeListener)resourceListener);
                    }
                    VerboseLogChangeListener verboseLogChangeListener = new VerboseLogChangeListener();
                    PreferenceUtils.addPropertyChangeListener(verboseLogChangeListener);
                    EZChangingManager.getManager();
                }
            }
        });
        wkspSet = Platform.getInstanceLocation().isSet();
        L.trace("2. worksp.Activator()::wkspSet={}", (Object)wkspSet);
        String defLogFolder = (String)com.ez.eclient.logging.preferences.PreferenceUtils.getDefaultValue((String)"logPathPreference");
        File folder = new File(defLogFolder);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        L.info("workspace plugin started. ClientAliveThread={}", (Object)this.th);
    }

    private ClientAliveThread instantiateClientAliveThread() {
        ClientAliveThread t = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(CLIENT_ALIVE_THREAD_EXTENSION_POINT);
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension ext = extensions[i];
                IConfigurationElement[] configElements = ext.getConfigurationElements();
                if (configElements != null) {
                    int j = 0;
                    while (j < configElements.length) {
                        IContributor contributor = configElements[j].getContributor();
                        Bundle contributorBundle = Platform.getBundle((String)contributor.getName());
                        Class instClass = null;
                        String clazz = configElements[j].getAttribute("class");
                        try {
                            instClass = contributorBundle.loadClass(clazz);
                        }
                        catch (ClassNotFoundException ex) {
                            L.error("could not load " + clazz, (Throwable)ex);
                        }
                        if (instClass != null) {
                            try {
                                Constructor ctor = instClass.getConstructor(Client.class);
                                t = (ClientAliveThread)ctor.newInstance(ClientAdapter.getClient());
                                L.info("{}", (Object)t);
                            }
                            catch (Exception e) {
                                L.error("could not instatiate " + clazz, (Throwable)e);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (t == null) {
            t = new ClientAliveThread(ClientAdapter.getClient());
        }
        return t;
    }

    private File copyStaticResource(String pluginId, String pathInPlugin, String systemProperty) {
        File output = new File(PathUtils.METADATA_FOLDER, pathInPlugin);
        PathUtils.copyResource((String)pluginId, (String)pathInPlugin, (File)PathUtils.METADATA_FOLDER);
        if (systemProperty != null && output.isFile()) {
            System.setProperty(systemProperty, output.getAbsolutePath());
            L.info("{}:{}", (Object)systemProperty, (Object)System.getProperty(systemProperty));
        }
        return output;
    }

    public void stop(BundleContext context) throws Exception {
        EZChangingManager.getManager().close();
        ClientAdapter.getClient().stopCallbackService();
        plugin = null;
        super.stop(context);
        plugin = null;
        if (this.th != null) {
            this.th.stopThread();
            this.th = null;
        }
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ClientAliveThread getNotificationThread() {
        return this.th;
    }

    public void addSettings(String server, Properties dbProp) {
        com.ez.internal.Activator.getDefault().addSettings(server, dbProp);
    }

    public Properties getDbSettings(String server) {
        return com.ez.internal.Activator.getDefault().getDbSettings(server);
    }
}

