/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mu.utils.linux;

import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestAnalysisInterface;
import com.ez.mu.itf.RequestConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.EnumMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StubAdapter
implements RequestAnalysisInterface {
    private static final Logger L = LoggerFactory.getLogger(StubAdapter.class);
    private RequestAnalysisInterface original;
    private Properties mounts;

    public StubAdapter(RequestAnalysisInterface original) {
        block14: {
            this.mounts = null;
            this.original = original;
            if (System.getProperty("serverMountConfig") != null) {
                File mountFile = new File(System.getProperty("serverMountConfig"));
                L.info("Server mount config: {}", (Object)mountFile.getAbsolutePath());
                if (mountFile.exists()) {
                    L.debug("Using server mount config file: {}", (Object)mountFile);
                    this.mounts = new Properties();
                    FileInputStream stream = null;
                    try {
                        try {
                            stream = new FileInputStream(mountFile);
                            this.mounts.load(stream);
                        }
                        catch (Exception e) {
                            L.error("loading mount config", (Throwable)e);
                            this.mounts = null;
                            if (stream == null) break block14;
                            try {
                                stream.close();
                            }
                            catch (IOException e2) {
                                L.warn("could not close inputstream ", (Throwable)e2);
                            }
                        }
                    }
                    finally {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException e) {
                                L.warn("could not close inputstream ", (Throwable)e);
                            }
                        }
                    }
                }
            }
        }
    }

    public boolean checkClient(Client client) throws Exception {
        return this.original.checkClient(client);
    }

    public boolean checkConnectionFile(File file) throws RemoteException {
        File remoteFile = file;
        if (this.mounts != null) {
            String workName = file.getName();
            String originalWorkspace = this.mounts.getProperty("originalWorkspace");
            remoteFile = new File(String.valueOf(originalWorkspace) + "\\" + workName);
        }
        return this.original.checkConnectionFile(remoteFile);
    }

    public void deleteLocal(Client client, String name) throws RemoteException {
        this.original.deleteLocal(client, name);
    }

    public Map<String, Set<String>> dumpServer() throws RemoteException {
        return this.original.dumpServer();
    }

    public Properties getDatabaseSettings() throws RemoteException {
        return this.original.getDatabaseSettings();
    }

    public Map<String, Object> getServerWorkspace(boolean shouldCheckLicense, EnumMap<RequestConstants.AnalysisRequestKeys, Object> licensingInfo) throws RemoteException {
        Map info = this.original.getServerWorkspace(shouldCheckLicense, licensingInfo);
        if (this.mounts != null) {
            Integer licenseStatus = (Integer)info.get("license status key");
            if (licenseStatus != null && licenseStatus > 0) {
                String originalWorkspace = (String)info.get("server workspace key");
                String key = originalWorkspace.trim();
                String mount = null;
                mount = this.mounts.getProperty(key);
                if (mount == null) {
                    mount = this.mounts.getProperty(key.replaceAll("\\\\", "/"));
                }
                String linuxWorkspace = originalWorkspace;
                if (mount != null) {
                    linuxWorkspace = mount.trim();
                }
                this.mounts.put("originalWorkspace", originalWorkspace);
                info.put("server workspace key", linuxWorkspace);
            } else if (licenseStatus != null && licenseStatus == -2) {
                L.error("could not identify client ip, probably wrong settings");
            } else {
                L.warn("license not valid; unknown workspace");
            }
        }
        return info;
    }

    public void isAlive(Client client) throws RemoteException {
        this.original.isAlive(client);
    }

    public void isDead(Client client) throws RemoteException {
        this.original.isDead(client);
    }

    public EnumMap<RequestConstants.AnalysisRequestReturnKeys, Object> requestAnalysis(boolean shouldCheckLicense, EnumMap<RequestConstants.AnalysisRequestKeys, Object> analysisInfo) throws RemoteException {
        return this.original.requestAnalysis(false, analysisInfo);
    }

    public void stopServer() throws RemoteException {
        this.original.stopServer();
    }
}

