/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mu.utils.internal;

import com.ez.mu.utils.ExternalizeMessages;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Messages
extends ExternalizeMessages {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Messages.class);
    static ExternalizeMessages.ResourceBundleBuilder builder = new ExternalizeMessages.ResourceBundleBuilder(){

        @Override
        public ResourceBundle getBundle(String bundlePath) {
            return ResourceBundle.getBundle(bundlePath);
        }
    };

    private Messages() {
    }

    public static String getString(Class resourceClass, String key) {
        return Messages.getString(resourceClass, key, null, builder);
    }

    public static String getString(Class resourceClass, String key, Object[] messageArguments) {
        return Messages.getString(resourceClass, key, messageArguments, builder);
    }

    public static String getStringAnyBundle(Class resourceClass, String key) {
        InputStream inputStream = null;
        try {
            String value;
            String resourceBundle = Messages.getResourcePath(resourceClass);
            if (!resourceBundle.startsWith("msg/")) {
                resourceBundle = "msg/".concat(resourceBundle);
            }
            String coreName = resourceBundle.concat(".properties");
            inputStream = resourceClass.getResourceAsStream(coreName);
            Properties props = new Properties();
            props.load(inputStream);
            String string = value = props.getProperty(key);
            return string;
        }
        catch (IOException iOException) {
            String string = String.valueOf('!') + key + '!';
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    L.warn("could not close stream ", (Throwable)e);
                }
            }
        }
    }
}

