/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mu.utils;

import com.ez.mu.itf.Client;
import com.ez.mu.itf.RequestAnalysisInterface;
import com.ez.mu.itf.RequestConstants;
import com.ez.mu.utils.linux.StubAdapter;
import java.io.File;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.EnumMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static Logger L = LoggerFactory.getLogger(ServerUtils.class);

    public static Integer verifyServerConnection(String serverHost, int rmiPort, Client client, EnumMap<RequestConstants.AnalysisRequestKeys, Object> analysis) throws RemoteException, Exception {
        Integer connectionStatus = -2;
        L.debug("server: {}....... port: {}", (Object)serverHost, (Object)rmiPort);
        try {
            RequestAnalysisInterface stub = ServerUtils.getStub(serverHost, rmiPort, "SharedProject");
            Map serverWorkspaceInfoMap = stub.getServerWorkspace(false, analysis);
            String serverWk = null;
            serverWk = (String)serverWorkspaceInfoMap.get("server workspace key");
            if (serverWk != null) {
                File swkFile = new File(serverWk);
                L.debug("checking file {}", (Object)swkFile);
                if (swkFile != null && swkFile.exists() && swkFile.isDirectory()) {
                    File tmp = File.createTempFile("ctx", null, swkFile);
                    File remoteTmp = new File(String.valueOf(serverWk) + File.separator + tmp.getName());
                    boolean connected = stub.checkConnectionFile(remoteTmp);
                    if (!connected) {
                        L.error("server said it could not find the temp file ({}) or had errors with it", (Object)tmp);
                    } else {
                        L.debug("client ip: {}", (Object)client.getIP());
                        connected = stub.checkClient(client);
                        L.debug("checkClient returned: {}", (Object)connected);
                        connectionStatus = connected ? 1 : -2;
                    }
                } else {
                    L.error("{} does not exist, is not a folder, or can't be accessed.", (Object)serverWk);
                }
            } else {
                L.error("server workspace received is null!");
            }
        }
        catch (RemoteException e) {
            L.error("Error at verifying server connection", (Throwable)e);
            connectionStatus = -2;
            throw e;
        }
        catch (Exception e) {
            L.error("Error at verifying server connection", (Throwable)e);
            connectionStatus = -2;
            throw e;
        }
        return connectionStatus;
    }

    public static Map<String, Object> getServerWorkspace(String serverHost, int rmiPort, EnumMap<RequestConstants.AnalysisRequestKeys, Object> licensingInfoEnumMap) {
        Map serverWorkspaceInfoMap = null;
        try {
            RequestAnalysisInterface stub = ServerUtils.getStub(serverHost, rmiPort, "SharedProject");
            serverWorkspaceInfoMap = stub.getServerWorkspace(false, licensingInfoEnumMap);
        }
        catch (Throwable t) {
            L.error("cannot retrieve server's workspace: {}", (Object)serverHost, (Object)t);
        }
        return serverWorkspaceInfoMap;
    }

    public static RequestAnalysisInterface getStub(String serverHost, int port, String remoteRef) throws RemoteException, NotBoundException, AccessException {
        Registry registry = LocateRegistry.getRegistry(serverHost, port);
        RequestAnalysisInterface stub = (RequestAnalysisInterface)registry.lookup(remoteRef);
        return ServerUtils.getOsAdapter(stub);
    }

    private static RequestAnalysisInterface getOsAdapter(RequestAnalysisInterface stub) {
        RequestAnalysisInterface adapter = stub;
        if (System.getProperty("serverMountConfig") != null) {
            adapter = new StubAdapter(stub);
        }
        return adapter;
    }
}

