/*
 * Decompiled with CFR 0.152.
 */
package com.ez.mu.utils;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalizeMessages {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(ExternalizeMessages.class);
    protected static final String BUNDLE_LOCATION = "msg/";

    protected ExternalizeMessages() {
    }

    public static String getString(Class resourceClass, String key, Object[] messageArguments) {
        return ExternalizeMessages.getString(resourceClass, key, messageArguments, null);
    }

    public static String getString(Class resourceClass, String key, Object[] messageArguments, ResourceBundleBuilder builder) {
        try {
            String resourceBundle = ExternalizeMessages.getResourcePath(resourceClass);
            if (!resourceBundle.startsWith(BUNDLE_LOCATION)) {
                resourceBundle = BUNDLE_LOCATION.concat(resourceBundle);
            }
            ResourceBundle res = builder == null ? ResourceBundle.getBundle(resourceBundle, Locale.getDefault(), resourceClass.getClassLoader()) : builder.getBundle(resourceBundle);
            String ret = null;
            ret = messageArguments == null ? res.getString(key) : MessageFormat.format(res.getString(key), messageArguments);
            ExternalizeMessages.printKeys(key, ret, resourceClass.toString());
            return ret;
        }
        catch (MissingResourceException missingResourceException) {
            return String.valueOf('!') + key + '!';
        }
    }

    protected static String getStringFromFile(String filePath, String fileName, String key, Object[] arguments, ResourceBundleBuilder builder) {
        try {
            String resourceBundle = filePath.endsWith("/") ? filePath.concat(fileName) : filePath.concat("/").concat(fileName);
            ResourceBundle res = builder.getBundle(resourceBundle);
            String ret = null;
            ret = arguments == null ? res.getString(key) : MessageFormat.format(res.getString(key), arguments);
            ExternalizeMessages.printKeys(key, ret, resourceBundle);
            return ret;
        }
        catch (MissingResourceException e) {
            L.info("resource: {} not found in path: {}", new Object[]{fileName, filePath, e});
            return String.valueOf('!') + key + '!';
        }
    }

    protected static String getResourcePath(Class clazz) {
        String str = clazz.getName().replace('.', '/');
        return str;
    }

    private static void printKeys(String key, String message, String file) {
        boolean print = Boolean.valueOf(System.getProperty("print.messages", "false"));
        if (print) {
            L.info("{}: {}={}", new Object[]{file, key, message});
        }
    }

    public static interface ResourceBundleBuilder {
        public ResourceBundle getBundle(String var1);
    }
}

