/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version
implements Comparable {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(Version.class);
    private ArrayList segments = new ArrayList();
    private int maxSegments = -1;

    public Version() {
        this("0.0");
    }

    public Version(String version) throws NumberFormatException {
        int i = 0;
        while (i < version.length()) {
            char ch = version.charAt(i);
            if (Character.isLetter(ch)) {
                version = version.substring(0, i);
                break;
            }
            ++i;
        }
        String[] sgs = version.split("\\.", 0);
        boolean parsed = false;
        try {
            int i2 = 0;
            while (i2 < sgs.length) {
                this.segments.add(new Integer(Integer.parseInt(sgs[i2])));
                ++i2;
            }
            parsed = true;
        }
        finally {
            if (!parsed) {
                System.out.println("clear segments");
                this.segments.clear();
            }
        }
    }

    public int compareTo(Object arg0) throws ClassCastException {
        if (!(arg0 instanceof Version)) {
            throw new ClassCastException("cannot cast " + arg0.getClass() + " to " + Version.class.getName());
        }
        return this.compareTo((Version)arg0);
    }

    public int compareTo(Version other) {
        int max = Math.max(this.segments.size(), other.segments.size());
        int segs = Math.max(this.maxSegments, 0);
        max = (segs = Math.max(segs, other.maxSegments)) > 0 ? segs : max;
        Integer zero = new Integer(0);
        int result = 0;
        int i = 0;
        while (i < max) {
            Integer otherSegment;
            Integer thisSegment = i < this.segments.size() ? (Integer)this.segments.get(i) : zero;
            result = thisSegment.compareTo(otherSegment = i < other.segments.size() ? (Integer)other.segments.get(i) : zero);
            if (result != 0) break;
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Version)) {
            throw new ClassCastException("cannot cast " + obj.getClass() + " to " + Version.class.getName());
        }
        return this.equals(obj);
    }

    public boolean equals(Version other) {
        return this.compareTo(other) == 0;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < this.segments.size()) {
            if (i != 0) {
                buf.append(".");
            }
            buf.append(this.segments.get(i));
            ++i;
        }
        return buf.toString();
    }

    public int getMaxSegments() {
        return this.maxSegments;
    }

    public void setMaxSegments(int maxSegments) {
        this.maxSegments = maxSegments > 0 ? maxSegments : -1;
    }

    public static void main(String[] args) {
        try {
            Version v1 = new Version();
            Version v2 = new Version("0.0.0.0");
            Version v3 = new Version("0.1.0");
            Version v4 = new Version("2.3");
            Version v5 = new Version("2.1");
            Version v6 = new Version("4");
            Version v7 = new Version("0.0.1.17");
            System.out.println(v1 + " ? " + v2 + v1.compareTo(v2));
            System.out.println(v1 + " ? " + v7 + v1.compareTo(v7));
            System.out.println(v2 + " ? " + v3 + v2.compareTo(v3));
            System.out.println(v3 + " ? " + v2 + v3.compareTo(v2));
            System.out.println(v4 + " ? " + v5 + v4.compareTo(v5));
            System.out.println(v5 + " ? " + v5 + v5.compareTo(v5));
            System.out.println(v6 + " ? " + v5 + v6.compareTo(v5));
            System.out.println(v7 + " ? " + v4 + v7.compareTo(v4));
            System.out.println(v4 + " ? " + v6 + v4.compareTo(v6));
            System.out.println(v7 + " ? " + v6 + v7.compareTo(v6));
            System.out.println(v7 + " =? " + v2 + v7.equals(v2));
            System.out.println(v1 + " =? " + v2 + v1.equals(v2));
        }
        catch (NumberFormatException ex) {
            System.out.println("should not happen");
            L.error("Error:", (Throwable)ex);
        }
        try {
            new Version("1,2");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ok, got error");
        }
        try {
            new Version("1.a");
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("ok, got error");
        }
        Version v10 = new Version("1.0.1");
        Version v11 = new Version("1.0.5");
        System.out.println(v10 + " ? " + v11 + v10.compareTo(v11));
        v10.setMaxSegments(2);
        System.out.println(v10 + " ? " + v11 + v10.compareTo(v11));
        v11.setMaxSegments(1);
        System.out.println(v10 + " ? " + v11 + v10.compareTo(v11));
        v10.setMaxSegments(-1);
        System.out.println(v10 + " ? " + v11 + v10.compareTo(v11));
        v11.setMaxSegments(-1);
        System.out.println(v10 + " ? " + v11 + v10.compareTo(v11));
    }
}

