/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathMappingUtils {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(PathMappingUtils.class);

    public static String getAbsolutePath(String baseDir, String file) {
        String path = file;
        if (!(file == null || file.startsWith("/") || file.startsWith("~") || file.length() > 1 && file.charAt(1) == ':' || file.startsWith("\\\\"))) {
            try {
                path = new File(baseDir, file).getCanonicalPath();
            }
            catch (IOException e) {
                L.error("can't compute absolute path for {}", (Object)file, (Object)e);
                path = file;
            }
        }
        return path;
    }

    public static String convertToMapped(String path, Properties driversMapping) {
        if (driversMapping == null) {
            driversMapping = PathMappingUtils.getDrivesMapping(null);
        }
        return PathMappingUtils.findPath(path, driversMapping);
    }

    private static String findPath(String path, Properties driversMapping) {
        String rez = path;
        if (driversMapping != null) {
            String p = path.replaceAll("\\\\", "/");
            for (Object ro : driversMapping.keySet()) {
                String rp = (String)ro;
                if (!path.startsWith(rp)) continue;
                rez = String.valueOf(driversMapping.getProperty(rp)) + p.substring(rp.length());
                break;
            }
        }
        return rez;
    }

    public static String convertToMapped(String path) {
        Properties mounts = PathMappingUtils.getDrivesMapping(null);
        return PathMappingUtils.findPath(path, mounts);
    }

    public static Properties getDrivesMapping(String propertyName) {
        Properties mounts;
        block14: {
            File windrives;
            mounts = null;
            if (propertyName == null) {
                propertyName = "drivesmapping";
            }
            if (System.getProperty(propertyName) != null && (windrives = new File(System.getProperty(propertyName))).exists()) {
                L.debug("Using drives mapping config file: {}", (Object)windrives);
                mounts = new Properties();
                FileInputStream inStream = null;
                try {
                    try {
                        inStream = new FileInputStream(windrives);
                        mounts.load(inStream);
                    }
                    catch (Exception e) {
                        L.error("loading windrives config", (Throwable)e);
                        mounts = null;
                        if (inStream == null) break block14;
                        try {
                            inStream.close();
                        }
                        catch (IOException e2) {
                            L.error("", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            L.error("", (Throwable)e);
                        }
                    }
                }
            }
        }
        return mounts;
    }
}

