/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.utils;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class PasswUtil {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public static final byte[] KDBDEF = new byte[]{-10, 50, -99, 125, 3, 5, -90, 23};
    public static final byte[] KSCDEF = new byte[]{61, 123, -9, -51, 8, -33, 2, 122};
    private Cipher ecipher;
    private Cipher dcipher;

    public PasswUtil(SecretKey key) {
        try {
            this.ecipher = Cipher.getInstance("AES/GCM/NoPadding");
            this.dcipher = Cipher.getInstance("AES/GCM/NoPadding");
            this.ecipher.init(1, key);
            this.dcipher.init(2, key);
        }
        catch (Throwable throwable) {}
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = str.getBytes("UTF8");
            byte[] enc = this.ecipher.doFinal(utf8);
            return this.toHex(enc);
        }
        catch (Throwable throwable) {
            return str;
        }
    }

    public String decrypt(String str) {
        try {
            byte[] dec = this.fromHex(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (Throwable throwable) {
            return str;
        }
    }

    public String toHex(byte[] bytes) {
        char[] c = new char[bytes.length * 2];
        int y = 0;
        int x = 0;
        while (y < bytes.length) {
            int cb = bytes[y] < 0 ? 256 + bytes[y] : bytes[y];
            byte b = (byte)(cb >> 4 & 0xF);
            c[x] = (char)(b > 9 ? b + 65 : b + 48);
            b = (byte)(cb & 0xF);
            c[++x] = (char)(b > 9 ? b + 65 : b + 48);
            ++y;
            ++x;
        }
        return new String(c);
    }

    public byte[] fromHex(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            byte b1 = (byte)((byte)chars[i] - 65);
            b1 = b1 < 0 ? (byte)((byte)chars[i] - 48) : b1;
            byte b2 = (byte)((byte)chars[++i] - 65);
            b2 = b2 < 0 ? (byte)((byte)chars[i] - 48) : b2;
            bytes[j] = (byte)(b1 << 4 | b2);
            ++i;
            ++j;
        }
        return bytes;
    }

    public static void main(String[] args) throws Exception {
        SecretKeySpec k = new SecretKeySpec(new byte[]{-1, 5, 6, 112, -78, -2, 22, -24}, "AES");
        PasswUtil encrypter = new PasswUtil(k);
        String encrypted = encrypter.encrypt("Don't tell anybody!");
        System.out.println(encrypted);
        String decrypted = encrypter.decrypt(encrypted);
        System.out.println(decrypted);
    }
}

