/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.db.upgrade.actions.pdb;

import com.ez.internal.db.upgrade.IUpgradeAction;
import com.ez.internal.db.upgrade.PrepareAndExecuteStmts;
import com.ez.internal.db.upgrade.UpgradeConstants;
import com.ez.internal.db.upgrade.UpgradeSettings;
import com.ez.internal.db.upgrade.actions.ActionsUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class UpgVer1_6To1_7
implements IUpgradeAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    private void removeConstraintsHSQL(UpgradeSettings con) throws SQLException {
        con.getDbServer().equalsIgnoreCase(UpgradeConstants.DB_HSQL);
    }

    @Override
    public Set upgrade(UpgradeSettings connection, IProgressMonitor monitor) throws Exception {
        HashSet<Integer> typeBuild = new HashSet<Integer>();
        typeBuild.add(0);
        if (connection.getDbServer().equalsIgnoreCase(UpgradeConstants.DB_HSQL)) {
            monitor.subTask(ActionsUtils.getRemoveConstraintsString());
            this.removeConstraintsHSQL(connection);
        }
        PrepareAndExecuteStmts stmts = new PrepareAndExecuteStmts(connection, "1.6-1.7");
        stmts.setProgressMonitor(monitor);
        int work = connection.getActionMaxWork() / 2;
        if (connection.getDbServer().equals(UpgradeConstants.DB_MS_SQLSERVER)) {
            stmts.upgradeAlterDB(work);
            stmts.upgradeInsertDB(connection.getActionMaxWork() - work);
        } else {
            stmts.upgradeInsertDB(work);
        }
        return typeBuild;
    }
}

