/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.db.upgrade.actions.pdb;

import com.ez.internal.db.upgrade.HSQLConstraint;
import com.ez.internal.db.upgrade.IUpgradeAction;
import com.ez.internal.db.upgrade.PrepareAndExecuteStmts;
import com.ez.internal.db.upgrade.UpgradeConstants;
import com.ez.internal.db.upgrade.UpgradeSettings;
import com.ez.internal.db.upgrade.actions.ActionsUtils;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public class UpgVer1_10To1_12
implements IUpgradeAction {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

    private void removeConstraintsHSQL(UpgradeSettings con) throws SQLException {
        if (con.getDbServer().equalsIgnoreCase(UpgradeConstants.DB_HSQL)) {
            HSQLConstraint constraints = new HSQLConstraint(con.getConnection());
            constraints.removeConstraintsForTable("nwcomponents", new String[]{"applicationid"});
            constraints.removeConstraintsForTable("nwapplications", new String[]{"projectid"});
            constraints.removeConstraintsForTable("nwmodelclasses", new String[]{"projectid"});
            constraints.removeConstraintsForTable("nwcontrollers", new String[]{"componentid"});
            constraints.removeConstraintsForTable("nwassoc_comp_comp", new String[]{"applicationid"});
            constraints.removeConstraintsForTable("nwassoc_contr_mclass", new String[]{"applicationid"});
            constraints.removeConstraintsForTable("nwassoc_contr_contr", new String[]{"applicationid"});
        }
    }

    @Override
    public Set upgrade(UpgradeSettings connection, IProgressMonitor monitor) throws Exception {
        int work = connection.getActionMaxWork();
        HashSet<Integer> typeBuild = new HashSet<Integer>();
        typeBuild.add(1);
        typeBuild.add(2);
        if (connection.getDbServer().equalsIgnoreCase(UpgradeConstants.DB_HSQL)) {
            monitor.subTask(ActionsUtils.getRemoveConstraintsString());
            this.removeConstraintsHSQL(connection);
            int delta = work / 4;
            monitor.worked(delta);
            work -= delta;
        }
        PrepareAndExecuteStmts stmts = new PrepareAndExecuteStmts(connection, "1.10-1.12");
        stmts.setProgressMonitor(monitor);
        int delta = work / 2;
        stmts.upgradeAlterDB(delta);
        stmts.upgradeInsertDB(work - delta);
        return typeBuild;
    }
}

