/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.db.upgrade;

import com.ez.internal.db.DBConstants;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeSettings {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UpgradeSettings.class);
    private Connection connection;
    private String dbServer;
    private String scriptsPath;
    private int actionMaxWork;
    private DBConstants.DatabaseType databaseType;

    public UpgradeSettings(Connection connection, String dbServer) {
        this.connection = connection;
        this.dbServer = dbServer;
    }

    public UpgradeSettings(Connection connection, String dbServer, String scriptsPath) {
        this.connection = connection;
        this.dbServer = dbServer;
        this.scriptsPath = scriptsPath;
    }

    public String getScriptsPath() {
        return this.scriptsPath;
    }

    public void setScriptsPath(String scriptsPath) {
        this.scriptsPath = scriptsPath;
    }

    public int getActionMaxWork() {
        return this.actionMaxWork;
    }

    public void setActionMaxWork(int actionMaxWork) {
        this.actionMaxWork = actionMaxWork;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getDbServer() {
        return this.dbServer;
    }

    public void setDbServer(String dbServer) {
        this.dbServer = dbServer;
    }

    public String[] getVersionInDB() {
        String table = "ezmeta";
        String query = String.format("select * from %s ;", table);
        String versionINdb = null;
        String dbType = null;
        if (this.connection != null) {
            try {
                this.connection.setAutoCommit(false);
                PreparedStatement stmt = this.connection.prepareStatement(query);
                stmt.execute();
                this.connection.commit();
                ResultSet rs = stmt.getResultSet();
                if (rs.next()) {
                    versionINdb = rs.getString(1);
                    dbType = rs.getString(2);
                    dbType = dbType.trim();
                }
            }
            catch (SQLException ex) {
                if (this.connection != null) {
                    try {
                        this.connection.rollback();
                        this.connection.close();
                    }
                    catch (SQLException e) {
                        L.info("error at rollback connection", (Throwable)e);
                    }
                }
                L.error("Cannot query database", (Throwable)ex);
            }
        }
        String[] result = new String[]{versionINdb, dbType};
        return result;
    }

    public void setDatabaseType(DBConstants.DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public DBConstants.DatabaseType getDatabaseType() {
        return this.databaseType;
    }
}

