/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.db.upgrade;

import com.ez.internal.db.DBConstants;
import com.ez.internal.db.upgrade.IUpgradeAction;
import com.ez.internal.db.upgrade.UpgradeSettings;
import com.ez.internal.db.upgrade.actions.ddb.UpgVer1_37To1_38;
import com.ez.internal.db.upgrade.actions.ddb.UpgVer1_41To1_42;
import com.ez.internal.db.upgrade.actions.ddb.UpgVer1_42To1_43;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_10To1_12;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_12To1_13;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_13To1_14;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_14To1_16;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_16To1_17;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_17To1_18;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_18To1_19;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_19To1_20;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_20To1_21;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_21To1_22;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_22To1_23;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_23To1_24;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_24To1_25;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_25To1_26;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_26To1_27;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_27To1_28;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_28To1_29;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_29To1_30;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_30To1_31;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_31To1_32;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_32To1_33;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_33To1_34;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_34To1_35;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_38To1_39;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_39To1_40;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_40To1_41;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_43To1_44;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_44To1_45;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_45To1_46;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_46To1_47;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_47To1_48;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_48To1_49;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_49To1_50;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_50To1_51;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_51To1_52;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_52To1_53;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_53To1_54;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_54To1_55;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_55To1_56;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_6To1_7;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_7To1_8;
import com.ez.internal.db.upgrade.actions.pdb.UpgVer1_8To1_10;
import com.ez.mu.utils.internal.Messages;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeManager {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(UpgradeManager.class);
    private UpgradeSettings connection;
    private IProgressMonitor monitor;
    public static DBConstants.DatabaseType databaseType;
    private static final String[] allDBVersions;
    private Set<Integer> messageTypeSet = new HashSet<Integer>();
    private static final HashMap<String, Class> allPDBActions;
    private static final HashMap<String, Class> allCDBActions;
    private static final HashMap<String, Class> allDDBActions;

    static {
        allDBVersions = new String[]{"1.6", "1.7", "1.8", "1.10", "1.12", "1.13", "1.14", "1.16", "1.17", "1.18", "1.19", "1.20", "1.21", "1.22", "1.23", "1.24", "1.25", "1.26", "1.27", "1.28", "1.29", "1.30", "1.31", "1.32", "1.33", "1.34", "1.35", "1.37", "1.38", "1.39", "1.40", "1.41", "1.42", "1.43", "1.44", "1.45", "1.46", "1.47", "1.48", "1.49", "1.50", "1.51", "1.52", "1.53", "1.54", "1.55", "1.56"};
        allPDBActions = new HashMap();
        allPDBActions.put(allDBVersions[0], UpgVer1_6To1_7.class);
        allPDBActions.put(allDBVersions[1], UpgVer1_7To1_8.class);
        allPDBActions.put(allDBVersions[2], UpgVer1_8To1_10.class);
        allPDBActions.put(allDBVersions[3], UpgVer1_10To1_12.class);
        allPDBActions.put(allDBVersions[4], UpgVer1_12To1_13.class);
        allPDBActions.put(allDBVersions[5], UpgVer1_13To1_14.class);
        allPDBActions.put(allDBVersions[6], UpgVer1_14To1_16.class);
        allPDBActions.put(allDBVersions[7], UpgVer1_16To1_17.class);
        allPDBActions.put(allDBVersions[8], UpgVer1_17To1_18.class);
        allPDBActions.put(allDBVersions[9], UpgVer1_18To1_19.class);
        allPDBActions.put(allDBVersions[10], UpgVer1_19To1_20.class);
        allPDBActions.put(allDBVersions[11], UpgVer1_20To1_21.class);
        allPDBActions.put(allDBVersions[12], UpgVer1_21To1_22.class);
        allPDBActions.put(allDBVersions[13], UpgVer1_22To1_23.class);
        allPDBActions.put(allDBVersions[14], UpgVer1_23To1_24.class);
        allPDBActions.put(allDBVersions[15], UpgVer1_24To1_25.class);
        allPDBActions.put(allDBVersions[16], UpgVer1_25To1_26.class);
        allPDBActions.put(allDBVersions[17], UpgVer1_26To1_27.class);
        allPDBActions.put(allDBVersions[18], UpgVer1_27To1_28.class);
        allPDBActions.put(allDBVersions[19], UpgVer1_28To1_29.class);
        allPDBActions.put(allDBVersions[20], UpgVer1_29To1_30.class);
        allPDBActions.put(allDBVersions[21], UpgVer1_30To1_31.class);
        allPDBActions.put(allDBVersions[22], UpgVer1_31To1_32.class);
        allPDBActions.put(allDBVersions[23], UpgVer1_32To1_33.class);
        allPDBActions.put(allDBVersions[24], UpgVer1_33To1_34.class);
        allPDBActions.put(allDBVersions[25], UpgVer1_34To1_35.class);
        allPDBActions.put(allDBVersions[27], com.ez.internal.db.upgrade.actions.pdb.UpgVer1_37To1_38.class);
        allPDBActions.put(allDBVersions[28], UpgVer1_38To1_39.class);
        allPDBActions.put(allDBVersions[29], UpgVer1_39To1_40.class);
        allPDBActions.put(allDBVersions[30], UpgVer1_40To1_41.class);
        allPDBActions.put(allDBVersions[31], UpgVer1_41To1_42.class);
        allPDBActions.put(allDBVersions[32], com.ez.internal.db.upgrade.actions.pdb.UpgVer1_42To1_43.class);
        allPDBActions.put(allDBVersions[33], UpgVer1_43To1_44.class);
        allPDBActions.put(allDBVersions[34], UpgVer1_44To1_45.class);
        allPDBActions.put(allDBVersions[35], UpgVer1_45To1_46.class);
        allPDBActions.put(allDBVersions[36], UpgVer1_46To1_47.class);
        allPDBActions.put(allDBVersions[37], UpgVer1_47To1_48.class);
        allPDBActions.put(allDBVersions[38], UpgVer1_48To1_49.class);
        allPDBActions.put(allDBVersions[39], UpgVer1_49To1_50.class);
        allPDBActions.put(allDBVersions[40], UpgVer1_50To1_51.class);
        allPDBActions.put(allDBVersions[41], UpgVer1_51To1_52.class);
        allPDBActions.put(allDBVersions[42], UpgVer1_52To1_53.class);
        allPDBActions.put(allDBVersions[43], UpgVer1_53To1_54.class);
        allPDBActions.put(allDBVersions[44], UpgVer1_54To1_55.class);
        allPDBActions.put(allDBVersions[45], UpgVer1_55To1_56.class);
        allCDBActions = new HashMap();
        allCDBActions.put(allDBVersions[27], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_37To1_38.class);
        allCDBActions.put(allDBVersions[28], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_38To1_39.class);
        allCDBActions.put(allDBVersions[29], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_39To1_40.class);
        allCDBActions.put(allDBVersions[30], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_40To1_41.class);
        allCDBActions.put(allDBVersions[31], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_41To1_42.class);
        allCDBActions.put(allDBVersions[32], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_42To1_43.class);
        allCDBActions.put(allDBVersions[33], com.ez.internal.db.upgrade.actions.cdb.UpgVer1_43To1_44.class);
        allDDBActions = new HashMap();
        allDDBActions.put(allDBVersions[27], UpgVer1_37To1_38.class);
        allDDBActions.put(allDBVersions[28], com.ez.internal.db.upgrade.actions.ddb.UpgVer1_38To1_39.class);
        allDDBActions.put(allDBVersions[29], com.ez.internal.db.upgrade.actions.ddb.UpgVer1_39To1_40.class);
        allDDBActions.put(allDBVersions[30], com.ez.internal.db.upgrade.actions.ddb.UpgVer1_40To1_41.class);
        allDDBActions.put(allDBVersions[31], UpgVer1_41To1_42.class);
        allDDBActions.put(allDBVersions[32], UpgVer1_42To1_43.class);
        allDDBActions.put(allDBVersions[33], com.ez.internal.db.upgrade.actions.ddb.UpgVer1_43To1_44.class);
    }

    public UpgradeManager(UpgradeSettings connection, IProgressMonitor monitor) {
        this.connection = connection;
        this.monitor = monitor;
    }

    private int getPositionVersion(String version) {
        int position = -1;
        int i = 0;
        while (i < allDBVersions.length) {
            if (allDBVersions[i].equalsIgnoreCase(version)) {
                position = i;
                break;
            }
            ++i;
        }
        return position;
    }

    private UpgradeSettings getConnection() {
        return this.connection;
    }

    private IUpgradeAction[] getUpgradeActions() throws InstantiationException, IllegalAccessException {
        IUpgradeAction[] result = null;
        String currentVersion = "";
        String[] res = this.getVersionInDb();
        String versionInDb = res[0];
        String dbTypeStr = res[1];
        DBConstants.DatabaseType dbType = DBConstants.DatabaseType.getDBType(dbTypeStr.trim());
        HashMap<Object, Object> allActions = new HashMap();
        databaseType = dbType;
        if (dbType.equals((Object)DBConstants.DatabaseType.PDB)) {
            currentVersion = DBConstants.PDB_VERSION;
            allActions = allPDBActions;
        }
        if (dbType.equals((Object)DBConstants.DatabaseType.DDB)) {
            currentVersion = DBConstants.DDB_VERSION;
            allActions = allDDBActions;
        }
        if (dbType.equals((Object)DBConstants.DatabaseType.CDB)) {
            currentVersion = DBConstants.CDB_VERSION;
            allActions = allCDBActions;
        }
        if (versionInDb != null) {
            int start = this.getPositionVersion(versionInDb);
            int end = this.getPositionVersion(currentVersion);
            L.debug("start={} ;; end={}", (Object)start, (Object)end);
            result = new IUpgradeAction[end - start];
            int size = 0;
            int i = start;
            while (i < end) {
                String key = allDBVersions[i];
                Class clazz = (Class)allActions.get(key);
                IUpgradeAction action = (IUpgradeAction)clazz.newInstance();
                result[size++] = action;
                ++i;
            }
        }
        return result;
    }

    private void closeConnection(UpgradeSettings con) throws SQLException {
        Connection connection;
        if (con != null && (connection = con.getConnection()) != null) {
            connection.close();
        }
    }

    private void computeMaxWorkAction(IUpgradeAction[] allActions, UpgradeSettings con, IProgressMonitor monitor) {
        int max = 10000;
        int delta = max / 20;
        if (delta <= 0) {
            delta = 1;
        }
        monitor.worked(delta);
        int n = allActions.length;
        int maxDelta = max - delta;
        if (n > 0) {
            if (maxDelta <= 0) {
                maxDelta = 1;
            }
            con.setActionMaxWork((max - delta) / n);
        } else {
            con.setActionMaxWork(1);
        }
    }

    public void upgrade() throws Exception {
        UpgradeSettings con = this.getConnection();
        if (con != null) {
            IUpgradeAction[] allActions = this.getUpgradeActions();
            con.setDatabaseType(databaseType);
            if (allActions != null) {
                this.computeMaxWorkAction(allActions, con, this.monitor);
                int i = 0;
                while (i < allActions.length) {
                    if (allActions[i] != null) {
                        try {
                            Set msgTypesSet = allActions[i].upgrade(con, this.monitor);
                            this.messageTypeSet.addAll(msgTypesSet);
                        }
                        catch (Exception e) {
                            try {
                                L.error("upgrade error", (Throwable)e);
                                con.getConnection().rollback();
                                System.err.println(e);
                                throw e;
                            }
                            catch (SQLException ex) {
                                L.error("rollback error", (Throwable)ex);
                                System.err.println("error at rollback connection");
                                throw e;
                            }
                        }
                    }
                    ++i;
                }
            }
            this.closeConnection(con);
        }
    }

    private String[] getVersionInDb() {
        String[] result = null;
        if (this.connection != null) {
            result = this.connection.getVersionInDB();
        }
        return result;
    }

    public String getUpgradeLastMessage() {
        String message = "";
        if (this.messageTypeSet.contains(1) && this.messageTypeSet.contains(2)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "buildAllprjs.msg");
        } else if (this.messageTypeSet.contains(1)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "buildAbapprjs.msg");
        } else if (this.messageTypeSet.contains(2)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "buildNWprjs.msg");
        } else if (this.messageTypeSet.contains(4)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "buildCSharpprjs.msg");
        } else if (this.messageTypeSet.contains(3)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "buildJavaprjs.msg");
        } else if (this.messageTypeSet.contains(5)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "buildCprjs.msg");
        } else if (this.messageTypeSet.contains(0)) {
            message = Messages.getStringAnyBundle(UpgradeManager.class, "noBuildprjs.msg");
        }
        return message;
    }
}

