/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.db.upgrade;

import com.ez.internal.db.DBConstants;
import com.ez.internal.db.upgrade.Reader;
import com.ez.internal.db.upgrade.UpgradeConstants;
import com.ez.internal.db.upgrade.UpgradeSettings;
import com.ez.mu.utils.internal.Messages;
import java.io.FileNotFoundException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class PrepareAndExecuteStmts {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private UpgradeSettings settings;
    private Connection conn;
    private String version;
    private boolean isHsql;
    private String pathToDBScript;
    private String scriptPath;
    private Statement stmt;
    private IProgressMonitor progressMonitor;
    private DBConstants.DatabaseType databaseType;
    private PreparedStatement prepStmt;

    public PrepareAndExecuteStmts(UpgradeSettings conn, String version) {
        this.settings = conn;
        this.version = version;
        this.conn = this.settings.getConnection();
        this.scriptPath = conn.getScriptsPath();
        this.databaseType = conn.getDatabaseType();
    }

    public boolean upgradeAlterDB(int work) throws SQLException, FileNotFoundException {
        boolean succeed = true;
        this.isHsql = this.settings.getDbServer().equalsIgnoreCase(UpgradeConstants.DB_HSQL);
        String createScript = this.isHsql ? "create.sql" : "create_sqlServer.sql";
        String delimiter = this.isHsql ? UpgradeConstants.STR_HSQL_DELIMITER : UpgradeConstants.STR_MSSQL_DELIMITER;
        this.stmt = this.conn.createStatement();
        int delta = work / 20;
        this.progressMonitor.worked(delta);
        this.progressMonitor.subTask(Messages.getString(PrepareAndExecuteStmts.class, "alterDatabase.subtask"));
        this.createPathToDbScript(createScript);
        this.conn.setAutoCommit(true);
        this.prepareStmtExecute(delimiter, work - delta);
        return succeed;
    }

    public boolean upgradeInsertDB(int work) throws SQLException, FileNotFoundException {
        boolean succeed = true;
        if (this.stmt == null) {
            this.stmt = this.conn.createStatement();
        }
        this.conn.setAutoCommit(false);
        this.progressMonitor.subTask(Messages.getString(PrepareAndExecuteStmts.class, "insert.subtask"));
        this.createPathToDbScript("insert.sql");
        this.prepareStmt(";");
        int initWork = work / 20;
        this.progressMonitor.worked(initWork);
        this.progressMonitor.subTask(Messages.getString(PrepareAndExecuteStmts.class, "execute.subtask"));
        this.stmt.executeBatch();
        int exeWork = work / 60;
        this.progressMonitor.worked(exeWork);
        this.progressMonitor.subTask(Messages.getString(PrepareAndExecuteStmts.class, "databaseUpgraded.subtask"));
        this.conn.commit();
        int remainder = work - exeWork - initWork;
        if (remainder > 0) {
            this.progressMonitor.worked(remainder);
        }
        return succeed;
    }

    private void createPathToDbScript(String scriptName) {
        String scriptDirName = "scripts";
        String separator = System.getProperty("file.separator");
        if (this.databaseType == DBConstants.DatabaseType.CDB) {
            scriptDirName = scriptDirName.concat(separator).concat(DBConstants.DatabaseType.CDB.toString());
        } else if (this.databaseType == DBConstants.DatabaseType.PDB) {
            scriptDirName = scriptDirName.concat(separator).concat(DBConstants.DatabaseType.PDB.toString());
        }
        if (!this.scriptPath.endsWith(separator)) {
            this.scriptPath = this.scriptPath.concat(separator);
        }
        if (this.scriptPath.length() == 1) {
            this.scriptPath = "";
        }
        this.pathToDBScript = this.scriptPath.concat(scriptDirName).concat(separator).concat(this.version).concat(separator).concat(scriptName);
    }

    private void prepareStmt(String delimiter) throws FileNotFoundException, SQLException {
        Reader reader = new Reader(this.pathToDBScript, delimiter);
        reader.processLineByLine();
        for (String query : reader.getLines()) {
            if (query.trim().equals("")) continue;
            this.stmt.addBatch(query);
        }
    }

    private void prepareStmtExecute(String delimiter, int work) throws FileNotFoundException, SQLException {
        Reader reader = new Reader(this.pathToDBScript, delimiter);
        reader.processLineByLine();
        List<String> lines = reader.getLines();
        int workUnit = work / lines.size();
        int total = 0;
        for (String query : lines) {
            if (query.trim().equals("")) continue;
            this.prepStmt = this.conn.prepareStatement(query);
            this.prepStmt.execute();
            this.progressMonitor.worked(workUnit);
            total += workUnit;
        }
        int delta = work - total;
        if (delta > 0) {
            this.progressMonitor.worked(delta);
        }
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

