/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.db.upgrade;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSQLConstraint {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(HSQLConstraint.class);
    private Connection connection;
    private DatabaseMetaData metaData;

    public HSQLConstraint(Connection connection) {
        this.connection = connection;
    }

    private void initMetaData() throws SQLException {
        this.metaData = this.connection.getMetaData();
    }

    public void removeConstraintsForTable(String table, String[] columns) throws SQLException {
        if (this.connection != null && table != null && columns != null && columns.length > 0) {
            if (this.metaData == null) {
                this.initMetaData();
            }
            table = table.toUpperCase();
            columns = this.upperCase(columns);
            this.removeFK(table, columns);
        }
    }

    private String[] upperCase(String[] a) {
        int i = 0;
        while (i < a.length) {
            if (a[i] != null) {
                a[i] = a[i].toUpperCase();
            }
            ++i;
        }
        return a;
    }

    private void removeFK(String table, String[] columns) throws SQLException {
        ResultSet rs = this.metaData.getImportedKeys(null, "PUBLIC", table);
        String fk_name = null;
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < columns.length) {
            if (columns[i] != null) {
                list.add(columns[i]);
            }
            ++i;
        }
        while (rs.next()) {
            fk_name = rs.getString("FK_NAME");
            String fkColumnName = rs.getString("FKCOLUMN_NAME");
            if (fkColumnName == null || !list.contains(fkColumnName = fkColumnName.toUpperCase())) continue;
            L.debug(" Foreign Key = {}", (Object)fk_name);
            L.debug(" of column = {}", (Object)fkColumnName);
            Statement st = rs.getStatement();
            try {
                st.execute("ALTER TABLE " + table + " DROP CONSTRAINT " + fk_name);
            }
            catch (SQLException e) {
                L.error("Cannot remove FK={} for column={} of table={}", new Object[]{fk_name, fkColumnName, table, e});
            }
        }
    }
}

