/*
 * Decompiled with CFR 0.152.
 */
package com.ez.internal.analysis;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AnalysisType {
    REQUEST_FINISHED(15000),
    REQUEST_CANCELLED(15001),
    IMPORT_PROJECT(15002){

        public String toString() {
            return "Import Project";
        }
    }
    ,
    DELETE_PROJECT(15003){

        public String toString() {
            return "Delete Project";
        }
    }
    ,
    OPEN_PROJECT(15004){

        public String toString() {
            return "Open Project";
        }
    }
    ,
    CREATE_PROJECT(15005){

        public String toString() {
            return "Create Project";
        }
    }
    ,
    CLOSE_PROJECT(15006){

        public String toString() {
            return "Close Project";
        }
    }
    ,
    GET_ALL_PROJECTS(15007){

        public String toString() {
            return "Get All Projects";
        }
    }
    ,
    JAVA_IMPORTS_ANALYSIS(15008){

        public String toString() {
            return "Java Imports";
        }
    }
    ,
    JAVA_COMPLEXITY_ANALYSIS(15009){

        public String toString() {
            return "Java Complexity";
        }
    }
    ,
    JAVA_METRIC_INDICATOR_ANALYSIS(15010){

        public String toString() {
            return "Java Metric Indicator";
        }
    }
    ,
    JAVA_MCCABE_ANALYSIS(15011){

        public String toString() {
            return "Java McCabe Report";
        }
    }
    ,
    JAVA_THIRDPARTY_ANALYSIS(15012){

        public String toString() {
            return "Java Third Party Report";
        }
    }
    ,
    JAVA_CALL_GRAPH(15013){

        public String toString() {
            return "Java Call Graph Analysis";
        }
    }
    ,
    TYPE_GROUP_WU_ANALYSIS(15014){

        public String toString() {
            return "Type Group Where Used Analysis";
        }
    }
    ,
    TRANSACTION_WU_ANALYSIS(15015){

        public String toString() {
            return "Transaction Where Used Analysis";
        }
    }
    ,
    TRANSACTION_CALLGRAPH_ANALYSIS(15016){

        public String toString() {
            return "ABAP Call Graph Analysis";
        }
    }
    ,
    TABLE_WU_ANALYSIS(15017){

        public String toString() {
            return "Table Where Used Analysis";
        }
    }
    ,
    TABLE_FIELD_ANALYSIS(15018){

        public String toString() {
            return "Table Fields Where Used Analysis";
        }
    }
    ,
    RFC_WU_ANALYSIS(15019){

        public String toString() {
            return "RFC Where Used Analysis";
        }
    }
    ,
    PROGRAM_WU_ANALYSIS(15020){

        public String toString() {
            return "Program Where Used Analysis";
        }
    }
    ,
    INCLUDE_WU_ANALYSIS(15021){

        public String toString() {
            return "Include Where Used Analysis";
        }
    }
    ,
    FUNCT_MODULE_WU_ANALYSIS(15022){

        public String toString() {
            return "Function Module Where Used Analysis";
        }
    }
    ,
    DOMAIN_WU_ANALYSIS(15023){

        public String toString() {
            return "Domain Where Used Analysis";
        }
    }
    ,
    DATA_ELEM_WU_ANALYSIS(15024){

        public String toString() {
            return "Data Element Where Used Analysis";
        }
    }
    ,
    CLASS_WU_ANALYSIS(15025){

        public String toString() {
            return "ABAP Class Where Used Analysis";
        }
    }
    ,
    VIEW_WU_ANALYSIS(15026){

        public String toString() {
            return "View Where Used Analysis";
        }
    }
    ,
    CALL_GRAPH_REP_ANALYSIS(15027){

        public String toString() {
            return "ABAP Call Graph Report";
        }
    }
    ,
    SCREEN_LAYOUT_ANALYSIS(15028){

        public String toString() {
            return "ABAP Screen Layout Analysis";
        }
    }
    ,
    FLOW_ANALYSIS(15029){

        public String toString() {
            return "ABAP Flow Analysis";
        }
    }
    ,
    INTERNAL_CALLGRAPH_REP_ANALYSIS(15030),
    CODE_ANALYSIS(15031){

        public String toString() {
            return "Code Style Report";
        }
    }
    ,
    ABAP_COMPARE_ANALYSIS(15032){

        public String toString() {
            return "ABAP Compare Analysis";
        }
    }
    ,
    HALSTEAD_ANALYSIS(15033){

        public String toString() {
            return "ABAP Halstead Report";
        }
    }
    ,
    IFCOMPLEXITY_ANALYSIS(15034){

        public String toString() {
            return "If Complexity Report";
        }
    }
    ,
    ABAP_MCCABE_ANALYSIS(15035){

        public String toString() {
            return "ABAP McCabe Report";
        }
    }
    ,
    ABAP_MAINTAINABILITY_ANALYSIS(15036){

        public String toString() {
            return "ABAP Maintainability Report";
        }
    }
    ,
    MISSING_COMP_ANALYSIS(15037){

        public String toString() {
            return "Missing Components Report";
        }
    }
    ,
    WEIGHT_COMPLEXITY_ANALYSIS(15038){

        public String toString() {
            return "Weight Complexity Report";
        }
    }
    ,
    WU_ANALYSIS_REPORT(15039){

        public String toString() {
            return "Where Used Report";
        }
    }
    ,
    ANNOTATION_ANALYSIS_4REPORT(15040){

        public String toString() {
            return "Annotation Report";
        }
    }
    ,
    FIND_ANNOTATION(15041){

        public String toString() {
            return "Find Annotations Analysis";
        }
    }
    ,
    CREATE_ANNOTATION(15042){

        public String toString() {
            return "Create Annotation Analysis";
        }
    }
    ,
    RECOVER_ANNOTATION(15043){

        public String toString() {
            return "Recover Annotation Analysis";
        }
    }
    ,
    ANNOTATION_HISTORY(15044){

        public String toString() {
            return "Annotation History Analysis";
        }
    }
    ,
    DELETE_ANNOTATION(15045){

        public String toString() {
            return "Delete Annotation Analysis";
        }
    }
    ,
    ORPHAN_ANNOTATION(15046){

        public String toString() {
            return "Orphan Annotation Analysis";
        }
    }
    ,
    REPLY_ANNOTATION(15047){

        public String toString() {
            return "Reply to an annotation analysis";
        }
    }
    ,
    BUILD_SAP(15048){

        public String toString() {
            return "SAP Build Analysis";
        }
    }
    ,
    BUILD_JAVA(15049){

        public String toString() {
            return "Java Build Analysis";
        }
    }
    ,
    BUILD_NW(15050){

        public String toString() {
            return "Netweaver Build Analysis";
        }
    }
    ,
    BUILD_CSHARP(15051){

        public String toString() {
            return "CSharp Build Analysis";
        }
    }
    ,
    CLEAN_SAP(15052){

        public String toString() {
            return "SAP Clean Analysis";
        }
    }
    ,
    CLEAN_JAVA(15053){

        public String toString() {
            return "Java Clean Analysis";
        }
    }
    ,
    CLEAN_NW(15054){

        public String toString() {
            return "Netweaver Clean Analysis";
        }
    }
    ,
    CLEAN_CSHARP(15055){

        public String toString() {
            return "CSharp Clean Analysis";
        }
    }
    ,
    BUILD_PHANTOM(15056){

        public String toString() {
            return "Annotation Build Analysis";
        }
    }
    ,
    LINK_TO_SAP(15057){

        public String toString() {
            return "Link To SAP Analysis";
        }
    }
    ,
    NW_GRAPH_ANALYSIS(15058){

        public String toString() {
            return "Netweaver Graph Analysis";
        }
    }
    ,
    ABAP_FIND(15059){

        public String toString() {
            return "ABAP Batch Find Analysis";
        }
    }
    ,
    EXPORT_ANALYSIS(15060){

        public String toString() {
            return "Export ABAP Properties Analysis";
        }
    }
    ,
    SEARCH_IN_LITERALS(15061){

        public String toString() {
            return "Search In Literals Analysis";
        }
    }
    ,
    CR_IMPACT_AUTOMATIC_ANALYSIS(15062),
    CR_IMPACT_AUTOMATIC_ANALYSIS_NO_GRAPH(15063),
    DATASET_WU_ANALYSIS(15064){

        public String toString() {
            return "Dataset Where Used Analysis";
        }
    }
    ,
    SAP_UPDATE_ANALYSIS(15065){

        public String toString() {
            return "SAP Update Analysis";
        }
    }
    ,
    JAVA_UPDATE_ANALYSIS(15066){

        public String toString() {
            return "Java Update Analysis";
        }
    }
    ,
    CSHARP_UPDATE_ANALYSIS(15067){

        public String toString() {
            return "C sharp Update Analysis";
        }
    }
    ,
    AUTODOWNLOAD_TRANSACTION_CG_ANALYSIS(15068){

        public String toString() {
            return "Download Execution Path Analysis";
        }
    }
    ,
    SAP_UPDATE_REPORT_ANALYSIS(15069){

        public String toString() {
            return "SAP Update Report";
        }
    }
    ,
    UPGRADE_ANALYSIS(15070){

        public String toString() {
            return "SAP Upgrade Report";
        }
    }
    ,
    DOWNLOAD_CUSTOM_CODE_ANALYSIS(15071){

        public String toString() {
            return "Download Custom Code Analysis";
        }
    }
    ,
    ACQUIRE_CUSTOM_CODE_INVENTORY_ANALYSIS(15072){

        public String toString() {
            return "Acquire Custom Code Analysis";
        }
    }
    ,
    CUSTOM_CODE_INVENTORY_REPORT(15073){

        public String toString() {
            return "Custom Code Inventory Report";
        }
    }
    ,
    SAPCONFIGURATION_UPDATED(15074),
    SAPCONFIGURATION_DELETED(15075){

        public String toString() {
            return "SAP Configuration Delete Analysis";
        }
    }
    ,
    INVENTORY_REPORT_ANALYSIS(15076){

        public String toString() {
            return "CSharp Inventory Report";
        }
    }
    ,
    CSHARP_NAMESPACE_DEPENDENCY_ANALYSIS(15077){

        public String toString() {
            return "CSharp Namespace Dependency Analysis";
        }
    }
    ,
    INHERITANCE_GRAPH_ANALYSIS(15078){

        public String toString() {
            return "ABAP Inheritance Graph Analysis";
        }
    }
    ,
    CROSS_APPS_CALL_GRAPH(15079){

        public String toString() {
            return "Cross Applications Graph API";
        }
    }
    ,
    JAVA_INVENTORY_REPORT_ANALYSIS(15080){

        public String toString() {
            return "Java Inventory Report";
        }
    }
    ,
    JTA_ERD_ANALYSIS(15081){

        public String toString() {
            return "Java Entity Diagram Analysis";
        }
    }
    ,
    CSHARP_MCCABE_ANALYSIS(15082){

        public String toString() {
            return "CSharp McCabe Report";
        }
    }
    ,
    RES_DEPENDENCY_ANALYSIS(15083){

        public String toString() {
            return "Java Resource Dependencies Graph";
        }
    }
    ,
    CR_DOWNLOAD_ANALYSIS(15084){

        public String toString() {
            return "Download CR Components Analysis";
        }
    }
    ,
    WU_SUPPORT_PACKAGE_REPORT(15085){

        public String toString() {
            return "Support Package Usage Report";
        }
    }
    ,
    GET_ALL_DATABASES(15086),
    CHANGE_PROJECT_DB_SETTINGS(15087){

        public String toString() {
            return "Change Database Settings of Project";
        }
    }
    ,
    CLIENT_STATE_ANALYSIS(15088){

        public String toString() {
            return "Check client state at create/import shared SAP configuration actions";
        }
    }
    ,
    ACQUIRE_BDT_DATA(15089){

        public String toString() {
            return "Acquire data for BDT Analysis";
        }
    }
    ,
    BDT_CALLGRAPH_ANALYSIS(15090){

        public String toString() {
            return "Callgraph for BDT Components Analysis";
        }
    }
    ,
    DATA_COUNT_ANALYSIS_REPORT(15091){

        public String toString() {
            return "Data Count Analysis Report";
        }
    }
    ,
    TABLE_CONTENT_DOWNLOAD_ANALYSIS(15092){

        public String toString() {
            return "Download of table content analysis";
        }
    }
    ,
    CLEAN_C(15093){

        public String toString() {
            return "Clean C project analysis";
        }
    }
    ,
    BUILD_C(15094){

        public String toString() {
            return "Build C project analysis";
        }
    }
    ,
    C_HALSTEAD_ANALYSIS(15095){

        public String toString() {
            return "C Halstead Report";
        }
    }
    ,
    C_MCCABE_ANALYSIS(15096){

        public String toString() {
            return "C McCabe Report";
        }
    }
    ,
    C_MAINTAINABILITY_ANALYSIS(15097){

        public String toString() {
            return "C Maintainability Report";
        }
    }
    ,
    C_DEPTH_COMPLEXITY_ANALYSIS(15098){

        public String toString() {
            return "C Depth Complexity Report";
        }
    }
    ,
    SYSTEM_USAGE_ANALYSIS(15099){

        public String toString() {
            return "SAP System Usage";
        }
    }
    ,
    C_CALLGRAPH_ANALYSIS(15100){

        public String toString() {
            return "C CallGraph Analysis";
        }
    }
    ,
    VERIFY_LICENSE_FOR_LOCAL_ANALYSIS(15101){

        public String toString() {
            return "Verify license for local analysis";
        }
    }
    ,
    MANUAL_DOWNLOAD_ANALYSIS(15102){

        public String toString() {
            return "Manual download from SAP Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_HALSTEAD_ANALYSIS(15103){

        public String toString() {
            return "Report Halstead Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_CYCLOMATIC_ANALYSIS(15104){

        public String toString() {
            return "Report Cyclomatic Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_MAINTAINABILITY_ANALYSIS(15105){

        public String toString() {
            return "Report Maintainability Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_WEIGHT_ANALYSIS(15106){

        public String toString() {
            return "Heuristic Report";
        }
    }
    ,
    EZSOURCE_EZREPORT_UNUSEDPROGRAMS_ANALYSIS(15107){

        public String toString() {
            return "Unreferenced Programs";
        }
    }
    ,
    EZSOURCE_EZREPORT_UNUSEDPROCEDURES_ANALYSIS(15108){

        public String toString() {
            return "Report Unused Routines Within Programs Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_BACKWARDCHAINS_ANALYSIS(15109){

        public String toString() {
            return "Report Backward Call Chains Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_FORWARDCHAINS_ANALYSIS(15110){

        public String toString() {
            return "Report Forward Call Chains Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DATASETFLOW_ANALYSIS(15111){

        public String toString() {
            return "Report Dataset Flow Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_FIELDRENAMING_ANALYSIS(15112){

        public String toString() {
            return "Field Usage Report";
        }
    }
    ,
    EZSOURCE_EZREPORT_FIELDEXPANSION_ANALYSIS(15113){

        public String toString() {
            return "Field Expansion Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_FIELDIMPACT_ANALYSIS(15114){

        public String toString() {
            return "Impact Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_ADABAS_VS_PROGRAMS_ANALYSIS(15115){

        public String toString() {
            return "Adabas VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_ADABAS_ANALYSIS(15116){

        public String toString() {
            return "Programs VS Adabas Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_FILES_VS_PROGRAMS_ANALYSIS(15117){

        public String toString() {
            return "File VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_FILES_VS_DDCL_ELEMENTS_ANALYSIS(15118){

        public String toString() {
            return "Report File VS DDCL Elements Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_FILES_ANALYSIS(15119){

        public String toString() {
            return "Programs VS Files Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_IDMS_RECORDS_ANALYSIS(15120){

        public String toString() {
            return "Programs VS IDMS Records Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_IDMS_SETS_ANALYSIS(15121){

        public String toString() {
            return "Programs VS IDMS Sets Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_VARIABLES_ANALYSIS(15122){

        public String toString() {
            return "Programs VS Variables Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_STRING_LITERALS_ANALYSIS(15123){

        public String toString() {
            return "Programs VS String Literals Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_MQUEUES_ANALYSIS(15124){

        public String toString() {
            return "Programs VS MQueues Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_MQUEUES_VS_PROGRAMS_ANALYSIS(15125){

        public String toString() {
            return "MQueues VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_INCLUDES_VS_PROGRAMS_ANALYSIS(15126){

        public String toString() {
            return "Includes VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_INCLUDES_ANALYSIS(15127){

        public String toString() {
            return "Programs VS Includes Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SQLTABLES_VS_PROGRAMS_ANALYSIS(15128){

        public String toString() {
            return "SQL Tables VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_SQLTABLES_ANALYSIS(15129){

        public String toString() {
            return "Programs VS SQL Tables Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMSUMMARY_ANALYSIS(15130){

        public String toString() {
            return "Programs Inventory Report";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROJECTINVENTORY_ANALYSIS(15131){

        public String toString() {
            return "Project Inventory Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_APPLICATIONINVENTORY_ANALYSIS(15132){

        public String toString() {
            return "Report Application Inventory Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_MISSINGRESOURCES_ANALYSIS(15133){

        public String toString() {
            return "Missing Components Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SHAREDRESOURCES_ANALYSIS(15134){

        public String toString() {
            return "Report Shared Resources Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_MEMBERSINVENTORY_ANALYSIS(15135){

        public String toString() {
            return "Report Members Inventory Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_COMPAREPROJECTS_ANALYSIS(15136){

        public String toString() {
            return "Report Compare Projects Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_COMPAREAPPLICATIONS_ANALYSIS(15137){

        public String toString() {
            return "Report Compare Applications Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_MAINFRAME_RUNTIME_PERFORMANCE_ANALYSIS(15138){

        public String toString() {
            return "Report Mainframe Runtime Performance Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_CLFILES_VS_CLPROGRAMS_ANALYSIS(15139){

        public String toString() {
            return "Report CL Files VS CL Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PRINTERFILES_VS_PROGRAMS_ANALYSIS(15140){

        public String toString() {
            return "Report Printer Files VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DATACOM_TABLES_VS_PROGRAMS_ANALYSIS(15141){

        public String toString() {
            return "Datacom Tables VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_FILES_VS_SCL_ANALYSIS(15142){

        public String toString() {
            return "Report File VS SCL Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SCL_VS_FILES_ANALYSIS(15143){

        public String toString() {
            return "Report SCL VS Files Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_FILES_ANALYSIS(15144){

        public String toString() {
            return "Report DDCL Elements VS Files Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_RECORDS_ANALYSIS(15145){

        public String toString() {
            return "Report DDCL Elements VS Records Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_RECORD_GROUPS_ANALYSIS(15146){

        public String toString() {
            return "Report DDCL Elements VS Record Groups Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DDCL_ELEMENTS_VS_SETS_ANALYSIS(15147){

        public String toString() {
            return "Report DDCL Elements VS Sets Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_IDMS_RECORDS_VS_PROGRAMS_ANALYSIS(15148){

        public String toString() {
            return "IDMS Records VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_IDMS_SETS_VS_PROGRAMS_ANALYSIS(15149){

        public String toString() {
            return "IDMS Sets VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_IDMSX_RECORDS_VS_PROGRAMS_ANALYSIS(15150){

        public String toString() {
            return "Report IDMSX Records VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_IDMSX_SETS_VS_PROGRAMS_ANALYSIS(15151){

        public String toString() {
            return "Report IDMSX Sets VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_IMSDB_VS_PROGRAMS_ANALYSIS(15152){

        public String toString() {
            return "Report IMS/DB VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_LOGICAL_FILES_VS_PROGRAMS_ANALYSIS(15153){

        public String toString() {
            return "Report Logical Files VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_CL_PROGRAMS_VS_CL_FILES_ANALYSIS(15154){

        public String toString() {
            return "Report CL Programs VS CL Files Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_PRINTER_FILES_ANALYSIS(15155){

        public String toString() {
            return "Report Programs VS Printer Files Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_DATACOM_TABLES_ANALYSIS(15156){

        public String toString() {
            return "Programs VS Datacom Tables Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_IDMSX_RECORDS_ANALYSIS(15157){

        public String toString() {
            return "Report Programs VS IDMSX Records Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_IDMSX_SETS_ANALYSIS(15158){

        public String toString() {
            return "Report Programs VS IDMSX Sets Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_IMSDB_ANALYSIS(15159){

        public String toString() {
            return "Report Programs VS IMS/DB Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_LOGICAL_FILES_ANALYSIS(15160){

        public String toString() {
            return "Report Programs VS Logical Files Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_SMART_SCREENS_ANALYSIS(15161){

        public String toString() {
            return "Report Programs VS SMART Screens Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_SMART_TABLES_ANALYSIS(15162){

        public String toString() {
            return "Report Programs VS SMART Tables Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_RECORDS_VS_DDCL_ELEMENTS_ANALYSIS(15163){

        public String toString() {
            return "Report Records VS DDCL Elements Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_RECORD_GROUPS_VS_DDCL_ELEMENTS_ANALYSIS(15164){

        public String toString() {
            return "Report Record Groups VS DDCL Elements Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SETS_VS_DDCL_ELEMENTS_ANALYSIS(15165){

        public String toString() {
            return "Report Sets VS DDCL Elements Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SMART_SCREENS_VS_PROGRAMS_ANALYSIS(15166){

        public String toString() {
            return "Report SMART Screens VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SMART_TABLES_VS_PROGRAMS_ANALYSIS(15167){

        public String toString() {
            return "Report SMART Tables VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DDCL_ELEMENT_INVENTORY_ANALYSIS(15168){

        public String toString() {
            return "Report DDCL Element Inventory Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DDCL_PROJECT_INVENTORY_ANALYSIS(15169){

        public String toString() {
            return "Report DDCL Project Inventory Report Analysis";
        }
    }
    ,
    EZSOURCE_PROGRAM_FLOW_ANALYSIS(15170){

        public String toString() {
            return "Program Flow Analysis";
        }
    }
    ,
    EZSOURCE_MAINFRAME_ANALYSIS(15171){

        public String toString() {
            return "Mainframe Layout";
        }
    }
    ,
    EZSOURCE_JOB_CALLGRAPH_ANALYSIS(15172){

        public String toString() {
            return "Job Callgraph Analysis";
        }
    }
    ,
    EZSOURCE_FLOW_CHART_ANALYSIS(15173){

        public String toString() {
            return "Flow Chart Analysis";
        }
    }
    ,
    EZSOURCE_DATASETFLOW_GRAPH_ANALYSIS(15174){

        public String toString() {
            return "Dataset Flow Graph Analysis";
        }
    }
    ,
    CUSTOM_CODE_UPDATE_ANALYSIS(15175){

        public String toString() {
            return "Update Custom Code Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SQLBACKWARDCHAINS_ANALYSIS(15176){

        public String toString() {
            return "Report SQL Backward Call Chains Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_JOBFLOW_ANALYSIS(15177){

        public String toString() {
            return "Documentation JobFlow Report Analysis";
        }
    }
    ,
    EZSOURCE_JOB_FLOWGRAPH_ANALYSIS(15178){

        public String toString() {
            return "Job Flowgraph Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_RULE_BASED_ANALYSIS(15179){

        public String toString() {
            return "Report Rule Based Analysis";
        }
    }
    ,
    EZSOURCE_PROGRAM_CALLGRAPH_ANALYSIS(15180){

        public String toString() {
            return "Program Callgraph Analysis";
        }
    }
    ,
    EZSOURCE_SCREEN_CALLGRAPH_ANALYSIS(15181){

        public String toString() {
            return "Screen Callgraph Analysis";
        }
    }
    ,
    EZSOURCE_TRANSACTION_CALLGRAPH_ANALYSIS(15182){

        public String toString() {
            return "Transaction Callgraph Analysis";
        }
    }
    ,
    EZSOURCE_SHAREDRESOURCES_ANALYSIS(15183){

        public String toString() {
            return "Shared Resources Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_JOBS_VS_SQLTABLES_ANALYSIS(15184){

        public String toString() {
            return "Jobs VS SQL Tables Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_SQLTABLES_VS_JOBS_ANALYSIS(15185){

        public String toString() {
            return "SQL Tables VS Jobs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_JOBS_VS_DATASETS_ANALYSIS(15186){

        public String toString() {
            return "Jobs VS Datasets Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DATASETS_VS_JOBS_ANALYSIS(15187){

        public String toString() {
            return "Datasets VS Jobs Report Analysis";
        }
    }
    ,
    EZSOURCE_SAPIENS_GRAPH_ANALYSIS(15188){

        public String toString() {
            return "Sapiens Graph Analysis";
        }
    }
    ,
    EZSOURCE_APPLICATION_MASTER_GRAPH_ANALYSIS(15189){

        public String toString() {
            return "Application Master Graph Analysis";
        }
    }
    ,
    ABAP_TABLES_DIAGRAM(15190){

        public String toString() {
            return "ABAP Tables Diagram";
        }
    }
    ,
    ABAP_TIMELINE_ISSUES_REPORT(15191){

        public String toString() {
            return "ABAP Timeline Issues Report";
        }
    }
    ,
    ABAP_TIMELINE_CALL_GRAPH(15192){

        public String toString() {
            return "ABAP Timeline Callgraph";
        }
    }
    ,
    ABAP_TIMELINE_BATCH_CALL_GRAPH(15193){

        public String toString() {
            return "ABAP Timeline Batch Callgraph";
        }
    }
    ,
    SQL_TABLES_USAGE_ACTION(15194){

        public String toString() {
            return "SQL Tables Usage Action";
        }
    }
    ,
    TPMSX_USAGE_ACTION(15195){

        public String toString() {
            return "TPMSX Usage action";
        }
    }
    ,
    IDMS_TABLES_USAGE_ACTION(15196){

        public String toString() {
            return "IDMS Usage action";
        }
    }
    ,
    INCLUDE_USAGE_ACTION(15197){

        public String toString() {
            return "Include Usage Action";
        }
    }
    ,
    FILES_USAGE_ACTION(15198){

        public String toString() {
            return "Files Usage action";
        }
    }
    ,
    COBOL_USAGE_ACTION(15199){

        public String toString() {
            return "Cobol Usage Action";
        }
    }
    ,
    IDMS_USAGE_ACTION(15200){

        public String toString() {
            return "IDMS Usage Action";
        }
    }
    ,
    IDMSX_USAGE_ACTION(15201){

        public String toString() {
            return "IDMSX Usage action";
        }
    }
    ,
    NATURAL_USAGE_ACTION(15202){

        public String toString() {
            return "Natural Usage Action";
        }
    }
    ,
    PL1_USAGE_ACTION(15203){

        public String toString() {
            return "Pl1 Usage Action";
        }
    }
    ,
    EZSOURCE_EZREPORT_VSAMFILE_ANALYSIS(15204){

        public String toString() {
            return "Datasets Record Structure";
        }
    }
    ,
    ASSEMBLER_USAGE_ACTION(15205){

        public String toString() {
            return "Assembler Usage Action";
        }
    }
    ,
    DATASET_USAGE_ACTION(15206){

        public String toString() {
            return "Dataset Usage In Program Action";
        }
    }
    ,
    BATCH_USAGE_ACTION(15207){

        public String toString() {
            return "Dataset Usage In Job Action";
        }
    }
    ,
    CA7_MACROVIEW_ACTION(15208){

        public String toString() {
            return "CA7 MacroView";
        }
    }
    ,
    CA7_BROWSE_ACTION(15209){

        public String toString() {
            return "CA7 Search";
        }
    }
    ,
    CA7_PATH_ACTION(15210){

        public String toString() {
            return "CA7 Critical Path";
        }
    }
    ,
    PGM_IN_JOB_USAGE_ACTION(15211){

        public String toString() {
            return "Pgm Usage In Job Action";
        }
    }
    ,
    PROC_IN_JOB_USAGE_ACTION(15212){

        public String toString() {
            return "Proc Usage In Job Action";
        }
    }
    ,
    JOB_DS_USAGE_ACTION(15213){

        public String toString() {
            return "Job Usage Datasets Action";
        }
    }
    ,
    SCL_USAGE_ACTION(15214){

        public String toString() {
            return "SCL Usage action";
        }
    }
    ,
    DDCL_USAGE_ACTION(15215){

        public String toString() {
            return "DDCL Usage action";
        }
    }
    ,
    EZSOURCE_EZREPORT_UNUSEDDDCLELEMENTS_ANALYSIS(15216){

        public String toString() {
            return "Report Unused DDCL Elements Report Analysis";
        }
    }
    ,
    OPENTP_USAGE_ACTION(15217){

        public String toString() {
            return "OpenTP Usage action";
        }
    }
    ,
    EZSOURCE_DDCLBackwardChainsReport_ANALYSIS(15218){

        public String toString() {
            return "DDCL Backward Chains Report Analysis";
        }
    }
    ,
    EZSOURCE_DDCLForwardChainsReport_ANALYSIS(15219){

        public String toString() {
            return "DDCL Forward Chains Report Analysis";
        }
    }
    ,
    FILES_IN_DDCL_USAGE_ACTION(15220){

        public String toString() {
            return "Files in DDCL Usage action";
        }
    }
    ,
    EZSOURCE_CA7_GRAPH_ANALYSIS(15221){

        public String toString() {
            return "CA7 Job Triggering Flow Analysis";
        }
    }
    ,
    EZSOURCE_CA7_PATH_GRAPH_ANALYSIS(15222){

        public String toString() {
            return "CA7 Path Analysis";
        }
    }
    ,
    MAINFRAME_PROJECT_EXPLORE_ANALYSIS(15223){

        public String toString() {
            return "Explore Mainframe project";
        }
    }
    ,
    EZSOURCE_TWS_GRAPH_ANALYSIS(15224){

        public String toString() {
            return "TWS Graph Analysis";
        }
    }
    ,
    IMSDB_USAGE_ACTION(15225){

        public String toString() {
            return "IMSDB Usage action";
        }
    }
    ,
    MQ_USAGE_ACTION(15226){

        public String toString() {
            return "MQ Usage Action";
        }
    }
    ,
    ADABAS_USAGE_ACTION(15227){

        public String toString() {
            return "Adabas Usage Action";
        }
    }
    ,
    MAINFRAME_PROJECT_SRUCTURE_ANALYSIS(15228){

        public String toString() {
            return "Mainframe project structure";
        }
    }
    ,
    MAINFRAME_PROJECT_SEARCH_IN_FILES(15229){

        public String toString() {
            return "Search in file";
        }
    }
    ,
    FILE_USAGE_ACTION(15230){

        public String toString() {
            return "File Usage In Program action";
        }
    }
    ,
    DDCL_DICTIONARY_USAGE_ACTION(15231){

        public String toString() {
            return "DDCL Dictionary usage action";
        }
    }
    ,
    DAL_USAGE_ACTION(15232){

        public String toString() {
            return "DAL Usage Action";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_DAL_ANALYSIS(15233){

        public String toString() {
            return "Mainframe Programs VS DAL Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_DAL_VS_PROGRAMS_ANALYSIS(15234){

        public String toString() {
            return "Mainframe DAL VS Programs Report Analysis";
        }
    }
    ,
    SQL_TABLE_FIELDS_USAGE_ACTION(15235){

        public String toString() {
            return "SQL Table Fields Usage Action";
        }
    }
    ,
    EZSOURCE_NETWORKVSJOB_REPORT_ANALYSIS(15236){

        public String toString() {
            return "Network vs job Report";
        }
    }
    ,
    EZSOURCE_JOBVSNETWORK_REPORT_ANALYSIS(15237){

        public String toString() {
            return "Job vs network Report";
        }
    }
    ,
    COBOL_VARIABLE_USAGE_ACTION(15238){

        public String toString() {
            return "Cobol Variable Usage Action";
        }
    }
    ,
    DBI_USAGE_ACTION(15239){

        public String toString() {
            return "DBI Table Usage Action";
        }
    }
    ,
    EZSOURCE_EZREPORT_DBI_VS_PROGRAMS_ANALYSIS(15240){

        public String toString() {
            return "Mainframe DBI Table VS Programs Report Analysis";
        }
    }
    ,
    EZSOURCE_EZREPORT_PROGRAMS_VS_DBI_ANALYSIS(15241){

        public String toString() {
            return "Mainframe Programs VS DBI Table Report Analysis";
        }
    }
    ,
    JAVA_WU_SQLTable_REPORT_ANALYSIS(15242){

        public String toString() {
            return "Java Where Used SQL Table Report";
        }
    }
    ,
    JAVA_DEAD_CODE_REPORT_ANALYSIS(15243){

        public String toString() {
            return "Java Dead Code Report";
        }
    }
    ,
    ASSEMBLER_VARIABLE_USAGE_ACTION(15244){

        public String toString() {
            return "Assembler Variable Usage Action";
        }
    }
    ,
    PL1_VARIABLE_USAGE_ACTION(15245){

        public String toString() {
            return "PL1 Variable Usage Action";
        }
    }
    ,
    NATURAL_VARIABLE_USAGE_ACTION(15246){

        public String toString() {
            return "Natural Variable Usage Action";
        }
    }
    ,
    EZSOURCE_AAUTO_GRAPH_ANALYSIS(15247){

        public String toString() {
            return "AAuto Graph";
        }
    }
    ,
    EZSOURCE_AAUTO_REPORT_ANALYSIS(15248){

        public String toString() {
            return "AAuto Network Dependency Report";
        }
    }
    ,
    MAINFRAME_PROJECT_COBOL_SOURCE_ANALYSIS(15249){

        public String toString() {
            return "Cobol Source Analysis";
        }
    }
    ,
    DATACOM_USAGE_ACTION(15250){

        public String toString() {
            return "Datacom Usage Action";
        }
    }
    ,
    CREATE_EZANNOTATION(15251){

        public String toString() {
            return "Create Annotation Analysis";
        }
    }
    ,
    FIND_EZANNOTATION(15252){

        public String toString() {
            return "Find Annotation Analysis";
        }
    }
    ,
    ADD_MANUAL_RESOLUTION(15253){

        public String toString() {
            return "Override Resolution Analysis";
        }
    }
    ,
    MAINFRAME_PROJECT_ANALYSIS_RESOLUTIONS(15254){

        public String toString() {
            return "Resolutions Management Analysis";
        }
    }
    ,
    EZSOURCE_GDB_JOB_CALLGRAPH_ANALYSIS(15255){

        public String toString() {
            return "Job Callgraph Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_DATASETFLOW_GRAPH_ANALYSIS(15256){

        public String toString() {
            return "Dataset Flow Graph (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_PROGRAM_CALLGRAPH_ANALYSIS(15257){

        public String toString() {
            return "Program Call Graph (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_PROGRAM_FLOW_ANALYSIS(15258){

        public String toString() {
            return "Program Flow Graph (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_SCREEN_CALLGRAPH_ANALYSIS(15259){

        public String toString() {
            return "Screen Call Graph (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_EZREPORT_BACKWARDCHAINS_ANALYSIS(15260){

        public String toString() {
            return "Backward Call Chains Report Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_EZREPORT_FORWARDCHAINS_ANALYSIS(15261){

        public String toString() {
            return "Forward Call Chains Report Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_SQLBACKWARDCHAINS_ANALYSIS(15262){

        public String toString() {
            return "SQL Bacward Call Chains Report Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_TRANSACTION_CALLGRAPH_ANALYSIS(15263){

        public String toString() {
            return "Transaction Call Graph Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_MAINFRAME_SCREEN_LAYOUT_ANALYSIS(15264){

        public String toString() {
            return "Screen Layout Analysis (mainframe)";
        }
    }
    ,
    EZSOURCE_GDB_IMPACT_GRAPH_ANALYSIS(15265){

        public String toString() {
            return "Impact Graph Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_GDB_EZREPORT_DATASETFLOW_ANALYSIS(15266){

        public String toString() {
            return "Dataset Flow Report Analysis (graphdb)";
        }
    }
    ,
    EZSOURCE_MAINFRAME_REPORT_PROGRAMS_VS_IMSSEGMENT_ANALYSIS(15267){

        public String toString() {
            return "Programs VS IMS Segments Report Analysis";
        }
    }
    ,
    EZSOURCE_MAINFRAME_REPORT_IMSSEGMENT_VS_PROGRAMS_ANALYSIS(15268){

        public String toString() {
            return "IMS Segments VS Programs Report Analysis";
        }
    }
    ,
    IMSDB_PHYSICAL_USAGE_ANALYSIS_ACTION(15269){

        public String toString() {
            return "IMSD/DB usage Action";
        }
    }
    ,
    IMSDB_STRUCTURE_ACTION(15270){

        public String toString() {
            return "IMS/DB Structure Action";
        }
    }
    ,
    IMSDB_LOGICAL_USAGE_ANALYSIS_ACTION(15271){

        public String toString() {
            return "IMSD/DB logical usage Action";
        }
    }
    ,
    EZSOURCE_IMPACT_BASE_MODEL_ANALYSIS(15272){

        public String toString() {
            return "Impact Analysis for PL/1 (graphdb)";
        }
    }
    ,
    EZSOURCE_EZREPORT_GRAPHDB_IMPACT_ANALYSIS(15273){

        public String toString() {
            return "Report Impact Report Analysis in GraphDB";
        }
    }
    ,
    EZ_API_CALLGRAPH_ANALYSIS(15274){

        public String toString() {
            return "API Graph Analysis";
        }
    }
    ,
    EZ_API_USAGE_ANALYSIS(15275){

        public String toString() {
            return "API Usage Analysis";
        }
    }
    ,
    EZSOURCE_GDB_CROSS_CALLGRAPH_ANALYSIS(15276){

        public String toString() {
            return "API Cross Applications Callgraph";
        }
    }
    ,
    EZ_CROSS_APPS_SRV_CALL_GRAPH(15277){

        public String toString() {
            return "Cross Applications Callgraph";
        }
    }
    ,
    CONTROLM_GRAPH_ANALYSIS(15278){

        public String toString() {
            return "Control-M Graph Analysis";
        }
    }
    ,
    JAVA_WAZI_CALL_GRAPH(15279){

        public String toString() {
            return "Java Wazi Call Graph Analysis";
        }
    }
    ,
    JAVA_WAZI_CROSS_CALL_GRAPH(15279){

        public String toString() {
            return "Cross Java Wazi To Mainframe Call Graph Analysis";
        }
    }
    ,
    JAVA_WAZI_EXPLORE(15280){

        public String toString() {
            return "Java Wazi Explore Analysis";
        }
    }
    ,
    EZSOURCE_CTRLM_EXPLORE_ANALYSIS(15281){

        public String toString() {
            return "Control-M Explore Graph";
        }
    }
    ,
    CTRLM_USAGE_ACTION(15282){

        public String toString() {
            return "Control-M Usage Action";
        }
    };

    private static final Logger L;
    private Integer operationCode;
    private static final Map<Integer, AnalysisType> opCodeToAnalysisType;

    static {
        L = LoggerFactory.getLogger(AnalysisType.class);
        opCodeToAnalysisType = new HashMap<Integer, AnalysisType>();
        AnalysisType[] analysisTypeArray = AnalysisType.values();
        int n = analysisTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AnalysisType aType = analysisTypeArray[n2];
            opCodeToAnalysisType.put(aType.getOperationCode(), aType);
            ++n2;
        }
    }

    private AnalysisType(Integer operationCode) {
        this.operationCode = operationCode;
    }

    public Integer getOperationCode() {
        return this.operationCode;
    }

    public static AnalysisType fromOpCode(Integer opCode) {
        AnalysisType aType = opCodeToAnalysisType.get(opCode);
        if (aType == null) {
            L.warn("Invalid operationCode: " + opCode);
        }
        return aType;
    }

    /* synthetic */ AnalysisType(String string, int n, Integer n2, AnalysisType analysisType) {
        this(n2);
    }
}

