/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.wizard.pages;

import com.ez.common.ui.guielements.DatePicker;
import com.ez.common.ui.swt.DpiScaler;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.TWSUtils;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSGraphFirstPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TWSGraphFirstPage.class);
    private boolean good = true;
    private DatePicker startDate;
    private DatePicker endDate;
    private Button backwardButton;
    private Button forwardButton;
    private Button bothButton;
    private Button limitCgButton;
    private Spinner thresholdLimit;
    private Label thresholdLimitLbl;
    private Button usedateBtn;
    private Button filterInputsBtn;
    private Button jobInptBtn;
    private Text jobInpText;
    private Button appInptBtn;
    private Text appInpText;
    private Button groupByAppButton;
    private Button noExportButton;
    private Button currentGBtn;
    private Button allGBtn;
    private String limitGraphLblText = null;
    private boolean useInputsFilter;
    private static final int MAX_LEVEL = 100;

    public TWSGraphFirstPage(String pageName, boolean useInputsFilter) {
        super(pageName);
        this.useInputsFilter = useInputsFilter;
    }

    protected void createContent(Composite composite) {
        FilterInputsListener listener = new FilterInputsListener();
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = DpiScaler.getScaledSize((int)30);
        composite.setLayout((Layout)gl);
        if (!this.useInputsFilter) {
            this.createFilterInputsGroup(composite, listener);
        }
        this.createRangeOfDatesGroup(composite, listener);
        ChoiceSelection cs = new ChoiceSelection();
        this.createOptionsGroup(composite, cs);
        if (TWSUtils.hasExportCsvOption()) {
            this.createExportGroup(composite, listener);
        }
    }

    private void createRangeOfDatesGroup(Composite composite, Listener listener) {
        Group dateGroup = new Group(composite, 0);
        dateGroup.setText(Messages.getString(TWSGraphFirstPage.class, (String)"date.group.text"));
        dateGroup.setLayout((Layout)new RowLayout(512));
        dateGroup.setLayoutData((Object)new GridData(768));
        this.usedateBtn = new Button((Composite)dateGroup, 32);
        this.usedateBtn.setText(Messages.getString(TWSGraphFirstPage.class, (String)"use.dates.btn"));
        this.usedateBtn.addListener(13, listener);
        Composite dateBoundSelectionComp = new Composite((Composite)dateGroup, 0);
        dateBoundSelectionComp.setLayout((Layout)new RowLayout());
        Label lbl = new Label(dateBoundSelectionComp, 0);
        lbl.setText(Messages.getString(TWSGraphFirstPage.class, (String)"from.label"));
        this.startDate = new DatePicker(dateBoundSelectionComp, 2052);
        this.startDate.addModifyListener((ModifyListener)new CalendarFocusAdapter(this.startDate));
        this.startDate.setEnabled(false);
        Label lblTo = new Label(dateBoundSelectionComp, 0);
        lblTo.setText(Messages.getString(TWSGraphFirstPage.class, (String)"to.label"));
        this.endDate = new DatePicker(dateBoundSelectionComp, 2052);
        this.endDate.addModifyListener((ModifyListener)new CalendarFocusAdapter(this.endDate));
        this.endDate.setEnabled(false);
    }

    private void createFilterInputsGroup(Composite composite, Listener listener) {
        Group inputsGroup = new Group(composite, 0);
        inputsGroup.setText(Messages.getString(TWSGraphFirstPage.class, (String)"inputs.group.text"));
        inputsGroup.setLayout((Layout)new RowLayout(512));
        inputsGroup.setLayoutData((Object)new GridData(768));
        this.filterInputsBtn = new Button((Composite)inputsGroup, 32);
        this.filterInputsBtn.setText(Messages.getString(TWSGraphFirstPage.class, (String)"filter.inputs.btn"));
        this.filterInputsBtn.addListener(13, listener);
        Composite jobOrApplicationFilterComp = new Composite((Composite)inputsGroup, 0);
        jobOrApplicationFilterComp.setLayout((Layout)new RowLayout());
        this.jobInptBtn = new Button(jobOrApplicationFilterComp, 16);
        this.jobInptBtn.setText(Messages.getString(TWSGraphFirstPage.class, (String)"job.inpt.btn"));
        this.jobInptBtn.setEnabled(false);
        this.jobInptBtn.setSelection(true);
        this.jobInptBtn.addListener(13, listener);
        this.jobInpText = new Text(jobOrApplicationFilterComp, 2048);
        this.jobInpText.setEnabled(false);
        this.jobInpText.addListener(2, listener);
        this.jobInpText.addListener(4, listener);
        this.appInptBtn = new Button(jobOrApplicationFilterComp, 16);
        this.appInptBtn.setText(Messages.getString(TWSGraphFirstPage.class, (String)"app.inpt.btn"));
        this.appInptBtn.setEnabled(false);
        this.appInptBtn.addListener(13, listener);
        this.appInpText = new Text(jobOrApplicationFilterComp, 2048);
        this.appInpText.setEnabled(false);
        this.appInpText.addListener(2, listener);
        this.appInpText.addListener(4, listener);
    }

    private void createOptionsGroup(Composite parent, ChoiceSelection cs) {
        Group optionsGroup = new Group(parent, 0);
        optionsGroup.setText(Messages.getString(TWSGraphFirstPage.class, (String)"graph.options.group"));
        RowLayout optionsGroupLayout = new RowLayout(512);
        optionsGroupLayout.spacing = DpiScaler.getScaledSize((int)7);
        optionsGroup.setLayout((Layout)optionsGroupLayout);
        optionsGroup.setLayoutData((Object)new GridData(768));
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        Composite limitToLevelsComp = new Composite((Composite)optionsGroup, 0);
        limitToLevelsComp.setLayout((Layout)new RowLayout());
        this.limitCgButton = new Button(limitToLevelsComp, 32);
        if (this.limitGraphLblText != null) {
            this.limitCgButton.setText(this.limitGraphLblText);
        } else {
            this.limitCgButton.setText(Messages.getString(TWSGraphFirstPage.class, (String)"limit.cg.btn.txt"));
        }
        this.limitCgButton.addSelectionListener((SelectionListener)cs);
        this.limitCgButton.setSelection(isLimited);
        this.wizard.set("is graph limited", (Object)isLimited);
        this.thresholdLimit = new Spinner(limitToLevelsComp, 2048);
        this.thresholdLimit.setSelection(levelLimit);
        this.thresholdLimit.setMinimum(1);
        this.thresholdLimit.setMaximum(100);
        this.thresholdLimit.setToolTipText(Messages.getString(TWSGraphFirstPage.class, (String)"level.thresold.error", (Object[])new String[]{String.valueOf(100)}));
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TWSGraphFirstPage.this.wizard.set("limit number for graph levels", (Object)TWSGraphFirstPage.this.thresholdLimit.getSelection());
            }
        });
        this.thresholdLimitLbl = new Label(limitToLevelsComp, 0);
        this.thresholdLimitLbl.setText(Messages.getString(TWSGraphFirstPage.class, (String)"level.threshold.txt"));
        this.thresholdLimitLbl.setEnabled(isLimited);
        this.thresholdLimit.setEnabled(isLimited);
        Accessible accessible = this.thresholdLimit.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                super.getName(e);
                e.result = Messages.getString(TWSGraphFirstPage.class, (String)"level.threshold.txt.jaws", (Object[])new String[]{TWSGraphFirstPage.this.thresholdLimit.getText()});
            }
        });
        Composite directionSelectionComp = new Composite((Composite)optionsGroup, 0);
        directionSelectionComp.setLayout((Layout)new RowLayout());
        this.forwardButton = new Button(directionSelectionComp, 16);
        this.forwardButton.setText(Messages.getString(TWSGraphFirstPage.class, (String)"forward.btn.txt"));
        this.forwardButton.addSelectionListener((SelectionListener)cs);
        this.forwardButton.setData((Object)Direction.FORWARD);
        this.forwardButton.setSelection(true);
        this.wizard.set("graph direction: forward or backward or both", (Object)Direction.FORWARD);
        this.backwardButton = new Button(directionSelectionComp, 16);
        this.backwardButton.setText(Messages.getString(TWSGraphFirstPage.class, (String)"backward.btn.txt"));
        this.backwardButton.addSelectionListener((SelectionListener)cs);
        this.backwardButton.setData((Object)Direction.BACKWARD);
        this.backwardButton.setSelection(false);
        this.bothButton = new Button(directionSelectionComp, 16);
        this.bothButton.setText(Messages.getString(TWSGraphFirstPage.class, (String)"both.btn.txt"));
        this.bothButton.addSelectionListener((SelectionListener)cs);
        this.bothButton.setData((Object)Direction.BOTH);
        this.bothButton.setSelection(false);
        this.groupByAppButton = new Button((Composite)optionsGroup, 32);
        this.groupByAppButton.setText(Messages.getString(TWSGraphFirstPage.class, (String)"app.group.lbl"));
        SelectionAdapter groupByAppListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button b = (Button)e.getSource();
                TWSGraphFirstPage.this.wizard.set("group jobs by app", (Object)b.getSelection());
            }
        };
        this.groupByAppButton.addSelectionListener((SelectionListener)groupByAppListener);
        boolean defaultValuueGroupBy = true;
        this.groupByAppButton.setSelection(defaultValuueGroupBy);
        this.wizard.set("group jobs by app", (Object)defaultValuueGroupBy);
        this.forwardButton.getAccessible().addRelation(9, optionsGroup.getAccessible());
        this.backwardButton.getAccessible().addRelation(9, optionsGroup.getAccessible());
        this.bothButton.getAccessible().addRelation(9, optionsGroup.getAccessible());
        this.groupByAppButton.getAccessible().addRelation(9, optionsGroup.getAccessible());
    }

    private void createExportGroup(Composite composite, Listener listener) {
        Group exportGroup = new Group(composite, 0);
        exportGroup.setText(Messages.getString(TWSGraphFirstPage.class, (String)"export.group.lbl"));
        exportGroup.setLayout((Layout)new GridLayout());
        exportGroup.setLayoutData((Object)new GridData(768));
        Composite exportComp = new Composite((Composite)exportGroup, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 3;
        exportComp.setLayoutData((Object)new GridData());
        exportComp.setLayout((Layout)gl);
        this.noExportButton = new Button(exportComp, 16);
        this.noExportButton.setText("no export");
        this.noExportButton.addListener(13, listener);
        this.noExportButton.setSelection(true);
        this.currentGBtn = new Button(exportComp, 16);
        this.currentGBtn.setText("export current graph");
        this.currentGBtn.addListener(13, listener);
        this.allGBtn = new Button(exportComp, 16);
        this.allGBtn.setText("export all graphs");
        this.allGBtn.addListener(13, listener);
        this.wizard.set("InternalEXportCSVOption", (Object)"no export");
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean canFlipToNextPage() {
        boolean canFlipToNextPage = true;
        if (this.usedateBtn.getSelection()) {
            this.wizard.set("use calendar", (Object)true);
            if (!this.good) {
                return false;
            }
            if (this.wizard.getValue("start date") == null && this.wizard.getValue("end date") == null) {
                return false;
            }
        } else {
            this.wizard.set("use calendar", (Object)false);
        }
        if (this.filterInputsBtn == null) return canFlipToNextPage;
        if (!this.filterInputsBtn.getSelection()) {
            this.wizard.set("use inputs filter", (Object)false);
            return canFlipToNextPage;
        }
        if (this.jobInptBtn.getSelection()) {
            canFlipToNextPage = this.jobInpText.getText() != null && !this.jobInpText.getText().isEmpty();
            if (!canFlipToNextPage) return canFlipToNextPage;
            this.wizard.set("use inputs filter", (Object)true);
            ArrayList<String> jobsInpt = new ArrayList<String>();
            jobsInpt.add(this.jobInpText.getText());
            this.wizard.set("use job as input filter", jobsInpt);
            this.wizard.set("use app as input filter", null);
            return canFlipToNextPage;
        }
        if (!this.appInptBtn.getSelection()) {
            this.wizard.set("use inputs filter", (Object)false);
            return false;
        }
        canFlipToNextPage = this.appInpText.getText() != null && !this.appInpText.getText().isEmpty();
        if (!canFlipToNextPage) return canFlipToNextPage;
        this.wizard.set("use inputs filter", (Object)true);
        ArrayList<String> appsInpt = new ArrayList<String>();
        appsInpt.add(this.appInpText.getText());
        this.wizard.set("use app as input filter", appsInpt);
        this.wizard.set("use job as input filter", null);
        return canFlipToNextPage;
    }

    private boolean verifyDates() {
        boolean ret = false;
        Date start = this.startDate.getDate();
        Date end = this.endDate.getDate();
        if (start != null && end != null) {
            Calendar startC = Calendar.getInstance();
            startC.setTime(start);
            Calendar endC = Calendar.getInstance();
            endC.setTime(end);
            L.debug("start: " + startC.getTimeInMillis());
            L.debug("end: " + endC.getTimeInMillis());
            if (startC.before(endC)) {
                ret = true;
            }
        } else if (start != null || end != null) {
            ret = true;
        }
        return ret;
    }

    class CalendarFocusAdapter
    implements ModifyListener {
        DatePicker dt;

        public CalendarFocusAdapter(DatePicker date) {
            this.dt = date;
        }

        public void modifyText(ModifyEvent e) {
            boolean refresh = false;
            String txt = ((Text)e.getSource()).getText();
            L.debug("new date: " + txt);
            if (TWSGraphFirstPage.this.startDate.getDate() != null || TWSGraphFirstPage.this.endDate.getDate() != null) {
                TWSGraphFirstPage.this.good = true;
                TWSGraphFirstPage.this.setMessage(null);
            }
            if (this.dt == TWSGraphFirstPage.this.startDate) {
                Date d = TWSGraphFirstPage.this.startDate.getDate();
                if (d != null) {
                    TWSGraphFirstPage.this.good = true;
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    if (TWSGraphFirstPage.this.wizard.getValue("end date") != null) {
                        TWSGraphFirstPage.this.good = TWSGraphFirstPage.this.verifyDates();
                        if (!TWSGraphFirstPage.this.good) {
                            TWSGraphFirstPage.this.setMessage(Messages.getString(TWSGraphFirstPage.class, (String)"wrongDates.error.message"), 3);
                        } else {
                            TWSGraphFirstPage.this.setMessage(null);
                        }
                        TWSGraphFirstPage.this.wizard.set("start date", (Object)c.getTime());
                    } else {
                        TWSGraphFirstPage.this.wizard.set("start date", (Object)c.getTime());
                    }
                } else {
                    TWSGraphFirstPage.this.wizard.set("start date", null);
                }
                refresh = true;
            } else if (this.dt == TWSGraphFirstPage.this.endDate) {
                Date d = TWSGraphFirstPage.this.endDate.getDate();
                if (d != null) {
                    TWSGraphFirstPage.this.good = true;
                    Calendar c = Calendar.getInstance();
                    c.setTime(d);
                    if (TWSGraphFirstPage.this.wizard.getValue("start date") != null) {
                        TWSGraphFirstPage.this.good = TWSGraphFirstPage.this.verifyDates();
                        if (!TWSGraphFirstPage.this.good) {
                            TWSGraphFirstPage.this.setMessage(Messages.getString(TWSGraphFirstPage.class, (String)"wrongDates.error.message"), 3);
                        } else {
                            TWSGraphFirstPage.this.setMessage(null);
                        }
                        TWSGraphFirstPage.this.wizard.set("end date", (Object)c.getTime());
                    } else {
                        TWSGraphFirstPage.this.wizard.set("end date", (Object)c.getTime());
                    }
                } else {
                    TWSGraphFirstPage.this.wizard.set("end date", null);
                }
                refresh = true;
            }
            if (refresh) {
                TWSGraphFirstPage.this.setPageComplete(TWSGraphFirstPage.this.isPageComplete());
            }
        }
    }

    class ChoiceSelection
    implements SelectionListener {
        ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if (!b.equals(TWSGraphFirstPage.this.limitCgButton) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                TWSGraphFirstPage.this.wizard.set("graph direction: forward or backward or both", (Object)direction);
            }
            if (b.equals(TWSGraphFirstPage.this.limitCgButton)) {
                boolean isCgLimited = TWSGraphFirstPage.this.limitCgButton.getSelection();
                TWSGraphFirstPage.this.wizard.set("is graph limited", (Object)isCgLimited);
                TWSGraphFirstPage.this.thresholdLimitLbl.setEnabled(isCgLimited);
                TWSGraphFirstPage.this.thresholdLimit.setEnabled(isCgLimited);
                if (!isCgLimited) {
                    TWSGraphFirstPage.this.wizard.set("limit number for graph levels", null);
                    TWSGraphFirstPage.this.setErrorMessage(null);
                }
            }
            TWSGraphFirstPage.this.setPageComplete(TWSGraphFirstPage.this.isPageComplete());
        }
    }

    class FilterInputsListener
    implements Listener {
        FilterInputsListener() {
        }

        public void handleEvent(Event event) {
            if (event.widget == TWSGraphFirstPage.this.usedateBtn) {
                TWSGraphFirstPage.this.startDate.setEnabled(TWSGraphFirstPage.this.usedateBtn.getSelection());
                TWSGraphFirstPage.this.endDate.setEnabled(TWSGraphFirstPage.this.usedateBtn.getSelection());
                TWSGraphFirstPage.this.getWizard().getContainer().updateButtons();
                if (TWSGraphFirstPage.this.usedateBtn.getSelection()) {
                    if (!TWSGraphFirstPage.this.good) {
                        TWSGraphFirstPage.this.setMessage(Messages.getString(TWSGraphFirstPage.class, (String)"wrongDates.error.message"), 3);
                    }
                } else {
                    TWSGraphFirstPage.this.setMessage(null);
                }
            }
            if (event.widget == TWSGraphFirstPage.this.filterInputsBtn) {
                boolean selectionVal = TWSGraphFirstPage.this.filterInputsBtn.getSelection();
                TWSGraphFirstPage.this.jobInptBtn.setEnabled(selectionVal);
                TWSGraphFirstPage.this.appInptBtn.setEnabled(selectionVal);
                this.updateFilterInpText(selectionVal);
                TWSGraphFirstPage.this.getWizard().getContainer().updateButtons();
            }
            if (event.widget == TWSGraphFirstPage.this.jobInptBtn) {
                TWSGraphFirstPage.this.getWizard().getContainer().updateButtons();
                this.updateFilterInpText(true);
            }
            if (event.widget == TWSGraphFirstPage.this.appInptBtn) {
                TWSGraphFirstPage.this.getWizard().getContainer().updateButtons();
                this.updateFilterInpText(true);
            }
            if (event.widget == TWSGraphFirstPage.this.jobInpText) {
                TWSGraphFirstPage.this.getWizard().getContainer().updateButtons();
            }
            if (event.widget == TWSGraphFirstPage.this.appInpText) {
                TWSGraphFirstPage.this.getWizard().getContainer().updateButtons();
            }
            if (event.widget == TWSGraphFirstPage.this.noExportButton && TWSGraphFirstPage.this.noExportButton.getSelection()) {
                TWSGraphFirstPage.this.wizard.set("InternalEXportCSVOption", (Object)"no export");
            }
            if (event.widget == TWSGraphFirstPage.this.currentGBtn && TWSGraphFirstPage.this.currentGBtn.getSelection()) {
                TWSGraphFirstPage.this.wizard.set("InternalEXportCSVOption", (Object)"export current graph");
            }
            if (event.widget == TWSGraphFirstPage.this.allGBtn && TWSGraphFirstPage.this.allGBtn.getSelection()) {
                TWSGraphFirstPage.this.wizard.set("InternalEXportCSVOption", (Object)"export all graphs");
            }
        }

        private void updateFilterInpText(boolean selectionVal) {
            TWSGraphFirstPage.this.jobInpText.setEnabled(TWSGraphFirstPage.this.jobInptBtn.getSelection() && selectionVal);
            TWSGraphFirstPage.this.appInpText.setEnabled(TWSGraphFirstPage.this.appInptBtn.getSelection() && selectionVal);
        }
    }
}

