/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.wizard.pages;

import com.ez.common.ui.listselection.IOperationHandler;
import com.ez.common.ui.listselection.ListChangeEvent;
import com.ez.common.ui.listselection.ListChangeListener;
import com.ez.common.ui.listselection.ListSelectionUI;
import com.ez.common.ui.listselection.Listable;
import com.ez.common.ui.listselection.WizardLongOpeerationHandler;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.model.TWSApplicationInput;
import com.ez.graphs.tws.model.TWSJob;
import com.ez.graphs.tws.preferences.PreferencesUtils;
import com.ez.graphs.tws.wizard.collectors.TWSApplicationsCollector;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class ApplicationsSelectionPage<T extends Listable>
extends SelectProgramsPage<Listable>
implements Listener {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    public int maxSelectionNumber;
    Button noRestrictButton;
    Button restrictToInptButton;
    Button additionalRestrictButton;

    public ApplicationsSelectionPage(String pageName) {
        super(pageName);
        IPreferenceStore store = PreferencesUtils.getPreferenceStore();
        this.maxSelectionNumber = store.getInt("Applications limit");
    }

    protected void createContent(Composite composite) {
        if (this.getName().equalsIgnoreCase("TWS applications page")) {
            this.createOptionsGroup(composite);
        }
        this.propertiesGroup = new ListSelectionUI.Builder(composite).useFilters(this.useFilters).operationWorker((IOperationHandler)new WizardLongOpeerationHandler(true, false, this.getWizard())).maxSelectionNumber(this.maxSelectionNumber).createInstance();
        if (this.leftLabel != null) {
            ((ListSelectionUI)this.propertiesGroup).setLeftGroupLabel(this.leftLabel);
        }
        if (this.rightLabel != null) {
            ((ListSelectionUI)this.propertiesGroup).setRightGroupLabel(this.rightLabel);
        }
        this.propertiesGroup.addChangeListener(new ListChangeListener(){

            public void listChangeEventHappend(ListChangeEvent listChangeEv) {
                List selected = ApplicationsSelectionPage.this.propertiesGroup.getSelObjectList();
                ApplicationsSelectionPage.this.wizard.set(ApplicationsSelectionPage.this.selectedPropName, (Object)selected);
                boolean enable = selected != null && selected.size() > 1;
                ApplicationsSelectionPage.this.refreshCheckBoxes(enable);
                ApplicationsSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    private void createOptionsGroup(Composite parent) {
        Composite group = new Composite(parent, parent.getStyle());
        group.setLayout((Layout)new GridLayout());
        GridData data = new GridData();
        data.horizontalIndent = 45;
        data.minimumWidth = 105;
        group.setLayoutData((Object)data);
        Group optionsComp = new Group(group, 0);
        optionsComp.setText(Messages.getString(ApplicationsSelectionPage.class, (String)"options.group"));
        data = new GridData();
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.verticalAlignment = 128;
        optionsComp.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, false);
        optionsComp.setLayout((Layout)gl);
        this.noRestrictButton = new Button((Composite)optionsComp, 16);
        this.noRestrictButton.setText(Messages.getString(ApplicationsSelectionPage.class, (String)"no.restrict.btn"));
        this.noRestrictButton.addListener(13, (Listener)this);
        this.noRestrictButton.setSelection(true);
        this.restrictToInptButton = new Button((Composite)optionsComp, 16);
        this.restrictToInptButton.setText(Messages.getString(ApplicationsSelectionPage.class, (String)"restrict.to.input.btn"));
        this.restrictToInptButton.addListener(13, (Listener)this);
        this.additionalRestrictButton = new Button((Composite)optionsComp, 16);
        this.additionalRestrictButton.setText(Messages.getString(ApplicationsSelectionPage.class, (String)"additional.app.btn"));
        this.additionalRestrictButton.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.noRestrictButton) {
            this.setPageComplete(this.noRestrictButton.getSelection());
            this.wizard.set("TWS applications selection", null);
        }
        if (event.widget == this.restrictToInptButton) {
            this.setPageComplete(this.restrictToInptButton.getSelection());
            if (this.restrictToInptButton.getSelection()) {
                List selectedJobs = this.wizard.getList("selected resources");
                List selectedApps = this.wizard.getList("TWS applications to jobs selection");
                HashSet<Integer> appIDs = new HashSet<Integer>();
                for (TWSJob job : selectedJobs) {
                    appIDs.add(job.getJoAppID());
                }
                List<Object> apps = new ArrayList();
                if (selectedApps == null) {
                    TWSApplicationsCollector collector = (TWSApplicationsCollector)this.getResourcesCollector();
                    apps = collector.getAppsInputs();
                } else {
                    for (TWSApplicationInput selectedApp : selectedApps) {
                        if (!appIDs.contains(selectedApp.getResourceID())) continue;
                        apps.add((Object)selectedApp);
                    }
                }
                this.wizard.set("TWS applications selection", apps);
            }
        }
        if (event.widget == this.additionalRestrictButton) {
            this.wizard.set("TWS applications selection", null);
            this.propertiesGroup.setReadOnly(!this.additionalRestrictButton.getSelection());
            ((ListSelectionUI)this.propertiesGroup).setSelectionReadOnly(!this.additionalRestrictButton.getSelection());
        }
    }

    public boolean isPageComplete() {
        boolean ret = false;
        if (this.getName().equalsIgnoreCase("TWS applications page")) {
            if (this.noRestrictButton.getSelection()) {
                return true;
            }
            if (this.restrictToInptButton.getSelection()) {
                return true;
            }
            if (this.additionalRestrictButton.getSelection()) {
                ret = super.isPageComplete();
            }
        } else {
            ret = super.isPageComplete();
        }
        return ret;
    }

    public boolean canFlipToNextPage() {
        boolean canFlipToNextPage = false;
        if (this.getName().equalsIgnoreCase("TWS applications page used to compute application's jobs")) {
            canFlipToNextPage = this.isPageComplete();
        }
        if (System.getProperty("test") != null && this.getName().equalsIgnoreCase("TWS applications page")) {
            canFlipToNextPage = true;
        }
        return canFlipToNextPage;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.getName().equalsIgnoreCase("TWS applications page")) {
            this.propertiesGroup.setReadOnly(true);
            ((ListSelectionUI)this.propertiesGroup).setSelectionReadOnly(!this.additionalRestrictButton.getSelection());
            this.noRestrictButton.setSelection(true);
            this.restrictToInptButton.setSelection(false);
            this.additionalRestrictButton.setSelection(false);
        }
    }
}

