/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.wizard.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.Listable;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.graphs.tws.model.TWSJob;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSJobCollector
extends BridgeResourcesCollectorAdapter<Listable> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TWSJobCollector.class);
    private List<Integer> parameters;
    private List<String> jobNameParams;

    private String getJobsQuery(EZSourceConnection conn) {
        return "select distinct TWS_Jobs.JobNumber, TWS_Jobs.JobName, TWS_Jobs.JobAppID,  TWS_Applications.ApplicationName  from TWS_Jobs inner join TWS_Applications on TWS_Applications.AppID = TWS_Jobs.JobAppID" + " where TWS_Applications.AppID in (select * from  AD_FROM ) ".replace("AD_FROM", Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp"));
    }

    private String getJobsQueryByJobName(EZSourceConnection conn) {
        return "select distinct TWS_Jobs.JobNumber, TWS_Jobs.JobName, TWS_Jobs.JobAppID,  TWS_Applications.ApplicationName  from TWS_Jobs inner join TWS_Applications on TWS_Applications.AppID = TWS_Jobs.JobAppID" + " where UPPER(TWS_Jobs.JobName) in (select * from  AD_FROM )  ".replace("AD_FROM", Utils.getTempTableName((EZSourceConnection)conn, (String)"string_param_temp")) + "and ApplicationType = 'A' and ApplicationStatus = 'A' ";
    }

    public List<Listable> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<Listable> resources = new ArrayList<Listable>();
        try {
            List<EZSourceDataType> types;
            String[][] results = null;
            if (this.parameters != null) {
                types = Arrays.asList(new EZSourceDataType[this.parameters.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                results = conn.executeSQL(this.getJobsQuery(conn), types, this.parameters);
            } else if (this.jobNameParams != null) {
                types = Arrays.asList(new EZSourceDataType[this.jobNameParams.size()]);
                Collections.fill(types, EZSourceDataType.String);
                ArrayList<String> cpy = new ArrayList<String>();
                for (String name : this.jobNameParams) {
                    cpy.add(name.toUpperCase());
                }
                results = conn.executeSQL(this.getJobsQueryByJobName(conn), types, cpy);
            }
            if (results != null && results.length > 0) {
                TWSJob jobRes = null;
                String[][] stringArray = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    String[] result = stringArray[n2];
                    String jobName = result[1];
                    jobRes = new TWSJob(jobName, Integer.valueOf(result[2]), result[0], result[3]);
                    resources.add(jobRes);
                    ++n2;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return resources;
    }

    public void setParameters(List<Integer> parameters) {
        this.parameters = parameters;
    }

    public void setFilterParam(List<String> jobNameParams) {
        this.jobNameParams = jobNameParams;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

