/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.wizard.collectors;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.common.ui.listselection.Listable;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.EZSourceConnectionException;
import com.ez.ezsource.connection.ServerType;
import com.ez.graphs.tws.model.TWSApplicationInput;
import com.ez.mainframe.data.utils.Utils;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSApplicationsCollector
extends BridgeResourcesCollectorAdapter<Listable> {
    private static final Logger L = LoggerFactory.getLogger(TWSApplicationsCollector.class);
    private String[] calendarParams;
    private List<String> appNameParams;
    private Set<Integer> appIDs;
    private List<TWSApplicationInput> appsInputs;

    private String getQuery() {
        StringBuilder sb = new StringBuilder();
        sb.append("select AppID, ApplicationName from TWS_Applications where ApplicationType = 'A' and ApplicationStatus = 'A'");
        if (this.calendarParams != null) {
            String validFrom = this.calendarParams[0];
            String validTo = this.calendarParams[1];
            if (validFrom != null) {
                sb.append(" and ValidFromDate >= ").append("'" + validFrom + "'");
            }
            if (validTo != null) {
                sb.append(" and ValidToDate <= ").append("'" + validTo + "'");
            }
        }
        return sb.toString();
    }

    public List<Listable> collect(boolean useFilters, Set<String> apps, EZSourceConnection conn) {
        ArrayList<Listable> resources = new ArrayList<Listable>();
        try {
            TWSApplicationInput appRes;
            Object appName;
            Object result;
            Object object;
            String[][] results = null;
            String[][] appResults = null;
            String query = this.getQuery();
            ServerType dbEngine = conn.getProjectInfo().getDbEngine();
            if (this.appIDs != null) {
                ArrayList<Integer> params = new ArrayList<Integer>(this.appIDs);
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[params.size()]);
                Collections.fill(types, EZSourceDataType.Integer);
                query = query.concat(" and AppID not in (select * from  " + this.getTempTblName(dbEngine, true) + ")");
                results = conn.executeSQL(query, types, params);
                query = this.getQuery().concat(" and AppID in (select * from  " + this.getTempTblName(dbEngine, true) + ")");
                appResults = conn.executeSQL(query, types, params);
                this.appIDs = null;
            } else if (this.appNameParams != null) {
                List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[this.appNameParams.size()]);
                Collections.fill(types, EZSourceDataType.String);
                ArrayList<String> params = new ArrayList<String>();
                for (String name : this.appNameParams) {
                    params.add(name.toUpperCase());
                }
                query = query.concat(" and UPPER(ApplicationName) in (select * from  " + this.getTempTblName(dbEngine, false) + ")");
                results = conn.executeSQL(query, types, params);
            } else {
                results = conn.executeSQL(query);
            }
            if (results != null && results.length > 0) {
                object = results;
                int n = results.length;
                int n2 = 0;
                while (n2 < n) {
                    result = object[n2];
                    appName = result[1];
                    appRes = new TWSApplicationInput((String)appName, Integer.valueOf((String)result[0]));
                    resources.add(appRes);
                    ++n2;
                }
            }
            if (appResults != null && appResults.length > 0) {
                this.appsInputs = new ArrayList<TWSApplicationInput>();
                object = appResults;
                int n = appResults.length;
                int n3 = 0;
                while (n3 < n) {
                    result = object[n3];
                    appName = result[1];
                    appRes = new TWSApplicationInput((String)appName, Integer.valueOf((String)result[0]));
                    this.appsInputs.add(appRes);
                    ++n3;
                }
            }
        }
        catch (EZSourceConnectionException e) {
            L.error("connection error", (Throwable)e);
        }
        return resources;
    }

    private String getTempTblName(ServerType dbEngine, boolean isNumeric) {
        String tblName = isNumeric ? "numeric_param_temp" : "string_param_temp";
        return Utils.getTempTableName((ServerType)dbEngine, (String)tblName);
    }

    public void setCalendarParams(String[] calendarParams) {
        this.calendarParams = calendarParams;
    }

    public void setFilterParam(List<String> appNameParams) {
        this.appNameParams = appNameParams;
    }

    public void setAppIDsParam(Set<Integer> appIDs) {
        this.appIDs = appIDs;
    }

    public List<TWSApplicationInput> getAppsInputs() {
        return this.appsInputs;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return null;
    }
}

