/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.wizard;

import com.ez.graphs.tws.model.TWSApplicationInput;
import com.ez.graphs.tws.model.TWSJob;
import com.ez.graphs.tws.wizard.collectors.TWSApplicationsCollector;
import com.ez.graphs.tws.wizard.collectors.TWSJobCollector;
import com.ez.graphs.tws.wizard.pages.ApplicationsSelectionPage;
import com.ez.graphs.tws.wizard.pages.JobsSelectionPage;
import com.ez.report.application.ui.collectors.BridgeResourcesCollectorAdapter;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.wizard.IWizardPage;

public class TWSWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    DateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS", Locale.getDefault());

    public IWizardPage getNextPage(IWizardPage page) {
        ArrayList appsList;
        String[] params;
        BridgeResourcesCollectorAdapter collector;
        IWizardPage next = super.getNextPage(page);
        if (page.getName().equals("analysis settings page") && ((Boolean)this.getValue("use inputs filter")).booleanValue() && this.getValue("use job as input filter") != null) {
            next = this.getPage("TWS jobs page");
            TWSJobCollector collector2 = (TWSJobCollector)((JobsSelectionPage)next).getResourcesCollector();
            collector2.setFilterParam((List)this.getValue("use job as input filter"));
            return next;
        }
        if (next != null && next.getName().equals("TWS applications page used to compute application's jobs")) {
            collector = (TWSApplicationsCollector)((ApplicationsSelectionPage)next).getResourcesCollector();
            if (((Boolean)this.getValue("use calendar")).booleanValue()) {
                String startDate = this.getValue("start date") != null ? this.df.format((Date)this.getValue("start date")) : null;
                String endDate = this.getValue("end date") != null ? this.df.format((Date)this.getValue("end date")) : null;
                params = new String[]{startDate, endDate};
                collector.setCalendarParams(params);
            } else {
                collector.setCalendarParams(null);
            }
            if (((Boolean)this.getValue("use inputs filter")).booleanValue() && this.getValue("use app as input filter") != null) {
                List param = (List)this.getValue("use app as input filter");
                collector.setFilterParam(param);
            } else {
                collector.setFilterParam(null);
            }
        }
        if (next != null && next.getName().equals("TWS jobs page")) {
            collector = (TWSJobCollector)((JobsSelectionPage)next).getResourcesCollector();
            String selectedsourcesProperty = ((ApplicationsSelectionPage)page).getSelectedPropName();
            appsList = (ArrayList)this.getValue(selectedsourcesProperty);
            params = new ArrayList();
            for (TWSApplicationInput app : appsList) {
                params.add(app.getResourceID());
            }
            collector.setParameters((List<Integer>)params);
        }
        if (next != null && next.getName().equals("TWS applications page")) {
            List selectedJobs = this.getList("selected resources");
            HashSet<Integer> appIDs = new HashSet<Integer>();
            for (TWSJob job : selectedJobs) {
                appIDs.add(job.getJoAppID());
            }
            if (((Boolean)this.getValue("use inputs filter")).booleanValue()) {
                TWSApplicationsCollector collector3 = new TWSApplicationsCollector();
                ((ApplicationsSelectionPage)next).setResourcesCollector((ResourcesCollector)collector3);
                if (((Boolean)this.getValue("use calendar")).booleanValue()) {
                    String startDate = this.getValue("start date") != null ? this.df.format((Date)this.getValue("start date")) : null;
                    String endDate = this.getValue("end date") != null ? this.df.format((Date)this.getValue("end date")) : null;
                    String[] params2 = new String[]{startDate, endDate};
                    collector3.setCalendarParams(params2);
                } else {
                    collector3.setCalendarParams(null);
                }
                collector3.setAppIDsParam(appIDs);
            } else {
                appsList = new ArrayList(this.getList("TWS applications to jobs avaliable"));
                HashSet appSet = new HashSet(appsList);
                for (TWSApplicationInput app : appSet) {
                    if (!appIDs.contains(app.getResourceID())) continue;
                    appsList.remove((Object)app);
                }
                this.set("TWS applications avaliable", appsList);
            }
        }
        if (page.getName().equals("TWS applications page")) {
            next = this.getPage("tests page");
        }
        return next;
    }

    public boolean canFinish() {
        boolean ret = false;
        if ("TWS jobs page".equals(this.getContainer().getCurrentPage().getName()) || "TWS applications page".equals(this.getContainer().getCurrentPage().getName())) {
            ret = this.getContainer().getCurrentPage().isPageComplete();
        }
        if (System.getProperty("test") != null && this.getContainer().getCurrentPage().getName().equalsIgnoreCase("tests page")) {
            ret = true;
        }
        return ret;
    }

    public boolean performFinish() {
        boolean ret = super.performFinish();
        if ("TWS jobs page".equals(this.getContainer().getCurrentPage().getName())) {
            this.set("TWS applications selection", null);
        }
        return ret;
    }
}

