/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.wizard;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.TWSUtils;
import com.ez.graphs.tws.wizard.TWSWizard;
import com.ez.graphs.tws.wizard.TWSWizardDialog;
import com.ez.graphs.tws.wizard.collectors.TWSApplicationsCollector;
import com.ez.graphs.tws.wizard.collectors.TWSJobCollector;
import com.ez.graphs.tws.wizard.pages.ApplicationsSelectionPage;
import com.ez.graphs.tws.wizard.pages.JobsSelectionPage;
import com.ez.graphs.tws.wizard.pages.TWSGraphFirstPage;
import com.ez.mainframe.gui.filters.ProjectInputsFilter;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectPathPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;

public class TWSGraphSettingsFilter
extends ProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private List<String> inputsByName;
    private boolean useJobFilter;
    private boolean useAppFilter;

    public TWSGraphSettingsFilter() {
    }

    public TWSGraphSettingsFilter(List<String> inputsByName, boolean useJobFilter, boolean useAppFilter) {
        this.inputsByName = inputsByName;
        this.useJobFilter = useJobFilter;
        this.useAppFilter = useAppFilter;
    }

    protected PrepareReportWizard getWizard() {
        TWSWizard wizard = new TWSWizard();
        String wizardName = Messages.getString(TWSGraphSettingsFilter.class, (String)"wizzard.title");
        wizard.setWindowTitle(wizardName);
        if (this.inputsByName != null) {
            wizard.set("use inputs filter", true);
            if (this.useJobFilter) {
                wizard.set("use job as input filter", this.inputsByName);
            } else if (this.useAppFilter) {
                wizard.set("use app as input filter", this.inputsByName);
            }
        }
        TWSGraphFirstPage firstPage = new TWSGraphFirstPage("analysis settings page", this.inputsByName != null);
        firstPage.setTitle(Messages.getString(TWSGraphSettingsFilter.class, (String)"firsPage.title"));
        wizard.addPage((IWizardPage)firstPage);
        ApplicationsSelectionPage applicationsPage = new ApplicationsSelectionPage("TWS applications page used to compute application's jobs");
        TWSApplicationsCollector apc = new TWSApplicationsCollector();
        applicationsPage.setResourcesCollector((ResourcesCollector)apc);
        applicationsPage.setSelectedPropName("TWS applications to jobs selection");
        applicationsPage.setAvailablePropName("TWS applications to jobs avaliable");
        applicationsPage.setTitle(Messages.getString(TWSGraphSettingsFilter.class, (String)"page.title"));
        applicationsPage.setDescription(Messages.getString(TWSGraphSettingsFilter.class, (String)"applications.first.page.description"));
        applicationsPage.setLeftGroupLabel(Messages.getString(TWSGraphSettingsFilter.class, (String)"av.app.resourceType.name"));
        applicationsPage.setRightGroupLabel(Messages.getString(TWSGraphSettingsFilter.class, (String)"sel.app.resourceType.name"));
        applicationsPage.setErrMsgNoResource(Messages.getString(TWSGraphSettingsFilter.class, (String)"err.message"));
        wizard.addPage((IWizardPage)applicationsPage);
        JobsSelectionPage selectJobsPage = new JobsSelectionPage("TWS jobs page");
        TWSJobCollector pc = new TWSJobCollector();
        selectJobsPage.setResourcesCollector((ResourcesCollector)pc);
        selectJobsPage.setTitle(Messages.getString(TWSGraphSettingsFilter.class, (String)"page.title"));
        selectJobsPage.setDescription(Messages.getString(TWSGraphSettingsFilter.class, (String)"page.description"));
        selectJobsPage.setLeftGroupLabel(Messages.getString(TWSGraphSettingsFilter.class, (String)"av.job.resourceType.name"));
        selectJobsPage.setRightGroupLabel(Messages.getString(TWSGraphSettingsFilter.class, (String)"sel.job.resourceType.name"));
        selectJobsPage.setErrMsgNoResource(Messages.getString(TWSGraphSettingsFilter.class, (String)"err.message"));
        wizard.addPage((IWizardPage)selectJobsPage);
        ApplicationsSelectionPage appsPage = new ApplicationsSelectionPage("TWS applications page");
        wizard.addPage((IWizardPage)appsPage);
        appsPage.setSelectedPropName("TWS applications selection");
        appsPage.setAvailablePropName("TWS applications avaliable");
        appsPage.setTitle(Messages.getString(TWSGraphSettingsFilter.class, (String)"page.title"));
        appsPage.setDescription(Messages.getString(TWSGraphSettingsFilter.class, (String)"applications.second.page.description"));
        appsPage.setLeftGroupLabel(Messages.getString(TWSGraphSettingsFilter.class, (String)"av.app.resourceType.name"));
        appsPage.setRightGroupLabel(Messages.getString(TWSGraphSettingsFilter.class, (String)"sel.app.resourceType.name"));
        appsPage.setErrMsgNoResource(Messages.getString(TWSGraphSettingsFilter.class, (String)"err.message"));
        if (System.getProperty("test") != null) {
            SelectPathPage selectPathPage = new SelectPathPage("tests page");
            wizard.addPage((IWizardPage)selectPathPage);
        }
        return wizard;
    }

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        TWSWizardDialog dialog = new TWSWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List selected = wizard.getList("selected resources");
        analysis.addContextValue("input_list", (Object)selected);
        List appsSelected = wizard.getList("TWS applications selection");
        if (appsSelected != null) {
            analysis.addContextValue("TWS applications selection", (Object)appsSelected);
        }
        if (((Boolean)wizard.getValue("use calendar")).booleanValue()) {
            analysis.addContextValue("start date", wizard.getValue("start date"));
            analysis.addContextValue("end date", wizard.getValue("end date"));
        }
        if (TWSUtils.hasExportCsvOption()) {
            analysis.addContextValue("InternalEXportCSVOption", wizard.getValue("InternalEXportCSVOption"));
            List allJobIds = wizard.getList("available resources");
            analysis.addContextValue("available resources", (Object)allJobIds);
        }
        analysis.addContextValue("selected path", (Object)wizard.getSelectedPath());
    }
}

