/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.properties;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.nodes.TWSJobNode;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TWSJobSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EMPTY_STRING = "";
    private TWSJobNode node;
    private Text txtjobName;
    private Text txtDescription;
    private Text txtWorkstation;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 16384, true, true);
        gd.widthHint = 250;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSJobSection.class, (String)"job.name.lbl"));
        this.txtjobName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtjobName.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSJobSection.class, (String)"job.description.lbl"));
        this.txtDescription = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtDescription.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSJobSection.class, (String)"job.work.lbl"));
        this.txtWorkstation = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtWorkstation.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.node != null) {
            this.txtjobName.setText(this.node.getJobName());
            if (this.node.getDescription() != null) {
                this.txtDescription.setText(this.node.getDescription());
            }
            if (this.node.getWorkstation() != null) {
                this.txtWorkstation.setText(this.node.getWorkstation());
            }
        }
        this.composite.pack();
    }

    private void clearData() {
        this.txtjobName.setText(EMPTY_STRING);
        this.txtDescription.setText(EMPTY_STRING);
        this.txtWorkstation.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null) {
            this.node = (TWSJobNode)sg.getResNode();
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

