/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.properties;

import com.ez.common.ui.guielements.TabType;
import com.ez.common.ui.properties.sections.AbstractEZSection;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.nodes.TWSApplicationNode;
import com.ez.internal.id.EZEntityID;
import com.ez.workspace.model.segments.EZSourceMainframeNodeIdSg;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class TWSApplicationSection
extends AbstractEZSection {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String EMPTY_STRING = "";
    private TWSApplicationNode node;
    private Text txtappName;
    private Text txtDescription;
    private Text txtOwner;
    private Text txtCalendar;
    private Text txtFromDate;
    private Text txtToDate;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        this.composite.setLayout((Layout)gl);
        GridData gd = new GridData(4, 16384, true, true);
        gd.widthHint = 200;
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSApplicationSection.class, (String)"app.lbl.name"));
        this.txtappName = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtappName.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSApplicationSection.class, (String)"app.description.lbl"));
        this.txtDescription = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtDescription.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSApplicationSection.class, (String)"app.owner.lbl"));
        this.txtOwner = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtOwner.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSApplicationSection.class, (String)"app.calendar.lbl"));
        this.txtCalendar = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtCalendar.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSApplicationSection.class, (String)"app.valid.from.lbl"));
        this.txtFromDate = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtFromDate.setLayoutData((Object)gd);
        this.getWidgetFactory().createLabel(this.composite, Messages.getString(TWSApplicationSection.class, (String)"app.valid.to.lbl"));
        this.txtToDate = this.getWidgetFactory().createText(this.composite, EMPTY_STRING, 8);
        this.txtToDate.setLayoutData((Object)gd);
    }

    public void refresh() {
        if (!this.allowRefresh()) {
            return;
        }
        this.clearData();
        if (this.node != null) {
            this.txtappName.setText(this.node.getAppName());
            if (this.node.getDescription() != null) {
                this.txtDescription.setText(this.node.getDescription());
            }
            if (this.node.getOwner() != null) {
                this.txtOwner.setText(this.node.getOwner());
            }
            if (this.node.getCalendar() != null) {
                this.txtCalendar.setText(this.node.getCalendar());
            }
            if (this.node.getFromDate() != null) {
                this.txtFromDate.setText(this.node.getFromDate());
            }
            if (this.node.getToDate() != null) {
                this.txtToDate.setText(this.node.getToDate());
            }
        }
        this.composite.pack();
    }

    private void clearData() {
        this.txtappName.setText(EMPTY_STRING);
        this.txtDescription.setText(EMPTY_STRING);
        this.txtOwner.setText(EMPTY_STRING);
        this.txtCalendar.setText(EMPTY_STRING);
        this.txtFromDate.setText(EMPTY_STRING);
        this.txtToDate.setText(EMPTY_STRING);
    }

    protected void setSectionInput(IWorkbenchPart part, ISelection selection) {
        EZSourceMainframeNodeIdSg sg;
        EZEntityID eid;
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof EZEntityID && (eid = (EZEntityID)input) != null && (sg = (EZSourceMainframeNodeIdSg)eid.getSegment(EZSourceMainframeNodeIdSg.class)) != null) {
            this.node = (TWSApplicationNode)sg.getResNode();
        }
    }

    protected Set<TabType> getParentTabs() {
        return null;
    }

    protected boolean isShowingOtherTab(ISelection selection) {
        return false;
    }
}

