/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws.nodes;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSApplicationNode {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TWSApplicationNode.class);
    String appName;
    String description;
    String owner;
    String calendar;
    String fromDate;
    String toDate;
    private static final String DATE_FORMAT = "yyyy-MM-dd hh:mm:ss.S";
    private static final String NEW_DATE_FORMAT = "yyyy-MM-dd";

    public TWSApplicationNode(String appName, String description, String owner, String calendar, String fromDate, String toDate) {
        this.appName = appName;
        this.description = description;
        this.owner = owner;
        this.calendar = calendar;
        this.fromDate = this.formatDate(fromDate);
        this.toDate = this.formatDate(toDate);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getCalendar() {
        return this.calendar;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    private String formatDate(String inputDate) {
        String outputDate = inputDate;
        if (inputDate != null) {
            SimpleDateFormat in = new SimpleDateFormat(DATE_FORMAT);
            SimpleDateFormat out = new SimpleDateFormat(NEW_DATE_FORMAT);
            try {
                Date date = in.parse(inputDate);
                outputDate = out.format(date);
            }
            catch (ParseException e) {
                L.debug("date format exception: ", (Throwable)e);
            }
        }
        return outputDate;
    }
}

