/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws;

import com.ez.workspace.analysis.EZAnalysis;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TWSUtils.class);
    private static final String NEW_LINE = "\n";
    private static final String TXT_FILE_EXTENSION = ".txt";
    private static final String INFO_FOR_CSV_KEY = "info for csv";

    public static boolean hasExportCsvOption() {
        return System.getProperty("twsLocation") != null;
    }

    public static boolean isExportAllGraphs(EZAnalysis analysis) {
        return TWSUtils.hasExportCsvOption() && "export all graphs".equals(analysis.getContextValue("InternalEXportCSVOption"));
    }

    public static boolean isExportCurrentGraph(EZAnalysis analysis) {
        return TWSUtils.hasExportCsvOption() && "export current graph".equals(analysis.getContextValue("InternalEXportCSVOption"));
    }

    public static void addContextValue(EZAnalysis analysis, String key, String suffix, Object results) {
        analysis.addContextValue(TWSUtils.getKey(key, suffix), results);
    }

    public static String getKey(String key, String suffix) {
        return suffix == null ? key : key.concat(suffix);
    }

    public static void computeEdgeInformation(EZAnalysis analysis, TSEEdge edge) {
        if (!TWSUtils.isExportCurrentGraph(analysis) && !TWSUtils.isExportAllGraphs(analysis)) {
            return;
        }
        StringBuilder name = new StringBuilder();
        TSNode from = edge.getSourceNode();
        String fromName = from.getText();
        TSNode to = edge.getTargetNode();
        String toName = to.getText();
        String srcAppID = from.getAttributeValue("TWS APPLICATION_ID_KEY").toString();
        String tgtAppID = to.getAttributeValue("TWS APPLICATION_ID_KEY").toString();
        name.append(fromName);
        name.append("(job app id = " + srcAppID + ")");
        name.append("\t,\t");
        name.append(toName);
        name.append("(job app id = " + tgtAppID + ")");
        if (edge.getTooltipText() != null && !edge.getTooltipText().isEmpty()) {
            name.append("- dependency description: ");
            name.append(edge.getTooltipText());
            TSEdgeLabel l = edge.addLabel();
            l.setName((Object)edge.getTooltipText());
        }
        edge.setAttribute(INFO_FOR_CSV_KEY, (Object)name);
    }

    public static void writeInFile(String twsJobsListableName, TSEGraph graph) {
        block16: {
            twsJobsListableName = twsJobsListableName.replaceAll(":", "--");
            String loc = System.getProperty("twsLocation");
            if (loc == null) {
                return;
            }
            File dir = new File(loc);
            if (!dir.exists()) {
                dir.mkdir();
            }
            String suffix = loc.concat(twsJobsListableName).concat(TXT_FILE_EXTENSION);
            File file = new File(suffix);
            BufferedWriter bw = null;
            try {
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileWriter fw = new FileWriter(file.getAbsoluteFile());
                    bw = new BufferedWriter(fw);
                    List edges = graph.edges();
                    for (TSEEdge edge : edges) {
                        if (!edge.hasAttribute(INFO_FOR_CSV_KEY)) continue;
                        bw.write(((StringBuilder)edge.getAttributeValue(INFO_FOR_CSV_KEY)).toString());
                        bw.write(NEW_LINE);
                    }
                }
                catch (Exception ex) {
                    L.error("could not write in file " + file, (Throwable)ex);
                    if (bw == null) break block16;
                    try {
                        bw.close();
                    }
                    catch (IOException ex1) {
                        L.error("can't close " + file, (Throwable)ex1);
                    }
                }
            }
            finally {
                if (bw != null) {
                    try {
                        bw.close();
                    }
                    catch (IOException ex1) {
                        L.error("can't close " + file, (Throwable)ex1);
                    }
                }
            }
        }
    }
}

