/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws;

import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.TSENodeComparator;
import com.ez.graphs.tws.TWSGraphAnalysis;
import com.ez.graphs.tws.TWSNodeLegendInfo;
import com.ez.graphs.tws.TWSUtils;
import com.ez.graphs.tws.model.TWSJob;
import com.ez.graphs.tws.nodes.TWSApplicationNode;
import com.ez.graphs.tws.nodes.TWSJobNode;
import com.ez.internal.analysis.config.inputs.EZAppTWSInputType;
import com.ez.internal.analysis.config.inputs.EZJobTWSInputType;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.generator.EZObjectTypeGeneratorForMainframe;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.LoadTSESVGImage;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.model.segments.EZSourceAppTWSSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceJobTWSSg;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSEdgeBuilder;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.complexity.TSEFoldingManager;
import images.LoadSVGImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSGraphModel
extends AbstractAnalysisGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final String UNKNOWN_JOB_NAME = "";
    private static final Logger L = LoggerFactory.getLogger(TWSGraphModel.class);
    private static final String JOB_SEGMENTS_MAP_FOR_TWS_JOB = "jcl job segments related with a tws job";
    private Map<String, Map<String, TSENode>> tsNodes = new HashMap<String, Map<String, TSENode>>();
    private TWSGraphAnalysis analysis;
    private Integer cgLimitation = null;
    Map<String, String[]> appsInfo = new HashMap<String, String[]>();
    Map<Pair<String, String>, List<String[]>> jobsInfo = new HashMap<Pair<String, String>, List<String[]>>();
    public static final String NODES_TO_FOLD_LIST = "tws jobs to fold";

    public TWSGraphModel(AnalysisGraphManager analysisGraphManager, AbstractSharedAnalysis analysis) {
        this.graphManager = analysisGraphManager;
        this.analysis = (TWSGraphAnalysis)analysis;
        this.initialize();
        Boolean isCgLimited = (Boolean)analysis.getContextValue("is graph limited");
        if (isCgLimited != null && isCgLimited.booleanValue()) {
            this.cgLimitation = (Integer)analysis.getContextValue("limit number for graph levels");
            L.debug("callgraph has limit: " + this.cgLimitation);
        }
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    public void clear() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.tsNodes.clear();
        this.appsInfo.clear();
        this.jobsInfo.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    private void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        this.tsNodes.clear();
        this.appsInfo.clear();
        this.jobsInfo.clear();
        this.nodeTypesSetForLegend.clear();
        this.graphManager.setAttribute("node types set for legend", (Object)this.nodeTypesSetForLegend);
        this.edgeTypesSetForLegend.clear();
        this.graphManager.setAttribute("edge types set for legend", (Object)this.edgeTypesSetForLegend);
    }

    public void loadGraph(IProgressMonitor monitor) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(TWSGraphModel.class, (String)"loading.graph"));
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        if (TWSUtils.isExportAllGraphs((EZAnalysis)this.analysis) || TWSUtils.isExportCurrentGraph((EZAnalysis)this.analysis)) {
            List alljobs = this.analysis.getContextListValue("jobs to be exported");
            for (TWSJob job : alljobs) {
                this.initGraph();
                String jobName = job.getListableName();
                this.buildGraph(jobName);
                TWSUtils.writeInFile(jobName, this.graph);
            }
        }
        this.initGraph();
        this.buildGraph(null);
        pmonitor.setWorkRemaining(0);
    }

    private void buildGraph(String suffix) {
        String[][] results;
        String[][] jobresults;
        int n;
        String[][] appresults = (String[][])this.analysis.getContextValue(TWSUtils.getKey("ANALYSIS_APP_INFO_RESULTS", suffix));
        if (appresults != null && appresults.length > 0) {
            String[][] stringArray = appresults;
            n = appresults.length;
            int n2 = 0;
            while (n2 < n) {
                String[] info = stringArray[n2];
                this.appsInfo.put(info[0], info);
                ++n2;
            }
        }
        if ((jobresults = (String[][])this.analysis.getContextValue(TWSUtils.getKey("ANALYSIS_JOB_INFO_RESULTS", suffix))) != null && jobresults.length > 0) {
            String[][] stringArray = jobresults;
            int n3 = jobresults.length;
            n = 0;
            while (n < n3) {
                String[] info = stringArray[n];
                Pair key = new Pair((Object)info[0], (Object)info[1]);
                List<String[]> values = this.jobsInfo.get(key);
                if (values == null) {
                    values = new ArrayList<String[]>();
                    this.jobsInfo.put((Pair<String, String>)key, values);
                }
                values.add(info);
                ++n;
            }
        }
        if ((results = (String[][])this.analysis.getContextValue(TWSUtils.getKey("analysis results", suffix))) != null && results.length > 0) {
            boolean isGroupByApplication;
            String[][] stringArray = results;
            int n4 = results.length;
            int n5 = 0;
            while (n5 < n4) {
                String[] result = stringArray[n5];
                String tgtJobNr = result[2];
                if (Utils.filterNullValue((String)tgtJobNr) != null) {
                    String tgtAppId = result[3];
                    Integer level = Integer.valueOf(result[4]);
                    String srcJobNr = Utils.filterNullValue((String)result[0]);
                    String srcAppId = Utils.filterNullValue((String)result[1]);
                    boolean isInputNode = srcJobNr == null || srcAppId == null;
                    List<String[]> jInfoList = this.jobsInfo.get(new Pair((Object)tgtAppId, (Object)tgtJobNr));
                    String tgtAppName = Utils.filterNullValue((String)this.appsInfo.get(tgtAppId)[1]);
                    String[] twsjInfo = jInfoList != null ? this.getTWSJobDetails(tgtAppId, tgtJobNr) : null;
                    String tgtJobName = twsjInfo != null ? twsjInfo[2] : UNKNOWN_JOB_NAME;
                    TSENode tgtTSNode = this.getOrCreateNode(tgtJobName, tgtJobNr, tgtAppId, tgtAppName, level, isInputNode);
                    if (jInfoList != null) {
                        for (String[] jInfo : jInfoList) {
                            if (jInfo == null || Utils.filterNullValue((String)jInfo[5]) == null) continue;
                            String jclJobId = jInfo[5];
                            boolean hasJobs = tgtTSNode.hasAttribute(JOB_SEGMENTS_MAP_FOR_TWS_JOB);
                            HashMap jcljobs = null;
                            if (!hasJobs) {
                                jcljobs = new HashMap();
                                tgtTSNode.setAttribute(JOB_SEGMENTS_MAP_FOR_TWS_JOB, (Object)jcljobs);
                            } else {
                                jcljobs = (HashMap)tgtTSNode.getAttributeValue(JOB_SEGMENTS_MAP_FOR_TWS_JOB);
                            }
                            if (jcljobs.containsKey(jclJobId)) continue;
                            String jclJobName = jInfo[6];
                            EZSourceJobIDSg jclJobSg = new EZSourceJobIDSg(jclJobName, jclJobId, Integer.valueOf(22), tgtJobName);
                            jclJobSg.setDeleted(!"1".equals(jInfo[7]));
                            jcljobs.put(jclJobId, jclJobSg);
                        }
                    }
                    if (!isInputNode) {
                        TSENode srcTSNode;
                        String[] srcjInfo = this.getTWSJobDetails(srcAppId, srcJobNr);
                        String srcjobName = srcjInfo != null ? srcjInfo[2] : UNKNOWN_JOB_NAME;
                        String srcAppName = Utils.filterNullValue((String)this.appsInfo.get(srcAppId)[1]);
                        TSENode s = srcTSNode = this.getOrCreateNode(srcjobName, srcJobNr, srcAppId, srcAppName, level, isInputNode);
                        TSENode t = tgtTSNode;
                        if (level < 0) {
                            s = tgtTSNode;
                            t = srcTSNode;
                        }
                        this.createEdgeIfNotExist(s, t, Utils.filterNullValue((String)result[5]));
                    }
                }
                ++n5;
            }
            boolean bl = isGroupByApplication = suffix != null ? false : (Boolean)this.analysis.getContextValue("group jobs by app");
            if (isGroupByApplication) {
                this.outForGISV.clear();
                this.foldAllNodesAndCreateMetaEdges();
            }
        }
    }

    private void createEdgeIfNotExist(TSENode src, TSENode tgt, String tooltip) {
        TSEdgeBuilder edgeBuilder = this.graphManager.getEdgeBuilder();
        List outEdges = src.buildOutEdges();
        TSEEdge edge = null;
        for (TSEEdge e : outEdges) {
            if (!tgt.equals(e.getTargetNode()) || !e.getTooltipText().equals(tooltip) && (tooltip != null || !e.getTooltipText().isEmpty())) continue;
            edge = e;
            break;
        }
        if (edge == null) {
            edge = edgeBuilder.addEdge(this.graphManager, src, tgt);
            if (tooltip != null) {
                edge.setTooltipText(tooltip);
            }
            TWSUtils.computeEdgeInformation((EZAnalysis)this.analysis, edge);
        }
    }

    protected void foldAllNodesAndCreateMetaEdges() {
        for (String appId : this.tsNodes.keySet()) {
            Collection<TSENode> toFoldNodes = this.tsNodes.get(appId).values();
            String[] info = this.appsInfo.get(appId);
            String appName = info[1];
            this.foldNodes(appId, appName, toFoldNodes);
        }
        TWSGraphModel.createMetaEdges(this.graphManager);
    }

    protected void foldNodes(String appId, String name, Collection<TSENode> toFoldNodes) {
        TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)this.graphManager);
        foldingManager.setFolderNodeBuilder(this.graphManager.getNodeBuilder());
        ArrayList<TSENode> toFoldList = new ArrayList<TSENode>(toFoldNodes);
        TSENode fNode = foldingManager.fold(toFoldList, true);
        fNode.setAttribute("IS TWS APPLICATION", (Object)true);
        this.setUIAttributes(fNode, null);
        String[] appDetails = this.appsInfo.get(appId);
        fNode.setAttribute("Node_Mainframe", (Object)new TWSApplicationNode(appDetails[1], Utils.filterNullValue((String)appDetails[2]), Utils.filterNullValue((String)appDetails[3]), Utils.filterNullValue((String)appDetails[4]), Utils.filterNullValue((String)appDetails[5]), Utils.filterNullValue((String)appDetails[6])));
        fNode.setName((Object)name);
        fNode.setAttribute("TWS APPLICATION_NAME_KEY", (Object)name);
        fNode.setAttribute("TWS APPLICATION_ID_KEY", (Object)appId);
        for (TSENode child : toFoldNodes) {
            child.setAttribute("PARENT", (Object)fNode);
            child.setAttribute(NODES_TO_FOLD_LIST, toFoldList);
        }
        fNode.setAttribute("TAG_VISIBLE_ONLY_GRAPHINVENTORY", (Object)Messages.getString(TWSGraphModel.class, (String)"gfi.app.lbl", (Object[])new String[]{(String)fNode.getName()}));
        for (TSENode tsNode : toFoldNodes) {
            this.putEntryInGraphInventory(fNode, tsNode);
        }
    }

    public static void createMetaEdges(TSEGraphManager graphManager) {
        LinkedList metaEdgeNodePairList = new LinkedList();
        LinkedList metaEdgesToRemove = new LinkedList();
        graphManager.checkMetaEdges(metaEdgeNodePairList, metaEdgesToRemove);
        LinkedList insertedMetaEdges = new LinkedList();
        graphManager.updateMetaEdges(metaEdgeNodePairList, metaEdgesToRemove, insertedMetaEdges);
    }

    private TSENode getOrCreateNode(String jobName, String jobNr, String appId, String appName, Integer level, boolean isInput) {
        TSENode tsNode = this.getNode(jobNr, appId);
        if (tsNode == null) {
            String[] jobDetails;
            TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
            tsNode = nodeBuilder.addNode(this.graph);
            Map<String, TSENode> appTSNodes = this.tsNodes.get(appId);
            appTSNodes.put(jobNr, tsNode);
            if (this.cgLimitation != null && this.cgLimitation.equals(level)) {
                tsNode.setAttribute("node is not expanded in callgraph", (Object)Boolean.TRUE);
            }
            if (isInput) {
                tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            }
            String nodeName = !jobName.isEmpty() ? String.valueOf(jobName) + ": " : UNKNOWN_JOB_NAME;
            nodeName = String.valueOf(nodeName) + appName + " - " + String.format("%05d", Integer.valueOf(jobNr));
            tsNode.setName((Object)nodeName);
            tsNode.setAttribute("TWS_JOB_NR_KEY", (Object)jobNr);
            tsNode.setAttribute("TWS APPLICATION_ID_KEY", (Object)appId);
            tsNode.setAttribute("TWS_JOB NAME_KEY", (Object)jobName);
            this.setUIAttributes(tsNode, appName);
            List<String[]> jInfoList = this.jobsInfo.get(new Pair((Object)appId, (Object)jobNr));
            String[] stringArray = jobDetails = jInfoList != null ? this.getTWSJobDetails(appId, jobNr) : null;
            if (jobDetails != null) {
                tsNode.setAttribute("Node_Mainframe", (Object)new TWSJobNode(appName, jobDetails[1], Utils.filterNullValue((String)jobDetails[2]), Utils.filterNullValue((String)jobDetails[3]), Utils.filterNullValue((String)jobDetails[4])));
            } else {
                tsNode.setAttribute("HAS_PROPERTIES_IN_PROPVIEW", (Object)false);
            }
        }
        if (isInput) {
            tsNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            this.setUIAttributes(tsNode, appName);
        }
        return tsNode;
    }

    private String[] getTWSJobDetails(String appId, String jobNr) {
        List<String[]> alldetails = this.jobsInfo.get(new Pair((Object)appId, (Object)jobNr));
        return alldetails.get(0);
    }

    private TSENode getNode(String jobNr, String appId) {
        TSENode tsNode = null;
        Map<String, TSENode> appTSNodes = this.tsNodes.get(appId);
        if (appTSNodes != null) {
            tsNode = appTSNodes.get(jobNr);
        } else {
            appTSNodes = new HashMap<String, TSENode>();
            this.tsNodes.put(appId, appTSNodes);
        }
        return tsNode;
    }

    private void setUIAttributes(TSENode tsNode, String graphInvLbl) {
        TSESVGImage image = null;
        TSEColor txtColor = null;
        TSEColor fillColor = null;
        if (tsNode.hasAttribute("IS TWS APPLICATION")) {
            image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)TWSNodeLegendInfo.TWS_APPLICATION.getGraphImagePath());
            fillColor = TWSNodeLegendInfo.TWS_APPLICATION.getTSEColor();
            this.nodeTypesSetForLegend.add(TWSNodeLegendInfo.TWS_APPLICATION);
        } else {
            image = LoadTSESVGImage.loadImage(LoadSVGImage.class, (String)TWSNodeLegendInfo.JOB.getGraphImagePath());
            fillColor = TWSNodeLegendInfo.JOB.getTSEColor();
            this.nodeTypesSetForLegend.add(TWSNodeLegendInfo.JOB);
            this.putEntryInGraphInventory(Messages.getString(TWSGraphModel.class, (String)"gfi.app.lbl", (Object[])new String[]{graphInvLbl}), tsNode);
        }
        tsNode.setAttribute("uiImage", (Object)image);
        this.setNodeUI(tsNode, fillColor, txtColor);
    }

    private void putEntryInGraphInventory(Object parentNode, TSENode node) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(parentNode);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(parentNode, nodes);
        }
        nodes.add(node);
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
        }
        if (!node.hasAttribute("IS TWS APPLICATION")) {
            this.markSpecialJobNode(node);
        }
    }

    private void markSpecialJobNode(TSENode node) {
        if (node.hasAttribute("node is input for callgraph") && ((Boolean)node.getAttributeValue("node is input for callgraph")).booleanValue()) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        } else if (node.hasAttribute("node is not expanded in callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.darkRed);
        }
    }

    public void setNodeUI(TSENode node, TSEColor fillColor, TSEColor textColor) {
        node.setAttribute("Fill_Color", (Object)fillColor);
        if (textColor != null) {
            node.setAttribute("Color", (Object)textColor);
            if ("!svg".equals(node.getAttributeValue("uiStyle"))) {
                node.setAttribute("Text_Color", (Object)textColor);
            }
        }
        this.setNodeUI(node);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = null;
        if (gNode != null) {
            if (gNode.hasAttribute("APPLICABLE_INPUT")) {
                objType = (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT");
            } else {
                EZSourceAppTWSSg sg = null;
                if (gNode.hasAttribute("IS TWS APPLICATION")) {
                    objType = new EZAppTWSInputType();
                    String appName = (String)gNode.getAttributeValue("TWS APPLICATION_NAME_KEY");
                    String appId = (String)gNode.getAttributeValue("TWS APPLICATION_ID_KEY");
                    sg = new EZSourceAppTWSSg(appId, appName);
                } else {
                    HashMap jclJobs = (HashMap)gNode.getAttributeValue(JOB_SEGMENTS_MAP_FOR_TWS_JOB);
                    if (jclJobs != null) {
                        objType = (EZObjectType)EZObjectTypeGeneratorForMainframe.getInstanceGenerator().createInstance(Integer.valueOf(22));
                        objType.addProperty("resource segments to start an individual analysis", jclJobs.values());
                    } else {
                        objType = new EZJobTWSInputType();
                        String appId = (String)gNode.getAttributeValue("TWS APPLICATION_ID_KEY");
                        String jobNr = (String)gNode.getAttributeValue("TWS_JOB_NR_KEY");
                        String jobName = (String)gNode.getAttributeValue("TWS_JOB NAME_KEY");
                        sg = new EZSourceJobTWSSg(appId, jobNr, jobName);
                    }
                }
                EZEntityID entID = new EZEntityID();
                entID.addSegment((EZSegment)this.analysis.getContextValue("ezsource prj sg"));
                if (sg != null) {
                    entID.addSegment((EZSegment)sg);
                }
                objType.setEntID(entID);
                gNode.setAttribute("APPLICABLE_INPUT", (Object)objType);
            }
        }
        return objType;
    }

    public void updateDrawing() {
        HashSet<TSENode> appNodes = new HashSet<TSENode>();
        for (String appId : this.tsNodes.keySet()) {
            Collection<TSENode> nodes = this.tsNodes.get(appId).values();
            for (TSENode node : nodes) {
                TSENode appNode = (TSENode)node.getAttributeValue("PARENT");
                if (appNode != null && !appNodes.contains(appNode)) {
                    appNodes.add(appNode);
                    this.setNodeUI(appNode);
                }
                this.setNodeUI(node);
            }
        }
    }

    public Map<String, Map<String, TSENode>> getTSNodes() {
        return this.tsNodes;
    }

    public void dispose() {
        this.tsNodes.clear();
        this.appsInfo.clear();
        this.tsNodes = null;
        this.appsInfo = null;
        super.dispose();
    }

    public void writeGraphToFile(TSEGraph graph, String fileName, String pathSelected) {
        block9: {
            String pathToWrite = String.valueOf(pathSelected) + "/" + fileName + ".txt";
            String newLine = System.getProperty("line.separator");
            try {
                File file;
                if (System.getProperty("test").trim().equals(UNKNOWN_JOB_NAME)) break block9;
                boolean found = false;
                File firstProg = new File(pathToWrite);
                if (firstProg.exists() && !firstProg.isDirectory()) {
                    while (!found) {
                        File f = new File(pathToWrite = String.valueOf(pathToWrite.substring(0, pathToWrite.indexOf(".txt"))) + "_x.txt");
                        if (f.exists() && !f.isDirectory()) continue;
                        found = true;
                    }
                }
                if ((file = new File(pathToWrite)).delete()) {
                    L.info("File was refreshed.");
                }
                FileWriter fw = new FileWriter(file, true);
                fw.write("Program name : " + fileName);
                fw.write(newLine);
                fw.write(newLine);
                fw.write("*************************************************** GRAPH DESCRIPTION *************************************************");
                fw.write(newLine);
                List graphNodes = graph.nodes();
                TSENodeComparator comparator = new TSENodeComparator();
                Collections.sort(graphNodes, comparator);
                for (TSENode node : graphNodes) {
                    String name = node.getText();
                    fw.write(newLine);
                    fw.write(name);
                    for (Object allAttrNames : node.getAttributeNames()) {
                        if (allAttrNames.toString().equals("FILE")) {
                            Set locations = (Set)node.getAttributeValue("FILE");
                            if (locations == null) continue;
                            for (TextSelectionInFile tsf : locations) {
                                fw.write(newLine);
                                fw.write("File name :" + tsf.getFileName().substring(tsf.getFileName().lastIndexOf("\\") + 1));
                                fw.write(newLine);
                                fw.write("Program type :" + tsf.getPrgType());
                                fw.write(newLine);
                            }
                            continue;
                        }
                        if (allAttrNames.toString().trim().equals("ScreenOccurId Attribute") || allAttrNames.toString().trim().equals("ScreenID attribute") || allAttrNames.toString().trim().equals("Node_Mainframe") || allAttrNames.toString().trim().equals("Bounds") || allAttrNames.toString().trim().equals("JCL to programs") || allAttrNames.toString().trim().equals("Sources") || allAttrNames.toString().trim().equals("APPLICABLE_INPUT")) continue;
                        fw.write(newLine);
                        fw.write(allAttrNames + ":" + node.getAttributeValue(allAttrNames.toString()).toString());
                    }
                    List inEdges = node.inEdges();
                    fw.write(newLine);
                    fw.write(newLine);
                    fw.write("The in edges :");
                    this.writeEdge(inEdges, node, fw);
                    List outEdges = node.outEdges();
                    fw.write(newLine);
                    fw.write("The out edges :");
                    this.writeEdge(outEdges, node, fw);
                    fw.write(newLine);
                }
                fw.close();
            }
            catch (IOException iOException) {
                L.error("Couldn't write to file");
            }
        }
    }

    private void writeEdge(List<TSEEdge> edges, TSENode node, FileWriter fw) throws IOException {
        ArrayList<String> listToWrite = new ArrayList<String>();
        String newLine = System.getProperty("line.separator");
        if (edges.size() > 0) {
            fw.write(newLine);
            for (TSEEdge tSEEdge : edges) {
                String stmtType = UNKNOWN_JOB_NAME;
                TSEColor color = null;
                if (tSEEdge.hasAttribute("STMT_TYPE")) {
                    stmtType = (String)tSEEdge.getAttributeValue("STMT_TYPE");
                }
                if (tSEEdge.hasAttribute("Color")) {
                    color = (TSEColor)tSEEdge.getAttributeValue("Color");
                }
                String theOtherNode = UNKNOWN_JOB_NAME;
                if (tSEEdge.getOtherNode((TSNode)node) != null) {
                    theOtherNode = tSEEdge.getOtherNode((TSNode)node).getText();
                }
                StringBuilder edgeAttr = new StringBuilder();
                if (tSEEdge.hasAttribute("FILE")) {
                    HashSet textAttr = (HashSet)tSEEdge.getAttributeValue("FILE");
                    ArrayList<String> fileAttrToWrite = new ArrayList<String>();
                    for (TextSelectionInFile textLine : textAttr) {
                        fileAttrToWrite.add("\t\tProgram " + textLine.getFileName().substring(textLine.getFileName().lastIndexOf("\\") + 1) + " of type " + textLine.getPrgType());
                    }
                    Collections.sort(fileAttrToWrite);
                    for (String val : fileAttrToWrite) {
                        edgeAttr.append(val);
                        edgeAttr.append(newLine);
                    }
                }
                StringBuilder value = new StringBuilder();
                if (stmtType != null) {
                    value.append("Statement Type: ");
                    value.append(stmtType);
                }
                value.append(" to ");
                value.append(theOtherNode);
                value.append(" with color ");
                value.append(color);
                value.append(newLine);
                value.append((CharSequence)edgeAttr);
                Collections.sort(listToWrite);
                listToWrite.add(value.toString());
            }
        } else {
            fw.write(" none");
            fw.write(newLine);
        }
        if (!listToWrite.isEmpty()) {
            for (String string : listToWrite) {
                fw.write(string);
                fw.write(newLine);
            }
        }
    }
}

