/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws;

import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.ezdao.api.EZSourceDataType;
import com.ez.ezdao.api.ParameterDirection;
import com.ez.ezdao.api.ParameterInfo;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.LockType;
import com.ez.ezsource.connection.ServerType;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.TWSGraphModel;
import com.ez.graphs.tws.TWSUtils;
import com.ez.graphs.tws.model.TWSApplicationInput;
import com.ez.graphs.tws.model.TWSJob;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.projects.info.IMFConnectionService;
import com.ez.mainframe.projects.info.IMFProjectHandler;
import com.ez.mainframe.projects.info.IMFRunnable;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.complexity.TSHidingManager;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.complexity.TSEFoldingManager;
import com.tomsawyer.interactive.command.editing.TSEDeleteNodeCommand;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSGraphAnalysisJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2023.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TWSGraphAnalysisJob.class);
    private String JOBS_QUERY_BY_APPS_ID = "select distinct TWS_Jobs.JobNumber, TWS_Jobs.JobName, TWS_Jobs.JobAppID,  TWS_Applications.ApplicationName  from TWS_Jobs inner join TWS_Applications on TWS_Applications.AppID = TWS_Jobs.JobAppID where TWS_Applications.AppID in (select TWS_Applications.AppID from TWS_Applications) ";
    private static final String TWS_GET_GRAPH_SP_NAME = "EZViewer_TWS_Graph";
    private MainframeMouseActionsHook mouseActionsHook = null;
    private Direction cgDirection;
    private Boolean isCgLimited;
    private Integer cgLimitation = null;
    private boolean useApps = false;
    private static final int MAXNAMES = 2;

    private String getJobsDetailsQuery(EZSourceConnection conn, String tblName) {
        return "select distinct JobAppID, JobNumber, TWS_Jobs.JobName, WorkstationName, JobDescription,  JCLJob.JobId, JCLJob.JobName, JCLJob.BuildStatus from TWS_Jobs LEFT JOIN JCLJob ON JCLJob.MemberName = TWS_Jobs.JobName" + " where exists (select 1 from AD_TBLNAME as jj where jj.jobnr = JobNumber and jj.appid = JobAppID)".replace("AD_TBLNAME", tblName);
    }

    private String getAppsDetailsQuery(EZSourceConnection conn) {
        return "select AppID, ApplicationName, Description, UserName, Calendar, ValidFromDate, ValidToDate from TWS_Applications where ApplicationType = 'A' and ApplicationStatus = 'A'" + " and AppID in (select * from AD_FROM )".replace("AD_FROM", Utils.getTempTableName((EZSourceConnection)conn, (String)"numeric_param_temp"));
    }

    public TWSGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new TWSMouseActionsHook(id);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new TWSGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.graphModel = new TWSGraphModel(new AnalysisGraphManager(), this.analysis);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        this.cgDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("callgraph direction: " + this.cgDirection);
        this.isCgLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (this.isCgLimited != null && this.isCgLimited.booleanValue()) {
            this.cgLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("callgraph has limit: " + this.cgLimitation);
        } else {
            L.debug("callgraph isn't limited");
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    private void fillInputs(SubMonitor monitor, final List<TWSJob> inputs, final List<TWSApplicationInput> appsInputs) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        ProjectInfo prjInfo = (ProjectInfo)this.analysis.getContextValue("PROJECT_INFO");
        EZSourceProjectIDSg prjSg = new EZSourceProjectIDSg(prjInfo);
        this.analysis.addContextValue("ezsource prj sg", (Object)prjSg);
        String prjName = prjSg.getProjectName();
        try {
            L.debug("will open project " + prjName);
            IMFConnectionService service = (IMFConnectionService)ServiceUtils.getService(IMFConnectionService.class);
            IMFProjectHandler ph = service.getProjectHandler(prjName, null);
            if (!pmonitor.isCanceled()) {
                ph.executeWithLock(ph, new IMFRunnable(){

                    public void run(EZSourceConnection conn, IProgressMonitor pmonitor) {
                        SubMonitor sm = SubMonitor.convert((IProgressMonitor)pmonitor, (int)200);
                        if (!sm.isCanceled()) {
                            String[] tempTables = new String[]{"appids", "jobids"};
                            if (TWSUtils.isExportAllGraphs((EZAnalysis)TWSGraphAnalysisJob.this.analysis) || TWSUtils.isExportCurrentGraph((EZAnalysis)TWSGraphAnalysisJob.this.analysis)) {
                                List alljobs = TWSGraphAnalysisJob.this.analysis.getContextListValue("input_list");
                                if (TWSUtils.isExportAllGraphs((EZAnalysis)TWSGraphAnalysisJob.this.analysis)) {
                                    alljobs = TWSGraphAnalysisJob.this.computeAllJobs(conn);
                                }
                                TWSGraphAnalysisJob.this.analysis.addContextValue("jobs to be exported", (Object)alljobs);
                                TWSGraphAnalysisJob.this.useApps = false;
                                if (TWSUtils.isExportAllGraphs((EZAnalysis)TWSGraphAnalysisJob.this.analysis)) {
                                    TWSGraphAnalysisJob.this.cgDirection = Direction.BOTH;
                                    TWSGraphAnalysisJob.this.isCgLimited = false;
                                }
                                for (TWSJob job : alljobs) {
                                    String jobName = job.getListableName();
                                    ArrayList<TWSJob> inputList = new ArrayList<TWSJob>();
                                    inputList.add(job);
                                    TWSGraphAnalysisJob.this.prepareTempTables(conn, tempTables, inputList, null);
                                    TWSGraphAnalysisJob.this.computeGraphDetails(sm.newChild(100), conn, jobName);
                                    TWSGraphAnalysisJob.this.dropTempTables(conn, tempTables);
                                }
                            }
                            TWSGraphAnalysisJob.this.prepareTempTables(conn, tempTables, inputs, appsInputs);
                            TWSGraphAnalysisJob.this.computeGraphDetails(sm.newChild(100), conn, null);
                            TWSGraphAnalysisJob.this.dropTempTables(conn, tempTables);
                        }
                    }
                }, LockType.Shared, (IProgressMonitor)pmonitor.newChild(30));
            }
        }
        catch (Exception e) {
            L.error("while computing results", (Throwable)e);
            GraphsErrorLog.err((String)e.getMessage(), (Throwable)e);
        }
    }

    protected void computeResults(AbstractAnalysisGraphModel graphModel, IProgressMonitor monitor) {
        Object path;
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)200);
        pmonitor.setTaskName(Messages.getString(TWSGraphAnalysisJob.class, (String)"compute.taskName"));
        List inputs = this.analysis.getContextListValue("input_list");
        List appsInputs = this.analysis.getContextListValue("TWS applications selection");
        if (appsInputs != null && !appsInputs.isEmpty()) {
            this.useApps = true;
        }
        if ((path = this.analysis.getContextValue("selected path")) != null && !path.toString().trim().equals("")) {
            TSEGraph mainGraph = graphModel.getGraph();
            for (TWSJob input : inputs) {
                ArrayList<TWSJob> singleJob = new ArrayList<TWSJob>();
                singleJob.add(input);
                this.fillInputs(pmonitor, singleJob, appsInputs);
                StringBuilder fileName = new StringBuilder();
                fileName.append(input.getAppName());
                fileName.append("_");
                fileName.append(input.getName());
                fileName.append("_");
                fileName.append(input.getJobNr());
                graphModel.loadGraph((IProgressMonitor)new NullProgressMonitor());
                TSEGraph newGraph = graphModel.getGraph();
                ((TWSGraphModel)graphModel).writeGraphToFile(newGraph, fileName.toString(), path.toString());
                ((TWSGraphModel)graphModel).clear();
                newGraph.dispose();
            }
            graphModel.setGraph(mainGraph);
        } else {
            this.fillInputs(pmonitor, inputs, appsInputs);
        }
        pmonitor.setWorkRemaining(0);
    }

    private List<TWSJob> computeAllJobs(EZSourceConnection conn) {
        ArrayList<TWSJob> resources = new ArrayList<TWSJob>();
        String[][] results = conn.executeSQL(this.JOBS_QUERY_BY_APPS_ID);
        if (results != null && results.length > 0) {
            TWSJob jobRes = null;
            String[][] stringArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                String[] result = stringArray[n2];
                String jobName = result[1];
                jobRes = new TWSJob(jobName, Integer.valueOf(result[2]), result[0], result[3]);
                resources.add(jobRes);
                ++n2;
            }
        }
        return resources;
    }

    private void prepareTempTables(EZSourceConnection conn, String[] tempTables, List<TWSJob> inputs, List<TWSApplicationInput> appsInputs) {
        String tblName = Utils.getTempTableName((EZSourceConnection)conn, (String)tempTables[1]);
        conn.executeUpdate(this.buildCreateTempTblStr(conn, tblName));
        ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
        param.add(EZSourceDataType.String);
        param.add(EZSourceDataType.Integer);
        String[][] pVals = new String[inputs.size()][2];
        int j = 0;
        HashSet<Integer> appIDs = new HashSet<Integer>();
        for (TWSJob job : inputs) {
            pVals[j][0] = String.valueOf(job.getJobNr());
            pVals[j][1] = String.valueOf(job.getJoAppID());
            appIDs.add(job.getJoAppID());
            ++j;
        }
        conn.insertBatch(tblName, pVals, param);
        conn.executeUpdate(Utils.buildCreateTempTableStr((EZSourceConnection)conn, (String)tempTables[0], (String)"appid", (EZSourceDataType)EZSourceDataType.Integer));
        if (this.useApps) {
            param = new ArrayList();
            param.add(EZSourceDataType.Integer);
            pVals = new String[appsInputs.size() + appIDs.size()][1];
            int i = 0;
            for (Integer appID : appIDs) {
                pVals[i][0] = String.valueOf(appID);
                ++i;
            }
            int k = 0;
            while (k < appsInputs.size()) {
                TWSApplicationInput app = appsInputs.get(k);
                pVals[i][0] = String.valueOf(app.getResourceID());
                ++i;
                ++k;
            }
            conn.insertBatch(Utils.getTempTableName((EZSourceConnection)conn, (String)tempTables[0]), pVals, param);
        }
    }

    private String buildCreateTempTblStr(EZSourceConnection conn, String tblName) {
        StringBuilder createTempSql = new StringBuilder();
        String columnDefs = " (jobnr varchar(5), appid  int)";
        ServerType dbEngine = conn.getProjectInfo().getDbEngine();
        switch (dbEngine) {
            case SqlServer: {
                createTempSql.append("create table ");
                createTempSql.append(tblName);
                createTempSql.append(columnDefs);
                break;
            }
            case Db2Z: {
                createTempSql.append(" DECLARE GLOBAL TEMPORARY TABLE ");
                createTempSql.append(tblName);
                createTempSql.append(columnDefs);
                createTempSql.append(" CCSID UNICODE ");
                createTempSql.append(" ON COMMIT PRESERVE ROWS NOT LOGGED ");
                break;
            }
            case Db2: {
                createTempSql.append(" DECLARE GLOBAL TEMPORARY TABLE ");
                createTempSql.append(tblName);
                createTempSql.append(columnDefs);
                createTempSql.append(" WITH REPLACE ON COMMIT PRESERVE ROWS NOT LOGGED ");
                break;
            }
        }
        if (createTempSql.length() == 0) {
            L.warn("null CREATE string for tableName={} and dbEngine={}", (Object)tblName, (Object)dbEngine);
        }
        return createTempSql.toString();
    }

    private void dropTempTables(EZSourceConnection conn, String[] tempTables) {
        tempTables[0] = Utils.getTempTableName((EZSourceConnection)conn, (String)tempTables[0]);
        tempTables[1] = Utils.getTempTableName((EZSourceConnection)conn, (String)tempTables[1]);
        if (this.useApps) {
            String qTable0 = String.format("delete from %s", tempTables[0]);
            conn.executeUpdate(qTable0);
        }
        conn.executeUpdate("drop table " + tempTables[0]);
        String qTable1 = String.format("delete from %s", tempTables[1]);
        conn.executeUpdate(qTable1);
        conn.executeUpdate("drop table " + tempTables[1]);
    }

    private void computeGraphDetails(SubMonitor monitor, EZSourceConnection conn, String suffix) {
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)20);
        int dir = 0;
        if (Direction.doBackward((Direction)this.cgDirection) && Direction.doForward((Direction)this.cgDirection)) {
            dir = Direction.BOTH.ordinal();
        } else if (Direction.doForward((Direction)this.cgDirection)) {
            dir = Direction.FORWARD.ordinal();
        } else if (Direction.doBackward((Direction)this.cgDirection)) {
            dir = Direction.BACKWARD.ordinal();
        }
        ParameterInfo[] pInfo = new ParameterInfo[]{ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)93), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)93), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4), ParameterInfo.newParam((ParameterDirection)ParameterDirection.Input, (int)4)};
        Date sDate = (Date)this.analysis.getContextValue("start date");
        Date eDate = (Date)this.analysis.getContextValue("end date");
        Object[] params = new Object[]{dir, suffix != null ? new Timestamp(sDate.getTime()) : null, suffix != null ? new Timestamp(eDate.getTime()) : null, this.useApps ? 1 : 0, this.cgLimitation == null ? null : Integer.valueOf(this.cgLimitation + 1)};
        String[][] graphResults = null;
        try {
            graphResults = conn.execNonTransactionalStoredProc(TWS_GET_GRAPH_SP_NAME, params, pInfo);
        }
        catch (Exception e) {
            L.error("error at executing procedure TWS_GET_GRAPH_SP_NAME with params: {}", (Object)params, (Object)e);
        }
        TWSUtils.addContextValue((EZAnalysis)this.analysis, "analysis results", suffix, graphResults);
        HashSet<Pair<String, String>> resultsSet = new HashSet<Pair<String, String>>();
        HashSet<Integer> appIDSet = new HashSet<Integer>();
        String[][] stringArray = graphResults;
        int n = graphResults.length;
        int n2 = 0;
        while (n2 < n) {
            String[] result = stringArray[n2];
            String count = Utils.filterNullValue((String)result[6]);
            if (count != null && Integer.valueOf(count) > 1) {
                L.warn("There are duplicate target applications. Choosen id = " + result[3]);
            }
            if (Utils.filterNullValue((String)result[2]) != null) {
                resultsSet.add((Pair<String, String>)new Pair((Object)result[2], (Object)result[3]));
                appIDSet.add(Integer.valueOf(result[3]));
            }
            if (Utils.filterNullValue((String)result[1]) != null) {
                resultsSet.add((Pair<String, String>)new Pair((Object)result[0], (Object)result[1]));
                appIDSet.add(Integer.valueOf(result[1]));
            }
            ++n2;
        }
        String[][] jobsResults = this.computeJobsDetailsFromDB(conn, resultsSet);
        TWSUtils.addContextValue((EZAnalysis)this.analysis, "ANALYSIS_JOB_INFO_RESULTS", suffix, jobsResults);
        String[][] appsResults = this.computeAppsDetailsFromDB(conn, appIDSet);
        TWSUtils.addContextValue((EZAnalysis)this.analysis, "ANALYSIS_APP_INFO_RESULTS", suffix, appsResults);
        pmonitor.setWorkRemaining(0);
    }

    private String[][] computeJobsDetailsFromDB(EZSourceConnection conn, Set<Pair<String, String>> resultsSet) {
        String tblName = Utils.getTempTableName((EZSourceConnection)conn, (String)"jobs");
        conn.executeUpdate(this.buildCreateTempTblStr(conn, tblName));
        ArrayList<EZSourceDataType> param = new ArrayList<EZSourceDataType>();
        param.add(EZSourceDataType.String);
        param.add(EZSourceDataType.Integer);
        String[][] pVals = new String[resultsSet.size()][2];
        int j = 0;
        for (Pair<String, String> result : resultsSet) {
            pVals[j][0] = (String)result.getFirst();
            pVals[j][1] = (String)result.getSecond();
            ++j;
        }
        conn.insertBatch(tblName, pVals, param);
        String[][] results = conn.executeSQL(this.getJobsDetailsQuery(conn, tblName));
        String delTblNameQ = String.format("delete from %s", tblName);
        conn.executeUpdate(delTblNameQ);
        conn.executeUpdate("drop table " + tblName);
        return results;
    }

    private String[][] computeAppsDetailsFromDB(EZSourceConnection conn, Set<Integer> appIDs) {
        ArrayList<Integer> params = new ArrayList<Integer>(appIDs);
        List<EZSourceDataType> types = Arrays.asList(new EZSourceDataType[params.size()]);
        Collections.fill(types, EZSourceDataType.Integer);
        String[][] results = conn.executeSQL(this.getAppsDetailsQuery(conn), types, params);
        return results;
    }

    private void addEntriesToLegend(LegendPanel legend, int uiStyle, GraphFilterInfo gfi) {
        if (legend != null) {
            legend.setFilters(gfi);
        }
        this.addNodesToLegend(legend, uiStyle);
    }

    private void addNodesToLegend(LegendPanel legend, int uiStyle) {
        Set nodeTypesSetForLegend = this.graphModel.getNodeTypesForLegend();
        ArrayList nodeTypesList = new ArrayList(nodeTypesSetForLegend);
        Collections.sort(nodeTypesList, new Comparator<IGraphNodeLegendInfo>(){

            @Override
            public int compare(IGraphNodeLegendInfo nodeType1, IGraphNodeLegendInfo nodeType2) {
                return nodeType1.getLegendLabel().compareTo(nodeType2.getLegendLabel());
            }
        });
        for (IGraphNodeLegendInfo nodeLegendInfo : nodeTypesList) {
            String imagePath = null;
            if (uiStyle == 2) {
                imagePath = nodeLegendInfo.getLegendImagePath();
            } else if (uiStyle == 0) {
                imagePath = nodeLegendInfo.getColorboxImagePath();
            }
            legend.placeLegendEntry(imagePath, nodeLegendInfo.getLegendLabel());
        }
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
        this.createIconActions();
    }

    public List getMenuItems() {
        List menus = super.getMenuItems();
        this.contributeEdgesEntries(menus);
        this.contributeIconEntries(menus);
        return menus;
    }

    public List getToolBarItems() {
        List defaultTools = super.getToolBarItems();
        ArrayList<Separator> toolbars = new ArrayList<Separator>();
        this.contributeEdgesEntries(toolbars);
        this.contributeIconEntries(toolbars);
        toolbars.add(new Separator());
        toolbars.addAll(defaultTools);
        return toolbars;
    }

    public void changeActionsState(boolean state) {
        super.changeActionsState(state);
        this.changeEdgesActionsState();
        this.changeIconsActionsState(state);
    }

    private void refreshGISV() {
        this.schedule();
    }

    public class CollapseAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private List<TSENode> toFoldNodes;
        private String appname;
        private String appId;
        private TSENode appNode;

        public CollapseAction() {
            super((GraphTSJobAdapter)TWSGraphAnalysisJob.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(TWSGraphAnalysisJob.class, (String)"collapse.task.text"), -1);
            if (this.appNode != null) {
                ((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).getOutForStructView().remove(this.appNode);
            }
            ((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).foldNodes(this.appId, this.appname, this.toFoldNodes);
            TWSGraphModel.createMetaEdges(TWSGraphAnalysisJob.this.graphManager);
            TWSGraphAnalysisJob.this.refreshGISV();
            List cmds = TWSGraphAnalysisJob.this.doLayout(TWSGraphAnalysisJob.this.currentLayoutType);
            TWSGraphAnalysisJob.this.transmitCommands(cmds);
            TWSGraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }

        public void setNodesToCollapse(TSENode appNode, String name, String appId) {
            Collection<TSENode> nodesToFold = ((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).getTSNodes().get(appId).values();
            this.toFoldNodes = new ArrayList<TSENode>(nodesToFold);
            this.appname = name;
            this.appId = appId;
            this.appNode = appNode;
        }

        public void setNodesToCollapse(List<TSENode> nodesToFold, String name, String appId) {
            this.toFoldNodes = nodesToFold;
            this.appname = name;
            this.appId = appId;
        }
    }

    public class CollapseAllAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public CollapseAllAction() {
            super((GraphTSJobAdapter)TWSGraphAnalysisJob.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(TWSGraphAnalysisJob.class, (String)"collapse.task.text"), -1);
            HashSet appNodes = new HashSet(((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).getOutForStructView().keySet());
            for (TSENode appNode : appNodes) {
                if (appNode.isViewable()) continue;
                ((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).getOutForStructView().remove(appNode);
                String appId = (String)appNode.getAttributeValue("TWS APPLICATION_ID_KEY");
                String name = (String)appNode.getAttributeValue("TWS APPLICATION_NAME_KEY");
                Collection<TSENode> nodesToFold = ((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).getTSNodes().get(appId).values();
                ((TWSGraphModel)TWSGraphAnalysisJob.this.graphModel).foldNodes(appId, name, nodesToFold);
            }
            TWSGraphModel.createMetaEdges(TWSGraphAnalysisJob.this.graphManager);
            TWSGraphAnalysisJob.this.refreshGISV();
            List cmds = TWSGraphAnalysisJob.this.doLayout(TWSGraphAnalysisJob.this.currentLayoutType);
            TWSGraphAnalysisJob.this.transmitCommands(cmds);
            TWSGraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }
    }

    public class ExpandAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private TSENode nodeToExpand;

        public ExpandAction() {
            super((GraphTSJobAdapter)TWSGraphAnalysisJob.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(TWSGraphAnalysisJob.class, (String)"expand.task.text"), -1);
            TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)TWSGraphAnalysisJob.this.graphManager);
            boolean keepHidden = true;
            TSNestingManager.expand((TSDNode)this.nodeToExpand);
            foldingManager.unfold((TSDNode)this.nodeToExpand, keepHidden);
            TSEDeleteNodeCommand delCom = new TSEDeleteNodeCommand(this.nodeToExpand);
            delCom.setUpdateMetaEdges(true);
            delCom.execute();
            List cmds = TWSGraphAnalysisJob.this.doLayout(TWSGraphAnalysisJob.this.currentLayoutType);
            TWSGraphAnalysisJob.this.transmitCommands(cmds);
            TWSGraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }

        public void setNodeToExpand(TSENode nodeToExpand) {
            this.nodeToExpand = nodeToExpand;
        }
    }

    public class ExpandAllAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public ExpandAllAction() {
            super((GraphTSJobAdapter)TWSGraphAnalysisJob.this);
        }

        public void execute(IProgressMonitor monitor) {
            monitor.beginTask(Messages.getString(TWSGraphAnalysisJob.class, (String)"expand.task.text"), -1);
            TSEFoldingManager foldingManager = (TSEFoldingManager)TSEFoldingManager.getManager((TSDGraphManager)TWSGraphAnalysisJob.this.graphManager);
            foldingManager.unfoldAll();
            List cmds = TWSGraphAnalysisJob.this.doLayout(TWSGraphAnalysisJob.this.currentLayoutType);
            TWSGraphAnalysisJob.this.transmitCommands(cmds);
            TWSGraphAnalysisJob.this.canvas.requestFocus();
            monitor.done();
        }
    }

    class TWSGraphInfo
    extends GraphInfoAdapter {
        GraphFilterInfo gfi;
        String tabName;

        public TWSGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor((String)"icons/tws.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            return this.getText(true);
        }

        public String getText(boolean truncate) {
            ProjectInfo ezsourcePrj = (ProjectInfo)TWSGraphAnalysisJob.this.analysis.getContextValue("PROJECT_INFO");
            String textTabMoreCount = "";
            StringBuilder textJobNames = new StringBuilder();
            StringBuilder buil = new StringBuilder();
            List inputs = TWSGraphAnalysisJob.this.analysis.getContextListValue("input_list");
            if (inputs != null) {
                int idx = 0;
                int inptsSize = inputs.size();
                for (TWSJob job : inputs) {
                    if (idx >= 2) {
                        textTabMoreCount = String.valueOf(textTabMoreCount) + (inptsSize - idx);
                        break;
                    }
                    ++idx;
                    textJobNames.append(job.getListableName());
                    if (inputs.indexOf((Object)job) == inputs.size() - 1) continue;
                    textJobNames.append(", ");
                }
            }
            if (textTabMoreCount.isEmpty()) {
                buil.append(Messages.getString(TWSGraphAnalysisJob.class, (String)"text.tab", (Object[])new String[]{textJobNames.toString(), ezsourcePrj.getName()}));
            } else {
                buil.append(Messages.getString(TWSGraphAnalysisJob.class, (String)"text.tab.with.more", (Object[])new String[]{textJobNames.toString(), textTabMoreCount, ezsourcePrj.getName()}));
            }
            this.tabName = buil.toString();
            return this.tabName;
        }

        public String getTooltip() {
            StringBuilder buil = new StringBuilder(this.tabName);
            StringBuilder textAppInputsName = new StringBuilder();
            List appsInputs = TWSGraphAnalysisJob.this.analysis.getContextListValue("TWS applications selection");
            if (appsInputs != null) {
                for (TWSApplicationInput app : appsInputs) {
                    textAppInputsName.append(app.getName());
                    if (appsInputs.indexOf((Object)app) == appsInputs.size() - 1) continue;
                    textAppInputsName.append(", ");
                }
            }
            if (TWSGraphAnalysisJob.this.isCgLimited != null && TWSGraphAnalysisJob.this.isCgLimited.booleanValue()) {
                if (TWSGraphAnalysisJob.this.cgDirection != null) {
                    buil.append(Messages.getString(TWSGraphAnalysisJob.class, (String)"text.tooltip.limited.all", (Object[])new String[]{textAppInputsName.toString(), TWSGraphAnalysisJob.this.cgDirection.toString(), TWSGraphAnalysisJob.this.cgLimitation.toString()}));
                } else {
                    buil.append(Messages.getString(TWSGraphAnalysisJob.class, (String)"text.tooltip.cgDirectionNull", (Object[])new String[]{textAppInputsName.toString(), TWSGraphAnalysisJob.this.cgLimitation.toString()}));
                }
            } else if (TWSGraphAnalysisJob.this.cgDirection != null) {
                buil.append(Messages.getString(TWSGraphAnalysisJob.class, (String)"text.tooltip.isCgLimitedNull", (Object[])new String[]{textAppInputsName.toString(), TWSGraphAnalysisJob.this.cgDirection.toString()}));
            } else {
                buil.append(Messages.getString(TWSGraphAnalysisJob.class, (String)"text.tooltip.isCgLimitedNull.cgDirectionNull", (Object[])new String[]{textAppInputsName.toString()}));
            }
            return buil.toString();
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    TWSGraphAnalysisJob.this.legend = new LegendPanel((Composite)sc, 0);
                    TWSGraphAnalysisJob.this.legend.setImageDescriptorProvider(new ImageDescriptorProvider(){

                        public ImageDescriptor getImageDescriptor(String image) {
                            return Activator.getImageDescriptor((String)image);
                        }
                    });
                    int uiStyle = TWSGraphAnalysisJob.this.graphModel.getUIStyle();
                    TWSGraphAnalysisJob.this.addEntriesToLegend(TWSGraphAnalysisJob.this.legend, uiStyle, TWSGraphInfo.this.gfi);
                    sc.setContent((Control)TWSGraphAnalysisJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    TWSGraphAnalysisJob.this.legend.pack();
                    sc.setMinSize(TWSGraphAnalysisJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((TWSGraphAnalysisJob)((TWSGraphInfo)TWSGraphInfo.this).TWSGraphAnalysisJob.this).legend.getSize().x;
                    int x = ((TWSGraphAnalysisJob)((TWSGraphInfo)TWSGraphInfo.this).TWSGraphAnalysisJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return true;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }
    }

    private class TWSMouseActionsHook
    extends MainframeMouseActionsHook {
        private ExpandAction expandAction;
        private CollapseAction collapseAction;
        private ExpandAllAction expandAllApps;
        private CollapseAllAction collapseAllApps;

        public TWSMouseActionsHook(EZEntityID entityId) {
            super(entityId);
            this.expandAction = null;
            this.collapseAction = null;
            this.expandAllApps = null;
            this.collapseAllApps = null;
        }

        public List getRightClickContributions(TSENode node) {
            ArrayList<Object> contextItems = new ArrayList<Object>();
            if (node != null && node.hasAttribute("IS TWS APPLICATION") && node.isViewable()) {
                if (this.expandAction == null) {
                    this.expandAction = new ExpandAction();
                }
                this.expandAction.setChecked(false);
                this.expandAction.setNodeToExpand(node);
                String expandLabel = Messages.getString(TWSGraphAnalysisJob.class, (String)"expand.text", (Object[])new String[]{node.getText()});
                this.expandAction.setText(expandLabel);
                this.expandAction.setEnabled(true);
                contextItems.add(new ActionContributionItem((IAction)this.expandAction));
            } else if (node != null && !node.isViewable() && node.hasAttribute("PARENT")) {
                if (this.expandAction == null) {
                    this.expandAction = new ExpandAction();
                }
                boolean isHidden = TSHidingManager.isHidden((TSGraphMember)node);
                if (node.hasAttribute("PARENT")) {
                    TSENode parrentNode = (TSENode)node.getAttributeValue("PARENT");
                    this.expandAction.setNodeToExpand(parrentNode);
                    String expandLabel = Messages.getString(TWSGraphAnalysisJob.class, (String)"expand.text", (Object[])new String[]{parrentNode.getText()});
                    this.expandAction.setText(expandLabel);
                    this.expandAction.setEnabled(!parrentNode.isExpanded() && !isHidden);
                }
                this.expandAction.setChecked(false);
                contextItems.add(new ActionContributionItem((IAction)this.expandAction));
            }
            if (node != null && node.hasAttribute("IS TWS APPLICATION") && !node.isViewable()) {
                if (this.collapseAction == null) {
                    this.collapseAction = new CollapseAction();
                }
                this.collapseAction.setChecked(false);
                String name = (String)node.getAttributeValue("TWS APPLICATION_NAME_KEY");
                String id = (String)node.getAttributeValue("TWS APPLICATION_ID_KEY");
                this.collapseAction.setNodesToCollapse(node, name, id);
                String collapseLabel = Messages.getString(TWSGraphAnalysisJob.class, (String)"collapse.text", (Object[])new String[]{name});
                this.collapseAction.setText(collapseLabel);
                this.collapseAction.setEnabled(true);
                contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
            } else if (node != null && node.hasAttribute("tws jobs to fold") && node.isViewable()) {
                if (this.collapseAction == null) {
                    this.collapseAction = new CollapseAction();
                }
                this.collapseAction.setChecked(false);
                List nodesToFold = (List)node.getAttributeValue("tws jobs to fold");
                TSENode appNode = (TSENode)node.getAttributeValue("PARENT");
                String name = (String)appNode.getAttributeValue("TWS APPLICATION_NAME_KEY");
                String id = (String)appNode.getAttributeValue("TWS APPLICATION_ID_KEY");
                this.collapseAction.setNodesToCollapse(nodesToFold, name, id);
                this.collapseAction.appNode = appNode;
                String collapseLabel = Messages.getString(TWSGraphAnalysisJob.class, (String)"collapse.text", (Object[])new String[]{name});
                this.collapseAction.setText(collapseLabel);
                this.collapseAction.setEnabled(true);
                contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
            }
            contextItems.add(new Separator());
            contextItems.addAll(super.getRightClickContributions(node));
            return contextItems;
        }

        public List getRightClickContributions() {
            ArrayList<ActionContributionItem> contextItems = new ArrayList<ActionContributionItem>();
            boolean isGroupByApplication = (Boolean)this.analysis.getContextValue("group jobs by app");
            if (isGroupByApplication) {
                if (this.expandAllApps == null) {
                    this.expandAllApps = new ExpandAllAction();
                }
                this.expandAllApps.setChecked(false);
                String expandLabel = Messages.getString(TWSGraphAnalysisJob.class, (String)"expand.all.text");
                this.expandAllApps.setText(expandLabel);
                this.expandAllApps.setEnabled(TSNestingManager.hasCollapsedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
                contextItems.add(new ActionContributionItem((IAction)this.expandAllApps));
                if (this.collapseAllApps == null) {
                    this.collapseAllApps = new CollapseAllAction();
                }
                this.collapseAllApps.setChecked(false);
                String collaspseLabel = Messages.getString(TWSGraphAnalysisJob.class, (String)"collapse.all.text");
                this.collapseAllApps.setText(collaspseLabel);
                boolean enable = false;
                List nodes = this.graphManager.getMainDisplayGraph().nodes();
                for (TSENode node : nodes) {
                    if (TSEFoldingManager.isFolderNode((TSDNode)node) || TSHidingManager.isHidden((TSGraphMember)node)) continue;
                    enable = true;
                    break;
                }
                this.collapseAllApps.setEnabled(enable);
                contextItems.add(new ActionContributionItem((IAction)this.collapseAllApps));
            }
            contextItems.addAll(super.getRightClickContributions());
            return contextItems;
        }

        public void dispose() {
            if (this.expandAction != null) {
                this.expandAction.dispose();
                this.expandAction = null;
            }
            if (this.collapseAction != null) {
                this.collapseAction.dispose();
                this.collapseAction = null;
            }
            if (this.expandAllApps != null) {
                this.expandAllApps.dispose();
                this.expandAllApps = null;
            }
            if (this.collapseAllApps != null) {
                this.collapseAllApps.dispose();
                this.collapseAllApps = null;
            }
            super.dispose();
        }
    }
}

