/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.tws;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.tws.TWSGraphAnalysisJob;
import com.ez.graphs.tws.wizard.TWSGraphSettingsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceAppTWSSg;
import com.ez.workspace.model.segments.EZSourceJobIDSg;
import com.ez.workspace.model.segments.EZSourceJobTWSSg;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TWSGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(TWSGraphAnalysis.class);
    private TWSGraphAnalysisJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (TWSGraphAnalysisJob)wk.getJob(id, TWSGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public String getLabelType() {
        return Messages.getString(TWSGraphAnalysis.class, (String)"label.type.text");
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZSOURCE_TWS_GRAPH_ANALYSIS;
    }

    protected InputsFilter getInputsFilter() {
        TWSGraphSettingsFilter iFilter = null;
        List inputs = this.getContextListValue("input_list");
        if (inputs.size() == 1 && inputs.get(0) instanceof EZSourceProjectInputType) {
            L.debug("start for TWS graph on a project");
            iFilter = new TWSGraphSettingsFilter();
        } else if (inputs.get(0) instanceof EZEntityID) {
            EZEntityID entity = (EZEntityID)inputs.get(0);
            if ((EZSourceJobIDSg)entity.getSegment(EZSourceJobIDSg.class) != null) {
                L.debug("start for TWS graph on a jcl job");
                ArrayList<String> jobs = new ArrayList<String>();
                for (Object input : inputs) {
                    EZEntityID eID = (EZEntityID)input;
                    EZSourceJobIDSg jobIdSg = (EZSourceJobIDSg)eID.getSegment(EZSourceJobIDSg.class);
                    String twsJobName = jobIdSg.getMemberName();
                    jobs.add(twsJobName);
                }
                iFilter = new TWSGraphSettingsFilter(jobs, true, false);
            } else if ((EZSourceJobTWSSg)entity.getSegment(EZSourceJobTWSSg.class) != null) {
                L.debug("start for TWS graph on tws job(s)");
                ArrayList<String> jobs = new ArrayList<String>();
                for (Object input : inputs) {
                    EZEntityID eID = (EZEntityID)input;
                    EZSourceJobTWSSg twsJobIdSg = (EZSourceJobTWSSg)eID.getSegment(EZSourceJobTWSSg.class);
                    String twsJobName = twsJobIdSg.getTWSJobName();
                    jobs.add(twsJobName);
                }
                iFilter = new TWSGraphSettingsFilter(jobs, true, false);
            } else if ((EZSourceAppTWSSg)entity.getSegment(EZSourceAppTWSSg.class) != null) {
                L.debug("start for TWS graph on tws application(s)");
                ArrayList<String> apps = new ArrayList<String>();
                for (Object input : inputs) {
                    EZEntityID eID = (EZEntityID)input;
                    EZSourceAppTWSSg twsAppIdSg = (EZSourceAppTWSSg)eID.getSegment(EZSourceAppTWSSg.class);
                    String appName = twsAppIdSg.getAppTWSName();
                    apps.add(appName);
                }
                iFilter = new TWSGraphSettingsFilter(apps, false, true);
            } else {
                L.warn("entity id is not from a EZJobInputType");
            }
        }
        return iFilter;
    }
}

