/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ODiskWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSegment;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageBrokenException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALPageV2;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OPerformanceStatisticManager;
import com.orientechnologies.orient.core.storage.impl.local.statistic.OSessionStoragePerformanceStatistic;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;

final class OLogSegmentV2
implements OLogSegment {
    private final ODiskWriteAheadLog writeAheadLog;
    private RandomAccessFile rndFile;
    private final Lock fileLock = new ReentrantLock();
    private final AtomicBoolean autoCloseInProgress = new AtomicBoolean();
    private volatile boolean preventAutoClose = false;
    private final File file;
    private volatile boolean closeNextTime;
    private final int fileTTL;
    private final ScheduledExecutorService closer;
    private final long order;
    private final int maxPagesCacheSize;
    private final OPerformanceStatisticManager performanceStatisticManager;
    private final Lock cacheLock = new ReentrantLock();
    private volatile List<OLogRecord> logCache = new ArrayList<OLogRecord>();
    private final ScheduledExecutorService commitExecutor;
    private volatile long filledUpTo;
    private volatile long writtenUpTo;
    private boolean closed;
    private OLogSequenceNumber last = null;
    private volatile boolean flushNewData = true;
    private WeakReference<OPair<OLogSequenceNumber, byte[]>> lastReadRecord = new WeakReference<Object>(null);

    private int writeContentInPage(ByteBuffer pageContent, int posInPage, byte[] log, boolean isLast, int fromRecord, int contentLength, long position, int endOfLastRecord) {
        pageContent.put(posInPage, !isLast ? (byte)1 : 0);
        pageContent.put(posInPage + 1, isLast ? (byte)1 : 0);
        pageContent.putInt(posInPage + 2, contentLength);
        pageContent.position(posInPage + 4 + 2);
        pageContent.put(log, fromRecord, contentLength);
        pageContent.putInt(12, OWALPage.PAGE_SIZE - (posInPage += OWALPageV2.calculateSerializedSize(contentLength)));
        pageContent.putLong(16, position);
        pageContent.putInt(24, endOfLastRecord);
        return posInPage;
    }

    private void flushPage(ByteBuffer content, FileChannel channel, long position) throws IOException {
        content.putLong(4, 4012948655L);
        CRC32 crc32 = new CRC32();
        byte[] data = new byte[OWALPage.PAGE_SIZE - 4];
        content.position(4);
        content.get(data, 0, data.length);
        crc32.update(data);
        content.putInt(0, (int)crc32.getValue());
        content.position(0);
        OIOUtils.writeByteBuffer(content, channel, position);
    }

    OLogSegmentV2(ODiskWriteAheadLog writeAheadLog, File file, int fileTTL, int maxPagesCacheSize, OPerformanceStatisticManager performanceStatisticManager, ScheduledExecutorService closer, ScheduledExecutorService commitExecutor) {
        this.writeAheadLog = writeAheadLog;
        this.file = file;
        this.fileTTL = fileTTL;
        this.maxPagesCacheSize = maxPagesCacheSize;
        this.performanceStatisticManager = performanceStatisticManager;
        this.closer = closer;
        this.commitExecutor = commitExecutor;
        this.order = this.extractOrder(file.getName());
        this.closed = false;
    }

    @Override
    public void startBackgroundWrite() {
        if (this.writeAheadLog.getCommitDelay() > 0) {
            this.commitExecutor.scheduleAtFixedRate(new FlushTask(), this.writeAheadLog.getCommitDelay(), this.writeAheadLog.getCommitDelay(), TimeUnit.MILLISECONDS);
            this.preventAutoClose = true;
        }
    }

    @Override
    public void stopBackgroundWrite(boolean flush) {
        if (flush) {
            this.flush();
        }
        if (!this.commitExecutor.isShutdown()) {
            this.commitExecutor.shutdown();
            try {
                if (!this.commitExecutor.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                    throw new OStorageException("WAL flush task for '" + this.getPath() + "' segment cannot be stopped");
                }
            }
            catch (InterruptedException e) {
                OLogManager.instance().error(this, "Cannot shutdown background WAL commit thread", e, new Object[0]);
            }
        }
        this.preventAutoClose = false;
    }

    private RandomAccessFile getRndFile() throws IOException {
        if (this.rndFile == null) {
            this.rndFile = new RandomAccessFile(this.file, "rw");
            this.scheduleFileAutoClose();
        } else {
            this.closeNextTime = false;
        }
        return this.rndFile;
    }

    private void scheduleFileAutoClose() {
        if (!this.autoCloseInProgress.get() && this.autoCloseInProgress.compareAndSet(false, true)) {
            this.closeNextTime = true;
            FileCloser task = new FileCloser();
            task.self = this.closer.scheduleWithFixedDelay(task, this.fileTTL, this.fileTTL, TimeUnit.SECONDS);
        }
    }

    @Override
    public long getOrder() {
        return this.order;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        long lastPosition;
        long currentPage;
        ByteBuffer buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
        this.fileLock.lock();
        try {
            int freeSpaceOffset;
            int lastRecordEnd;
            RandomAccessFile rndFile = this.getRndFile();
            FileChannel channel = rndFile.getChannel();
            long pages = rndFile.length() / (long)OWALPage.PAGE_SIZE;
            if (rndFile.length() % (long)OWALPage.PAGE_SIZE > 0L) {
                OLogManager.instance().error(this, "Last WAL page was written partially, auto fix", null, new Object[0]);
                channel.truncate(pages * (long)OWALPage.PAGE_SIZE);
            }
            if (pages == 0L) {
                this.last = null;
                this.filledUpTo = 0L;
                return;
            }
            currentPage = pages;
            while (true) {
                if (--currentPage < 0L) {
                    this.last = null;
                    this.filledUpTo = 0L;
                    OLogManager.instance().error(this, "%d pages in WAL segment %s are broken and will be truncated, some data will be lost after restore.", null, pages, this.file.getName());
                    channel.truncate(0L);
                    channel.force(true);
                    return;
                }
                buffer.position(0);
                OIOUtils.readByteBuffer(buffer, channel, currentPage * (long)OWALPage.PAGE_SIZE, false);
                if (this.pageIsBroken(buffer)) {
                    OLogManager.instance().warn((Object)this, "Page %d is broken in WAL segment %d and will be truncated", currentPage, currentPage, this.order);
                    continue;
                }
                lastPosition = buffer.getLong(16);
                if (lastPosition >= 0L) break;
            }
            if (currentPage + 1L < pages) {
                OLogManager.instance().error(this, "Last %d pages in WAL segment %s are broken and will be truncate, some data will be lost after restore.", null, pages - currentPage - 1L, this.file.getName());
                channel.truncate((currentPage + 1L) * (long)OWALPage.PAGE_SIZE);
                channel.force(true);
            }
            if (OWALPage.PAGE_SIZE - (lastRecordEnd = buffer.getInt(24)) != (freeSpaceOffset = buffer.getInt(12))) {
                OLogManager.instance().error(this, "For the page '%d' of WAL segment '%s' amount of free space '%d' does not match the end of last record in page '%d' it will be fixed automatically but may lead to data loss during recovery after crash", null, currentPage, this.file.getName(), freeSpaceOffset, lastRecordEnd);
                buffer.putInt(12, OWALPage.PAGE_SIZE - lastRecordEnd);
                buffer.position(0);
                this.flushPage(buffer, channel, currentPage * (long)OWALPage.PAGE_SIZE);
                channel.force(true);
            }
        }
        finally {
            this.fileLock.unlock();
        }
        this.last = new OLogSequenceNumber(this.order, lastPosition);
        int freeSpace = buffer.getInt(12);
        this.filledUpTo = currentPage * (long)OWALPage.PAGE_SIZE + (long)(OWALPage.PAGE_SIZE - freeSpace);
    }

    @Override
    public int compareTo(OLogSegment other) {
        long otherOrder = other.getOrder();
        if (this.order > otherOrder) {
            return 1;
        }
        if (this.order < otherOrder) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OLogSegmentV2 that = (OLogSegmentV2)o;
        return this.order == that.order;
    }

    public int hashCode() {
        return (int)(this.order ^ this.order >>> 32);
    }

    @Override
    public long filledUpTo() {
        return this.filledUpTo;
    }

    @Override
    public OLogSequenceNumber begin() throws IOException {
        if (!this.logCache.isEmpty()) {
            return new OLogSequenceNumber(this.order, 28L);
        }
        this.fileLock.lock();
        try {
            RandomAccessFile rndFile = this.getRndFile();
            if (rndFile.length() > 0L) {
                OLogSequenceNumber oLogSequenceNumber = new OLogSequenceNumber(this.order, 28L);
                return oLogSequenceNumber;
            }
        }
        finally {
            this.fileLock.unlock();
        }
        return null;
    }

    @Override
    public OLogSequenceNumber end() {
        return this.last;
    }

    @Override
    public void delete() throws IOException {
        this.close(false);
        boolean deleted = OFileUtils.delete(this.file);
        int retryCount = 0;
        while (!deleted) {
            deleted = OFileUtils.delete(this.file);
            if (++retryCount <= 10) continue;
            throw new IOException("Cannot delete file. Retry limit exceeded. (" + retryCount + ")");
        }
    }

    @Override
    public String getPath() {
        return this.file.getAbsolutePath();
    }

    static OLogRecord generateLogRecord(long starting, byte[] record) {
        long resultSize;
        long from = starting;
        long length = record.length;
        int freePageSpace = OWALPage.PAGE_SIZE - (int)Math.max(starting % (long)OWALPage.PAGE_SIZE, 28L);
        int inPage = OWALPageV2.calculateRecordSize(freePageSpace);
        if ((long)inPage >= length) {
            long resultSize2 = OWALPageV2.calculateSerializedSize((int)length);
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 28L;
            }
            return new OLogRecord(record, from, from + resultSize2);
        }
        if (inPage > 0) {
            length -= (long)inPage;
            resultSize = freePageSpace;
            if (from % (long)OWALPage.PAGE_SIZE == 0L) {
                from += 28L;
            }
        } else {
            from = starting + (long)freePageSpace + 28L;
            resultSize = -28L;
        }
        resultSize += length / (long)OWALPageV2.calculateRecordSize(OWALPageV2.MAX_ENTRY_SIZE) * (long)OWALPage.PAGE_SIZE;
        int leftSize = (int)length % OWALPageV2.calculateRecordSize(OWALPageV2.MAX_ENTRY_SIZE);
        if (leftSize > 0) {
            resultSize += (long)(28 + OWALPageV2.calculateSerializedSize(leftSize));
        }
        return new OLogRecord(record, from, from + resultSize);
    }

    @Override
    public OLogSequenceNumber logRecord(byte[] record) {
        this.flushNewData = true;
        OLogRecord rec = OLogSegmentV2.generateLogRecord(this.filledUpTo, record);
        this.filledUpTo = rec.writeTo;
        this.last = new OLogSequenceNumber(this.order, rec.writeFrom);
        try {
            this.cacheLock.lock();
            this.logCache.add(rec);
        }
        finally {
            this.cacheLock.unlock();
        }
        long pagesInCache = (this.filledUpTo - this.writtenUpTo) / (long)OWALPage.PAGE_SIZE;
        if (pagesInCache > (long)this.maxPagesCacheSize) {
            OLogManager.instance().info((Object)this, "Max cache limit is reached (%d vs. %d), sync flush is performed", this.maxPagesCacheSize, pagesInCache);
            this.writeAheadLog.incrementCacheOverflowCount();
            this.flush();
        }
        return this.last;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public byte[] readRecord(OLogSequenceNumber lsn) throws IOException {
        OPair lastRecord = (OPair)this.lastReadRecord.get();
        if (lastRecord != null && ((OLogSequenceNumber)lastRecord.getKey()).equals(lsn)) {
            return (byte[])lastRecord.getValue();
        }
        assert (lsn.getSegment() == this.order);
        if (lsn.getPosition() >= this.filledUpTo) {
            return null;
        }
        if (!this.logCache.isEmpty()) {
            this.flush();
        }
        long pageIndex = lsn.getPosition() / (long)OWALPage.PAGE_SIZE;
        byte[] record = null;
        int pageOffset = (int)(lsn.getPosition() % (long)OWALPage.PAGE_SIZE);
        long pageCount = (this.filledUpTo + (long)OWALPage.PAGE_SIZE - 1L) / (long)OWALPage.PAGE_SIZE;
        ByteBuffer buffer = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
        while (pageIndex < pageCount) {
            this.fileLock.lock();
            try {
                RandomAccessFile rndFile = this.getRndFile();
                FileChannel channel = rndFile.getChannel();
                buffer.position(0);
                OIOUtils.readByteBuffer(buffer, channel, pageIndex * (long)OWALPage.PAGE_SIZE, false);
            }
            finally {
                this.fileLock.unlock();
            }
            if (this.pageIsBroken(buffer)) {
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            OWALPageV2 page = new OWALPageV2(buffer, false);
            byte[] content = page.getRecord(pageOffset);
            if (record == null) {
                record = content;
            } else {
                byte[] oldRecord = record;
                record = new byte[record.length + content.length];
                System.arraycopy(oldRecord, 0, record, 0, oldRecord.length);
                System.arraycopy(content, 0, record, oldRecord.length, record.length - oldRecord.length);
            }
            if (page.mergeWithNextPage(pageOffset)) {
                pageOffset = 28;
                if (++pageIndex < pageCount) continue;
                throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
            }
            if (page.getFreeSpace() < 7 || pageIndex >= pageCount - 1L) break;
            throw new OWALPageBrokenException("WAL page with index " + pageIndex + " is broken");
        }
        this.lastReadRecord = new WeakReference<OPair<OLogSequenceNumber, Object>>(new OPair<OLogSequenceNumber, Object>(lsn, record));
        return record;
    }

    @Override
    public OLogSequenceNumber getNextLSN(OLogSequenceNumber lsn) throws IOException {
        byte[] record = this.readRecord(lsn);
        if (record == null) {
            return null;
        }
        long pos = lsn.getPosition();
        long pageIndex = pos / (long)OWALPage.PAGE_SIZE;
        int pageOffset = (int)(pos - pageIndex * (long)OWALPage.PAGE_SIZE);
        int restOfRecord = record.length;
        while (restOfRecord > 0) {
            int entrySize = OWALPageV2.calculateSerializedSize(restOfRecord);
            if (entrySize + pageOffset < OWALPage.PAGE_SIZE) {
                if (entrySize + pageOffset <= OWALPage.PAGE_SIZE - 7) {
                    pos += (long)entrySize;
                    break;
                }
                pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 28);
                break;
            }
            if (entrySize + pageOffset == OWALPage.PAGE_SIZE) {
                pos += (long)(entrySize + 28);
                break;
            }
            long chunkSize = OWALPageV2.calculateRecordSize(OWALPage.PAGE_SIZE - pageOffset);
            restOfRecord = (int)((long)restOfRecord - chunkSize);
            pos += (long)(OWALPage.PAGE_SIZE - pageOffset + 28);
            pageOffset = 28;
        }
        if (pos >= this.filledUpTo) {
            return null;
        }
        return new OLogSequenceNumber(this.order, pos);
    }

    @Override
    public void close(boolean flush) throws IOException {
        if (!this.closed) {
            this.lastReadRecord.clear();
            this.stopBackgroundWrite(flush);
            if (!this.closer.isShutdown()) {
                this.closer.shutdown();
                try {
                    if (!this.closer.awaitTermination(OGlobalConfiguration.WAL_SHUTDOWN_TIMEOUT.getValueAsInteger(), TimeUnit.MILLISECONDS)) {
                        throw new OStorageException("WAL file auto close task '" + this.getPath() + "' cannot be stopped");
                    }
                }
                catch (InterruptedException e) {
                    OLogManager.instance().error(this, "Shutdown of file auto close thread was interrupted", e, new Object[0]);
                }
            }
            this.fileLock.lock();
            try {
                if (this.rndFile != null) {
                    this.rndFile.close();
                    this.rndFile = null;
                }
            }
            finally {
                this.fileLock.unlock();
            }
            this.closed = true;
        }
    }

    @Override
    public void flush() {
        if (!this.commitExecutor.isShutdown()) {
            try {
                this.commitExecutor.submit(new FlushTask()).get();
            }
            catch (RejectedExecutionException e) {
                if (!this.commitExecutor.isShutdown()) {
                    throw OException.wrapException(new OStorageException("Unable to flush data"), e);
                }
                new FlushTask().run();
            }
            catch (InterruptedException e) {
                throw OException.wrapException(new OStorageException("Thread was interrupted during flush"), e);
            }
            catch (ExecutionException e) {
                throw OException.wrapException(new OStorageException("Error during WAL segment '" + this.getPath() + "' flush"), e);
            }
        } else {
            new FlushTask().run();
        }
    }

    private long extractOrder(String name) {
        Matcher matcher = Pattern.compile("^.*\\.(\\d+)\\.wal$").matcher(name);
        boolean matches = matcher.find();
        assert (matches);
        String order = matcher.group(1);
        try {
            return Long.parseLong(order);
        }
        catch (NumberFormatException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean pageIsBroken(ByteBuffer content) {
        long magicNumber = content.getLong(4);
        if (magicNumber != 4012948655L) {
            return true;
        }
        byte[] data = new byte[OWALPage.PAGE_SIZE - 4];
        content.position(4);
        content.get(data, 0, data.length);
        CRC32 crc32 = new CRC32();
        crc32.update(data);
        return (int)crc32.getValue() != content.getInt(0);
    }

    class FileCloser
    implements Runnable {
        private boolean stopped = false;
        private volatile ScheduledFuture<?> self = null;

        FileCloser() {
        }

        @Override
        public void run() {
            block11: {
                if (this.stopped) {
                    if (this.self != null) {
                        this.self.cancel(false);
                    }
                    return;
                }
                if (OLogSegmentV2.this.preventAutoClose) {
                    return;
                }
                OLogSegmentV2.this.fileLock.lock();
                try {
                    if (OLogSegmentV2.this.closeNextTime) {
                        try {
                            if (OLogSegmentV2.this.rndFile != null) {
                                OLogSegmentV2.this.rndFile.close();
                                OLogSegmentV2.this.rndFile = null;
                            }
                        }
                        catch (IOException e) {
                            OLogManager.instance().error(this, "Can not auto close file in WAL", e, new Object[0]);
                        }
                        OLogSegmentV2.this.autoCloseInProgress.set(false);
                        this.stopped = true;
                        if (this.self != null) {
                            this.self.cancel(false);
                        }
                        break block11;
                    }
                    OLogSegmentV2.this.closeNextTime = true;
                }
                finally {
                    OLogSegmentV2.this.fileLock.unlock();
                }
            }
        }
    }

    static class OLogRecord {
        final byte[] record;
        final long writeFrom;
        final long writeTo;

        OLogRecord(byte[] record, long writeFrom, long writeTo) {
            this.record = record;
            this.writeFrom = writeFrom;
            this.writeTo = writeTo;
        }
    }

    private final class FlushTask
    implements Runnable {
        private FlushTask() {
        }

        @Override
        public void run() {
            try {
                try {
                    this.commitLog();
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Error during WAL background flush", e, new Object[0]);
                }
            }
            finally {
                OLogSegmentV2.this.writeAheadLog.checkFreeSpace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void commitLog() throws IOException {
            if (!OLogSegmentV2.this.flushNewData) {
                return;
            }
            OSessionStoragePerformanceStatistic statistic = OLogSegmentV2.this.performanceStatisticManager.getSessionPerformanceStatistic();
            if (statistic != null) {
                statistic.startWALFlushTimer();
            }
            try {
                RandomAccessFile rndFile;
                long curIndex;
                List toFlush;
                OLogSegmentV2.this.flushNewData = false;
                try {
                    OLogSegmentV2.this.cacheLock.lock();
                    if (OLogSegmentV2.this.logCache.isEmpty()) {
                        return;
                    }
                    toFlush = OLogSegmentV2.this.logCache;
                    OLogSegmentV2.this.logCache = new ArrayList();
                }
                finally {
                    OLogSegmentV2.this.cacheLock.unlock();
                }
                if (toFlush.isEmpty()) {
                    return;
                }
                ByteBuffer pageContent = ByteBuffer.allocate(OWALPage.PAGE_SIZE).order(ByteOrder.nativeOrder());
                long lastRecordPosition = -1L;
                int endOfLastRecord = -1;
                pageContent.putLong(16, lastRecordPosition);
                pageContent.putInt(24, endOfLastRecord);
                OLogRecord first = (OLogRecord)toFlush.get(0);
                long lastRecordPositionPageIndex = curIndex = first.writeFrom / (long)OWALPage.PAGE_SIZE;
                OLogSegmentV2.this.fileLock.lock();
                try {
                    RandomAccessFile rndFile2 = OLogSegmentV2.this.getRndFile();
                    long pagesCount = rndFile2.length() / (long)OWALPage.PAGE_SIZE;
                    if (pagesCount > curIndex) {
                        FileChannel channel = rndFile2.getChannel();
                        pageContent.position(0);
                        OIOUtils.readByteBuffer(pageContent, channel, curIndex * (long)OWALPage.PAGE_SIZE, true);
                        lastRecordPosition = pageContent.getLong(16);
                        endOfLastRecord = pageContent.getInt(24);
                    }
                }
                finally {
                    OLogSegmentV2.this.fileLock.unlock();
                }
                OLogSequenceNumber lsn = null;
                long pageIndex = 0L;
                boolean lastToFlush = false;
                long lastPos = 0L;
                for (OLogRecord log : toFlush) {
                    lsn = new OLogSequenceNumber(OLogSegmentV2.this.order, log.writeFrom);
                    int pos = (int)(log.writeFrom % (long)OWALPage.PAGE_SIZE);
                    pageIndex = log.writeFrom / (long)OWALPage.PAGE_SIZE;
                    if (pageIndex != lastRecordPositionPageIndex) {
                        lastRecordPosition = -1L;
                        endOfLastRecord = -1;
                        lastRecordPositionPageIndex = pageIndex;
                    }
                    int written = 0;
                    while (written < log.record.length) {
                        lastToFlush = true;
                        int pageFreeSpace = OWALPageV2.calculateRecordSize(OWALPage.PAGE_SIZE - pos);
                        int contentLength = Math.min(pageFreeSpace, log.record.length - written);
                        int fromRecord = written;
                        if ((written += contentLength) == log.record.length) {
                            lastRecordPosition = lsn.getPosition();
                            endOfLastRecord = pos + OWALPageV2.calculateSerializedSize(contentLength);
                        }
                        if (OWALPage.PAGE_SIZE - (pos = OLogSegmentV2.this.writeContentInPage(pageContent, pos, log.record, written == log.record.length, fromRecord, contentLength, lastRecordPosition, endOfLastRecord)) >= 7) continue;
                        OLogSegmentV2.this.fileLock.lock();
                        try {
                            RandomAccessFile rndFile3 = OLogSegmentV2.this.getRndFile();
                            FileChannel channel = rndFile3.getChannel();
                            OLogSegmentV2.this.flushPage(pageContent, channel, pageIndex * (long)OWALPage.PAGE_SIZE);
                        }
                        finally {
                            OLogSegmentV2.this.fileLock.unlock();
                        }
                        OLogSegmentV2.this.writtenUpTo = (pageIndex + 1L) * (long)OWALPage.PAGE_SIZE - 1L;
                        lastToFlush = false;
                        lastRecordPosition = -1L;
                        endOfLastRecord = -1;
                        lastRecordPositionPageIndex = ++pageIndex;
                        pos = 28;
                    }
                    lastPos = log.writeTo;
                }
                if (lastToFlush) {
                    OLogSegmentV2.this.fileLock.lock();
                    try {
                        rndFile = OLogSegmentV2.this.getRndFile();
                        FileChannel channel = rndFile.getChannel();
                        OLogSegmentV2.this.flushPage(pageContent, channel, pageIndex * (long)OWALPage.PAGE_SIZE);
                    }
                    finally {
                        OLogSegmentV2.this.fileLock.unlock();
                    }
                    OLogSegmentV2.this.writtenUpTo = lastPos;
                }
                if (OGlobalConfiguration.WAL_SYNC_ON_PAGE_FLUSH.getValueAsBoolean()) {
                    OLogSegmentV2.this.fileLock.lock();
                    try {
                        rndFile = OLogSegmentV2.this.getRndFile();
                        rndFile.getFD().sync();
                    }
                    finally {
                        OLogSegmentV2.this.fileLock.unlock();
                    }
                }
                OLogSegmentV2.this.writeAheadLog.setFlushedLsn(lsn);
            }
            finally {
                if (statistic != null) {
                    statistic.stopWALFlushTimer();
                }
            }
        }
    }
}

