/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.ORecordSerializationOperation;

public class ORidBagDeleteSerializationOperation
implements ORecordSerializationOperation {
    private final OBonsaiCollectionPointer collectionPointer;
    private final OSBTreeCollectionManager collectionManager;
    private final OSBTreeRidBag ridBag;

    public ORidBagDeleteSerializationOperation(OBonsaiCollectionPointer collectionPointer, OSBTreeRidBag ridBag) {
        this.collectionPointer = collectionPointer;
        this.ridBag = ridBag;
        this.collectionManager = ODatabaseRecordThreadLocal.instance().get().getSbTreeCollectionManager();
    }

    @Override
    public void execute(OAbstractPaginatedStorage paginatedStorage) {
        OSBTreeBonsai<OIdentifiable, Integer> treeBonsai = this.loadTree();
        try {
            treeBonsai.delete();
        }
        finally {
            this.releaseTree();
        }
        this.collectionManager.delete(this.collectionPointer);
        this.ridBag.confirmDelete();
    }

    private OSBTreeBonsai<OIdentifiable, Integer> loadTree() {
        return this.collectionManager.loadSBTree(this.collectionPointer);
    }

    private void releaseTree() {
        this.collectionManager.releaseSBTree(this.collectionPointer);
    }
}

