/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfigurationImpl;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.OLocalPaginatedStorage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.zip.CRC32;

@SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
public class OStorageConfigurationSegment
extends OStorageConfigurationImpl {
    private static final String NAME = "database.ocf";
    private static final String BACKUP_NAME = "database.ocf2";
    private static final long serialVersionUID = 638874446554389034L;
    private static final long ENCODING_FLAG_1 = 128975354756545L;
    private static final long ENCODING_FLAG_2 = 587138568122547L;
    private static final long ENCODING_FLAG_3 = 812587836547249L;
    private static final int CRC_32_OFFSET = 100;
    private static final byte FORMAT_VERSION = 42;
    private final String storageName;
    private final String storagePath;

    public OStorageConfigurationSegment(OLocalPaginatedStorage storage) {
        super(storage, Charset.forName("UTF-8"));
        this.storageName = storage.getName();
        this.storagePath = storage.getStoragePath();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public void delete() throws IOException {
        super.delete();
        this.clearConfigurationFiles();
    }

    private void clearConfigurationFiles() {
        File backupFile;
        File file = new File(this.storagePath, NAME);
        if (file.exists() && !file.delete()) {
            OLogManager.instance().warn((Object)this, "Can not delete database configuration file %s", file);
        }
        if ((backupFile = new File(this.storagePath, BACKUP_NAME)).exists() && !backupFile.delete()) {
            OLogManager.instance().warn((Object)this, "Can not delete backup of database configuration file %s", backupFile);
        }
    }

    @Override
    public void create() throws IOException {
        this.clearConfigurationFiles();
        super.create();
    }

    @Override
    public OStorageConfigurationImpl load(Map<String, Object> iProperties) throws OSerializationException {
        try {
            this.initConfiguration();
            this.bindPropertiesToContext(iProperties);
            File file = new File(this.storagePath, NAME);
            File backupFile = new File(this.storagePath, BACKUP_NAME);
            if (file.exists()) {
                if (this.readData(file)) {
                    return this;
                }
                OLogManager.instance().warnNoDb(this, "Main storage configuration file %s is broken in storage %s, try to read from backup file %s", file, this.storageName, backupFile);
                if (backupFile.exists()) {
                    if (this.readData(backupFile)) {
                        return this;
                    }
                    OLogManager.instance().errorNoDb(this, "Backup configuration file %s is broken too", null, new Object[0]);
                    throw new OStorageException("Invalid format for configuration file " + file + " for storage" + this.storageName);
                }
                OLogManager.instance().errorNoDb(this, "Backup configuration file %s does not exist", null, backupFile);
                throw new OStorageException("Invalid format for configuration file " + file + " for storage" + this.storageName);
            }
            if (backupFile.exists()) {
                OLogManager.instance().warn((Object)this, "Seems like previous update to the storage '%s' configuration was finished incorrectly, main configuration file %s is absent, reading from backup", backupFile, file);
                if (this.readData(backupFile)) {
                    return this;
                }
                OLogManager.instance().errorNoDb(this, "Backup configuration file %s is broken", null, backupFile);
                throw new OStorageException("Invalid format for configuration file " + backupFile + " for storage" + this.storageName);
            }
            throw new OStorageException("Can not find configuration file for storage " + this.storageName);
        }
        catch (IOException e) {
            throw OException.wrapException(new OSerializationException("Cannot load database configuration. The database seems corrupted"), e);
        }
    }

    @Override
    public void lock() {
    }

    @Override
    public void unlock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() throws OSerializationException {
        Charset utf8 = Charset.forName("UTF-8");
        byte[] buffer = this.toStream(utf8);
        CRC32 crc32 = new CRC32();
        crc32.update(buffer);
        int crc32content = (int)crc32.getValue();
        try {
            File storagePath = new File(this.storagePath);
            if (!storagePath.exists() && !storagePath.mkdirs()) {
                throw new OStorageException("Can not create directory " + storagePath + " of location of storage " + this.storageName);
            }
            File backupFile = new File(storagePath, BACKUP_NAME);
            if (backupFile.exists() && !backupFile.delete()) {
                throw new OStorageException("Can not delete backup file " + backupFile + " in storage " + this.storageName);
            }
            RandomAccessFile rnd = new RandomAccessFile(backupFile, "rw");
            try {
                this.writeConfigFile(buffer, crc32content, rnd);
            }
            finally {
                rnd.close();
            }
            File file = new File(storagePath, NAME);
            if (file.exists() && !file.delete()) {
                throw new OStorageException("Can not delete configuration file " + file + " in storage " + this.storageName);
            }
            rnd = new RandomAccessFile(file, "rw");
            try {
                this.writeConfigFile(buffer, crc32content, rnd);
            }
            finally {
                rnd.close();
            }
            if (!backupFile.delete()) {
                throw new OStorageException("Can not delete backup file " + backupFile + " in storage " + this.storageName);
            }
        }
        catch (Exception e) {
            throw OException.wrapException(new OSerializationException("Error on update storage configuration"), e);
        }
    }

    private void writeConfigFile(byte[] buffer, int crc32content, RandomAccessFile rnd) throws IOException {
        rnd.seek(48L);
        rnd.write(42);
        rnd.seek(100L);
        rnd.writeInt(crc32content);
        if (OGlobalConfiguration.STORAGE_CONFIGURATION_SYNC_ON_UPDATE.getValueAsBoolean()) {
            rnd.getFD().sync();
        }
        rnd.seek(1024L);
        rnd.writeInt(buffer.length);
        rnd.write(buffer);
        if (OGlobalConfiguration.STORAGE_CONFIGURATION_SYNC_ON_UPDATE.getValueAsBoolean()) {
            rnd.getFD().sync();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readData(File file) throws IOException {
        block29: {
            RandomAccessFile rnd = new RandomAccessFile(file, "r");
            try {
                int crc32content;
                if (rnd.length() < 1029L) {
                    boolean bl = false;
                    return bl;
                }
                rnd.seek(48L);
                int ver = rnd.read();
                if (ver < 0) {
                    boolean bl = false;
                    return bl;
                }
                byte fileVersion = (byte)ver;
                if (fileVersion >= 42) {
                    rnd.seek(100L);
                    crc32content = rnd.readInt();
                } else {
                    crc32content = 0;
                }
                rnd.seek(1024L);
                int size = rnd.readInt();
                byte[] buffer = new byte[size];
                rnd.readFully(buffer);
                if (fileVersion < 42) {
                    if (rnd.length() >= (long)(1024 + size + 8 + 24)) {
                        long encodingFagOne = rnd.readLong();
                        long encodingFagTwo = rnd.readLong();
                        long encodingFagThree = rnd.readLong();
                        if (encodingFagOne == 128975354756545L && encodingFagTwo == 587138568122547L && encodingFagThree == 812587836547249L) {
                            byte[] utf8Encoded = "UTF-8".getBytes(Charset.forName("UTF-8"));
                            int encodingNameLength = rnd.readInt();
                            if (encodingNameLength == utf8Encoded.length) {
                                byte[] binaryEncodingName = new byte[encodingNameLength];
                                rnd.readFully(binaryEncodingName);
                                String encodingName = new String(binaryEncodingName, "UTF-8");
                                if (!encodingName.equals("UTF-8")) {
                                    boolean bl = false;
                                    return bl;
                                }
                                Charset streamEncoding = Charset.forName("UTF-8");
                                try {
                                    this.fromStream(buffer, 0, buffer.length, streamEncoding);
                                    break block29;
                                }
                                catch (Exception e) {
                                    OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                                    boolean bl = false;
                                    rnd.close();
                                    return bl;
                                }
                            }
                            boolean bl = false;
                            return bl;
                        }
                        try {
                            this.fromStream(buffer, 0, buffer.length, Charset.defaultCharset());
                            break block29;
                        }
                        catch (Exception e) {
                            OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                            boolean bl = false;
                            rnd.close();
                            return bl;
                        }
                    }
                    try {
                        this.fromStream(buffer, 0, buffer.length, Charset.defaultCharset());
                        break block29;
                    }
                    catch (Exception e) {
                        OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                        boolean bl = false;
                        rnd.close();
                        return bl;
                    }
                }
                CRC32 crc32 = new CRC32();
                crc32.update(buffer);
                if (crc32content != (int)crc32.getValue()) {
                    boolean bl = false;
                    return bl;
                }
                try {
                    this.fromStream(buffer, 0, buffer.length, Charset.forName("UTF-8"));
                }
                catch (Exception e) {
                    OLogManager.instance().errorNoDb(this, "Error during reading of configuration %s of storage %s", e, file, this.storageName);
                    boolean bl = false;
                    rnd.close();
                    return bl;
                }
            }
            finally {
                rnd.close();
            }
        }
        return true;
    }

    @Override
    public void synch() {
    }

    @Override
    public void setSoftlyClosed(boolean softlyClosed) {
    }

    public String getFileName() {
        return NAME;
    }
}

