/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.sequence;

import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.exception.OSequenceException;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.sequence.OSequence;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceHelper;
import com.orientechnologies.orient.core.metadata.sequence.OSequenceLibrary;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;

public class OSequenceLibraryImpl
implements OSequenceLibrary {
    private final Map<String, OSequence> sequences = new ConcurrentHashMap<String, OSequence>();

    @Override
    public void create() {
        this.init();
    }

    @Override
    public synchronized void load() {
        this.sequences.clear();
        final ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (((OMetadataInternal)db.getMetadata()).getImmutableSchemaSnapshot().existsClass("OSequence")) {
            OScenarioThreadLocal.executeAsDistributed((Callable<? extends Object>)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Object result = db.query(new OSQLSynchQuery("SELECT FROM OSequence"), new Object[0]);
                    for (ODocument document : result) {
                        document.reload();
                        OSequence sequence = OSequenceHelper.createSequence(document);
                        if (sequence == null) continue;
                        OSequenceLibraryImpl.this.sequences.put(sequence.getName().toUpperCase(Locale.ENGLISH), sequence);
                    }
                    return null;
                }
            });
        }
    }

    @Override
    public synchronized void close() {
        this.sequences.clear();
    }

    @Override
    public synchronized Set<String> getSequenceNames() {
        return this.sequences.keySet();
    }

    @Override
    public synchronized int getSequenceCount() {
        return this.sequences.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSequence getSequence(String iName) {
        OSequence seq;
        String name = iName.toUpperCase(Locale.ENGLISH);
        OSequenceLibraryImpl oSequenceLibraryImpl = this;
        synchronized (oSequenceLibraryImpl) {
            seq = this.sequences.get(name);
            if (seq == null) {
                this.load();
                seq = this.sequences.get(name);
            }
        }
        if (seq != null) {
            seq.bindOnLocalThread();
        }
        return seq;
    }

    @Override
    public synchronized OSequence createSequence(String iName, OSequence.SEQUENCE_TYPE sequenceType, OSequence.CreateParams params) {
        this.init();
        String key = iName.toUpperCase(Locale.ENGLISH);
        this.validateSequenceNoExists(key);
        OSequence sequence = OSequenceHelper.createSequence(sequenceType, params, null).setName(iName);
        sequence.save();
        this.sequences.put(key, sequence);
        return sequence;
    }

    @Override
    public synchronized void dropSequence(String iName) {
        OSequence seq = this.getSequence(iName);
        if (seq != null) {
            ODatabaseRecordThreadLocal.instance().get().delete(seq.getDocument().getIdentity());
            this.sequences.remove(iName.toUpperCase(Locale.ENGLISH));
        }
    }

    @Override
    public OSequence onSequenceCreated(ODocument iDocument) {
        this.init();
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return null;
        }
        OSequence seq = this.getSequence(name = name.toUpperCase(Locale.ENGLISH));
        if (seq != null) {
            return seq;
        }
        OSequence sequence = OSequenceHelper.createSequence(iDocument);
        this.sequences.put(name, sequence);
        return sequence;
    }

    @Override
    public OSequence onSequenceUpdated(ODocument iDocument) {
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return null;
        }
        OSequence sequence = this.sequences.get(name = name.toUpperCase(Locale.ENGLISH));
        if (sequence == null) {
            return null;
        }
        sequence.onUpdate(iDocument);
        return sequence;
    }

    @Override
    public void onSequenceDropped(ODocument iDocument) {
        String name = OSequence.getSequenceName(iDocument);
        if (name == null) {
            return;
        }
        name = name.toUpperCase(Locale.ENGLISH);
        this.sequences.remove(name);
    }

    private void init() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.instance().get();
        if (db.getMetadata().getSchema().existsClass("OSequence")) {
            return;
        }
        OClassImpl sequenceClass = (OClassImpl)db.getMetadata().getSchema().createClass("OSequence");
        OSequence.initClass(sequenceClass);
    }

    private void validateSequenceNoExists(String iName) {
        if (this.sequences.containsKey(iName)) {
            throw new OSequenceException("Sequence '" + iName + "' already exists");
        }
    }

    private void validateSequenceExists(String iName) {
        if (!this.sequences.containsKey(iName)) {
            throw new OSequenceException("Sequence '" + iName + "' does not exists");
        }
    }
}

