/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.fetch.json;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OFetchException;
import com.orientechnologies.orient.core.fetch.OFetchContext;
import com.orientechnologies.orient.core.fetch.OFetchListener;
import com.orientechnologies.orient.core.fetch.json.OJSONFetchContext;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import java.io.IOException;

public class OJSONFetchListener
implements OFetchListener {
    @Override
    public boolean requireFieldProcessing() {
        return true;
    }

    @Override
    public void processStandardField(ODocument iRecord, Object iFieldValue, String iFieldName, OFetchContext iContext, Object iusObject, String iFormat, OType filedType) {
        try {
            ((OJSONFetchContext)iContext).getJsonWriter().writeAttribute(((OJSONFetchContext)iContext).getIndentLevel() + 1, true, iFieldName, iFieldValue, iFormat, filedType);
        }
        catch (IOException e) {
            throw OException.wrapException(new OFetchException("Error processing field '" + iFieldValue + " of record " + iRecord.getIdentity()), e);
        }
    }

    public void processStandardCollectionValue(Object iFieldValue, OFetchContext iContext) throws OFetchException {
        try {
            ((OJSONFetchContext)iContext).getJsonWriter().writeValue(((OJSONFetchContext)iContext).getIndentLevel(), true, OJSONWriter.encode(iFieldValue));
        }
        catch (IOException e) {
            OLogManager.instance().error(this, "Error on processStandardCollectionValue", e, new Object[0]);
        }
    }

    @Override
    public Object fetchLinked(ODocument iRecord, Object iUserObject, String iFieldName, ODocument iLinked, OFetchContext iContext) throws OFetchException {
        return iLinked;
    }

    @Override
    public Object fetchLinkedMapEntry(ODocument iRecord, Object iUserObject, String iFieldName, String iKey, ODocument iLinked, OFetchContext iContext) throws OFetchException {
        return iLinked;
    }

    @Override
    public void parseLinked(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
        try {
            ((OJSONFetchContext)iContext).writeLinkedAttribute(iLinked, iFieldName);
        }
        catch (IOException e) {
            throw OException.wrapException(new OFetchException("Error writing linked field " + iFieldName + " (record:" + iLinked.getIdentity() + ") of record " + iRootRecord.getIdentity()), e);
        }
    }

    @Override
    public void parseLinkedCollectionValue(ODocument iRootRecord, OIdentifiable iLinked, Object iUserObject, String iFieldName, OFetchContext iContext) throws OFetchException {
        try {
            if (((OJSONFetchContext)iContext).isInCollection(iRootRecord)) {
                ((OJSONFetchContext)iContext).writeLinkedValue(iLinked, iFieldName);
            } else {
                ((OJSONFetchContext)iContext).writeLinkedAttribute(iLinked, iFieldName);
            }
        }
        catch (IOException e) {
            throw OException.wrapException(new OFetchException("Error writing linked field " + iFieldName + " (record:" + iLinked.getIdentity() + ") of record " + iRootRecord.getIdentity()), e);
        }
    }

    @Override
    public Object fetchLinkedCollectionValue(ODocument iRoot, Object iUserObject, String iFieldName, ODocument iLinked, OFetchContext iContext) throws OFetchException {
        return iLinked;
    }

    @Override
    public void skipStandardField(ODocument iRecord, String iFieldName, OFetchContext iContext, Object iUserObject, String iFormat) throws OFetchException {
    }
}

