/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.thread.OSoftThread;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.replication.OAsyncReplicationError;
import com.orientechnologies.orient.core.replication.OAsyncReplicationOk;

public class OExecutionThreadLocal
extends ThreadLocal<OExecutionThreadData> {
    public static volatile OExecutionThreadLocal INSTANCE = new OExecutionThreadLocal();

    @Override
    protected OExecutionThreadData initialValue() {
        return new OExecutionThreadData();
    }

    public static boolean isInterruptCurrentOperation() {
        Thread t = Thread.currentThread();
        if (t instanceof OSoftThread) {
            return ((OSoftThread)t).isShutdownFlag();
        }
        return false;
    }

    public void setInterruptCurrentOperation(Thread t) {
        if (t instanceof OSoftThread) {
            ((OSoftThread)t).softShutdown();
        }
    }

    public static void setInterruptCurrentOperation() {
        Thread t = Thread.currentThread();
        if (t instanceof OSoftThread) {
            ((OSoftThread)t).softShutdown();
        }
    }

    static {
        Orient inst = Orient.instance();
        inst.registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (INSTANCE == null) {
                    INSTANCE = new OExecutionThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                INSTANCE = null;
            }
        });
    }

    public class OExecutionThreadData {
        public volatile OAsyncReplicationOk onAsyncReplicationOk;
        public volatile OAsyncReplicationError onAsyncReplicationError;
    }
}

