/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.collection.closabledictionary;

import com.orientechnologies.common.collection.closabledictionary.OClosableEntry;
import com.orientechnologies.common.collection.closabledictionary.OClosableItem;
import com.orientechnologies.common.collection.closabledictionary.OClosableLRUList;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.GuardedBy;

public class OClosableLinkedContainer<K, V extends OClosableItem> {
    private static final int NCPU = Runtime.getRuntime().availableProcessors();
    private static final int NUMBER_OF_READ_BUFFERS = OClosableLinkedContainer.closestPowerOfTwo(NCPU);
    private static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    private static final int READ_BUFFER_THRESHOLD = 32;
    private static final int READ_BUFFER_DRAIN_THRESHOLD = 64;
    private static final int WRITE_BUFFER_DRAIN_THRESHOLD = 32;
    private static final int READ_BUFFER_SIZE = 128;
    private static final int READ_BUFFER_INDEX_MASK = 127;
    @GuardedBy(value="lruLock")
    private final long[] readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
    private final AtomicLong[] readBufferWriteCount;
    private final AtomicLong[] readBufferDrainAtWriteCount;
    private final AtomicReference<OClosableEntry<K, V>>[][] readBuffers;
    private final Lock lruLock = new ReentrantLock();
    @GuardedBy(value="lruLock")
    private final OClosableLRUList<K, V> lruList = new OClosableLRUList();
    private final ConcurrentHashMap<K, OClosableEntry<K, V>> data = new ConcurrentHashMap();
    private final ConcurrentLinkedQueue<Runnable> stateBuffer = new ConcurrentLinkedQueue();
    private final int openLimit;
    private final AtomicReference<DrainStatus> drainStatus = new AtomicReference<DrainStatus>(DrainStatus.IDLE);
    private final AtomicReference<CountDownLatch> openLatch = new AtomicReference();
    private final AtomicInteger openFiles = new AtomicInteger();

    public OClosableLinkedContainer(int openLimit) {
        this.openLimit = openLimit;
        AtomicLong[] rbwc = new AtomicLong[NUMBER_OF_READ_BUFFERS];
        AtomicLong[] rbdawc = new AtomicLong[NUMBER_OF_READ_BUFFERS];
        AtomicReference[][] rbs = new AtomicReference[NUMBER_OF_READ_BUFFERS][];
        for (int i = 0; i < NUMBER_OF_READ_BUFFERS; ++i) {
            rbwc[i] = new AtomicLong();
            rbdawc[i] = new AtomicLong();
            rbs[i] = new AtomicReference[128];
            for (int n = 0; n < 128; ++n) {
                rbs[i][n] = new AtomicReference();
            }
        }
        this.readBufferWriteCount = rbwc;
        this.readBufferDrainAtWriteCount = rbdawc;
        this.readBuffers = rbs;
    }

    public void add(K key, V item) throws InterruptedException {
        if (!item.isOpen()) {
            throw new IllegalArgumentException("All passed in items should be in open state");
        }
        this.checkOpenFilesLimit();
        OClosableEntry closableEntry = new OClosableEntry(item);
        OClosableEntry oldEntry = this.data.putIfAbsent(key, closableEntry);
        if (oldEntry != null) {
            throw new IllegalStateException("Item with key " + key + " already exists");
        }
        this.logAdd(closableEntry);
    }

    public V remove(K key) {
        OClosableEntry<K, V> removed = this.data.remove(key);
        if (removed != null) {
            long preStatus = removed.makeRetired();
            if (OClosableEntry.isOpen(preStatus)) {
                this.countClosedFiles();
            }
            this.logRemoved(removed);
            return removed.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OClosableEntry<K, V> acquire(K key) throws InterruptedException {
        this.checkOpenFilesLimit();
        OClosableEntry<K, V> entry = this.data.get(key);
        if (entry == null) {
            return null;
        }
        boolean logOpen = false;
        entry.acquireStateLock();
        try {
            if (entry.isRetired() || entry.isDead()) {
                OClosableEntry<K, V> oClosableEntry = null;
                return oClosableEntry;
            }
            if (entry.isClosed()) {
                entry.makeAcquiredFromClosed((OClosableItem)entry.get());
                logOpen = true;
            } else if (entry.isOpen()) {
                entry.makeAcquiredFromOpen();
            } else {
                entry.incrementAcquired();
            }
        }
        finally {
            entry.releaseStateLock();
        }
        if (logOpen) {
            this.logOpen(entry);
        } else {
            this.logAcquire(entry);
        }
        assert (entry.get().isOpen());
        return entry;
    }

    private void checkOpenFilesLimit() throws InterruptedException {
        CountDownLatch ol = this.openLatch.get();
        if (ol != null) {
            ol.await();
        }
        while (this.openFiles.get() > this.openLimit) {
            CountDownLatch latch = new CountDownLatch(1);
            if (this.openLatch.compareAndSet(null, latch)) {
                while (this.openFiles.get() > this.openLimit) {
                    this.emptyBuffers();
                }
                latch.countDown();
                this.openLatch.set(null);
                continue;
            }
            ol = this.openLatch.get();
            if (ol == null) continue;
            ol.await();
        }
    }

    public void release(OClosableEntry<K, V> entry) {
        if (entry != null) {
            entry.releaseAcquired();
        }
    }

    public V get(K key) {
        OClosableEntry<K, V> entry = this.data.get(key);
        if (entry != null) {
            return entry.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lruLock.lock();
        try {
            this.data.clear();
            for (int n = 0; n < NUMBER_OF_READ_BUFFERS; ++n) {
                AtomicReference<OClosableEntry<K, V>>[] buffer = this.readBuffers[n];
                for (int i = 0; i < 128; ++i) {
                    buffer[i].set(null);
                }
                this.readBufferReadCount[n] = 0L;
                this.readBufferWriteCount[n].set(0L);
                this.readBufferDrainAtWriteCount[n].set(0L);
            }
            this.openFiles.set(0);
            this.stateBuffer.clear();
            while (this.lruList.poll() != null) {
            }
        }
        finally {
            this.lruLock.unlock();
        }
    }

    public boolean close(K key) {
        this.emptyBuffers();
        OClosableEntry<K, V> entry = this.data.get(key);
        if (entry == null) {
            return true;
        }
        if (entry.makeClosed()) {
            this.countClosedFiles();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkAllLRUListItemsInMap() {
        this.lruLock.lock();
        try {
            this.emptyWriteBuffer();
            this.emptyReadBuffers();
            for (OClosableEntry<K, V> entry : this.lruList) {
                boolean result = this.data.containsValue(entry);
                if (result) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lruLock.unlock();
        }
        return true;
    }

    boolean checkLRUSize() {
        return this.lruList.size() <= this.openLimit;
    }

    boolean checkLRUSizeEqualsToCapacity() {
        return this.lruList.size() == this.openLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int checkAllOpenItemsInLRUList() {
        int count = 0;
        this.lruLock.lock();
        try {
            this.emptyWriteBuffer();
            this.emptyReadBuffers();
            for (OClosableEntry<K, V> entry : this.data.values()) {
                boolean contains = false;
                if (!entry.get().isOpen()) continue;
                for (OClosableEntry<K, V> lruEntry : this.lruList) {
                    if (lruEntry != entry) continue;
                    contains = true;
                }
                if (contains) continue;
                ++count;
            }
        }
        finally {
            this.lruLock.unlock();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkNoClosedItemsInLRUList() {
        this.lruLock.lock();
        try {
            this.emptyWriteBuffer();
            this.emptyReadBuffers();
            for (OClosableEntry<K, V> entry : this.data.values()) {
                boolean contains = false;
                if (entry.get().isOpen()) continue;
                for (OClosableEntry<K, V> lruEntry : this.lruList) {
                    if (lruEntry != entry) continue;
                    contains = true;
                }
                if (!contains) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lruLock.unlock();
        }
        return true;
    }

    @GuardedBy(value="lruLock")
    private void emptyWriteBuffer() {
        Runnable task = this.stateBuffer.poll();
        while (task != null) {
            task.run();
            task = this.stateBuffer.poll();
        }
    }

    @GuardedBy(value="lruLock")
    private void emptyReadBuffers() {
        for (int n = 0; n < NUMBER_OF_READ_BUFFERS; ++n) {
            int bufferIndex;
            AtomicReference<OClosableEntry<K, V>> eref;
            OClosableEntry<K, V> entry;
            AtomicReference<OClosableEntry<K, V>>[] buffer = this.readBuffers[n];
            long writeCount = this.readBufferDrainAtWriteCount[n].get();
            long counter = this.readBufferReadCount[n];
            while ((entry = (eref = buffer[bufferIndex = (int)(counter & 0x7FL)]).get()) != null) {
                this.applyRead(entry);
                ++counter;
                eref.lazySet(null);
            }
            this.readBufferReadCount[n] = counter;
            this.readBufferDrainAtWriteCount[n].lazySet(writeCount);
        }
    }

    void emptyBuffers() {
        this.lruLock.lock();
        try {
            this.emptyWriteBuffer();
            this.emptyReadBuffers();
        }
        finally {
            this.lruLock.unlock();
        }
    }

    private void logOpen(OClosableEntry<K, V> entry) {
        this.afterWrite(new LogOpen(entry));
        this.countOpenFiles();
    }

    private void logAdd(OClosableEntry<K, V> entry) {
        this.afterWrite(new LogAdd(entry));
        this.countOpenFiles();
    }

    private void logAcquire(OClosableEntry<K, V> entry) {
        this.afterRead(entry);
    }

    private void logRemoved(OClosableEntry<K, V> entry) {
        this.afterWrite(new LogRemoved(entry));
    }

    private void afterWrite(Runnable task) {
        this.stateBuffer.add(task);
        this.drainStatus.lazySet(DrainStatus.REQUIRED);
        this.tryToDrainBuffers();
    }

    private void afterRead(OClosableEntry<K, V> entry) {
        int bufferIndex = OClosableLinkedContainer.readBufferIndex();
        long writeCount = this.putEntryInReadBuffer(entry, bufferIndex);
        this.drainReadBuffersIfNeeded(bufferIndex, writeCount);
    }

    private long putEntryInReadBuffer(OClosableEntry<K, V> entry, int bufferIndex) {
        AtomicLong writeCounter = this.readBufferWriteCount[bufferIndex];
        long counter = writeCounter.get();
        writeCounter.lazySet(counter + 1L);
        AtomicReference<OClosableEntry<K, V>>[] buffer = this.readBuffers[bufferIndex];
        AtomicReference<OClosableEntry<K, OClosableEntry<K, V>>> bufferEntry = buffer[(int)(counter & 0x7FL)];
        bufferEntry.lazySet(entry);
        return counter + 1L;
    }

    private void drainReadBuffersIfNeeded(int bufferIndex, long writeCount) {
        boolean bufferOverflow;
        AtomicLong lastDrainWriteCount = this.readBufferDrainAtWriteCount[bufferIndex];
        boolean bl = bufferOverflow = writeCount - lastDrainWriteCount.get() > 32L;
        if (this.drainStatus.get().shouldBeDrained(bufferOverflow)) {
            this.tryToDrainBuffers();
        }
    }

    private void tryToDrainBuffers() {
        if (this.lruLock.tryLock()) {
            try {
                this.drainStatus.lazySet(DrainStatus.IN_PROGRESS);
                this.drainBuffers();
            }
            finally {
                this.drainStatus.compareAndSet(DrainStatus.IN_PROGRESS, DrainStatus.IDLE);
                this.lruLock.unlock();
            }
        }
    }

    private void drainBuffers() {
        this.drainWriteBuffer();
        this.drainReadBuffers();
    }

    private void drainReadBuffers() {
        long threadId;
        for (long n = threadId = Thread.currentThread().getId(); n < threadId + (long)NUMBER_OF_READ_BUFFERS; ++n) {
            this.drainReadBuffer((int)(n & (long)READ_BUFFERS_MASK));
        }
    }

    private void drainReadBuffer(int bufferIndex) {
        int entryIndex;
        AtomicReference<OClosableEntry<K, V>> bufferEntry;
        OClosableEntry<K, V> entry;
        long bufferWriteCount = this.readBufferWriteCount[bufferIndex].get();
        AtomicReference<OClosableEntry<K, V>>[] buffer = this.readBuffers[bufferIndex];
        long bufferCounter = this.readBufferReadCount[bufferIndex];
        for (int n = 0; n < 64 && (entry = (bufferEntry = buffer[entryIndex = (int)(bufferCounter & 0x7FL)]).get()) != null; ++n) {
            ++bufferCounter;
            this.applyRead(entry);
            bufferEntry.lazySet(null);
        }
        this.readBufferReadCount[bufferIndex] = bufferCounter;
        this.readBufferDrainAtWriteCount[bufferIndex].lazySet(bufferWriteCount);
    }

    private void applyRead(OClosableEntry<K, V> entry) {
        if (this.lruList.contains(entry)) {
            this.lruList.moveToTheTail(entry);
        }
        this.evict();
    }

    private void drainWriteBuffer() {
        Runnable task;
        for (int i = 0; i < 32 && (task = this.stateBuffer.poll()) != null; ++i) {
            task.run();
        }
    }

    private void countOpenFiles() {
        this.openFiles.incrementAndGet();
    }

    private void countClosedFiles() {
        this.openFiles.decrementAndGet();
    }

    private static int closestPowerOfTwo(int value) {
        int n = value - 1;
        n |= n >>> 1;
        n |= n >>> 2;
        n |= n >>> 4;
        n |= n >>> 8;
        return (n |= n >>> 16) < 0 ? 1 : (n >= 0x40000000 ? 0x40000000 : n + 1);
    }

    private static int readBufferIndex() {
        long threadId = Thread.currentThread().getId();
        return (int)(threadId & (long)READ_BUFFERS_MASK);
    }

    private void evict() {
        long start = Orient.instance().getProfiler().startChrono();
        int initialSize = this.lruList.size();
        int closedFiles = 0;
        while (this.lruList.size() > this.openLimit) {
            Iterator<OClosableEntry<K, V>> iterator = this.lruList.iterator();
            boolean entryClosed = false;
            while (iterator.hasNext()) {
                OClosableEntry<K, V> entry = iterator.next();
                if (!entry.makeClosed()) continue;
                ++closedFiles;
                iterator.remove();
                entryClosed = true;
                this.countClosedFiles();
                break;
            }
            if (entryClosed) continue;
            break;
        }
        if (closedFiles > 0) {
            OLogManager.instance().debug((Object)this, "Reached maximum of opened files %d (max=%d), closed %d files. Consider to raise this limit by increasing the global setting '%s' and the OS limit on opened files per processor", initialSize, this.openLimit, closedFiles, OGlobalConfiguration.OPEN_FILES_LIMIT.getKey());
        }
        Orient.instance().getProfiler().stopChrono("disk.closeFiles", "Close the opened files because reached the configured limit", start);
    }

    private static enum DrainStatus {
        IDLE{

            @Override
            boolean shouldBeDrained(boolean readBufferOverflow) {
                return readBufferOverflow;
            }
        }
        ,
        IN_PROGRESS{

            @Override
            boolean shouldBeDrained(boolean readBufferOverflow) {
                return false;
            }
        }
        ,
        REQUIRED{

            @Override
            boolean shouldBeDrained(boolean readBufferOverflow) {
                return true;
            }
        };


        abstract boolean shouldBeDrained(boolean var1);
    }

    private class LogOpen
    implements Runnable {
        private final OClosableEntry<K, V> entry;

        private LogOpen(OClosableEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            if (!this.entry.isRetired() && !this.entry.isDead()) {
                OClosableLinkedContainer.this.lruList.moveToTheTail(this.entry);
                OClosableLinkedContainer.this.evict();
            }
        }
    }

    private class LogRemoved
    implements Runnable {
        private final OClosableEntry<K, V> entry;

        private LogRemoved(OClosableEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            if (this.entry.isRetired()) {
                OClosableLinkedContainer.this.lruList.remove(this.entry);
                this.entry.makeDead();
            }
        }
    }

    private class LogAdd
    implements Runnable {
        private final OClosableEntry<K, V> entry;

        private LogAdd(OClosableEntry<K, V> entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            if (!this.entry.isDead() && !this.entry.isRetired()) {
                OClosableLinkedContainer.this.lruList.moveToTheTail(this.entry);
                OClosableLinkedContainer.this.evict();
            }
        }
    }
}

