/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross.ui;

import com.ez.report.application.ui.wizard.PrepareReportWizard;
import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSrvWizard
extends PrepareReportWizard {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossSrvWizard.class);
    public static final String EXCLUDE_CROSS_PRJS_PAGE_NAME = "Cross projects to be excluded";
    public static final String OPTION_PAGE = "limit, direction options for cross";

    public IWizardPage getNextPage(IWizardPage page) {
        if (page.getName().equals("applications name page")) {
            List selPrjs = (List)this.getValue("selected resources");
            if (this.getValue("option to show wizard page with input as prg lvl") == null || selPrjs == null || selPrjs.size() == 0 || selPrjs.size() > 1) {
                return super.getPage(EXCLUDE_CROSS_PRJS_PAGE_NAME);
            }
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage.getName().equals("applications name page")) {
            List selPrjs = (List)this.getValue("selected resources");
            if (selPrjs != null && !selPrjs.isEmpty()) {
                return true;
            }
        } else {
            if (currentPage.getName().equals("programs page") || currentPage.getName().equals(OPTION_PAGE)) {
                return this.getContainer().getCurrentPage().canFlipToNextPage();
            }
            if (currentPage.getName().equals(EXCLUDE_CROSS_PRJS_PAGE_NAME)) {
                return true;
            }
        }
        return super.canFinish();
    }

    protected boolean buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.set("selectedPrograms", null);
            this.set("excludedProjects", null);
        }
        return super.buttonPressed(buttonId);
    }
}

