/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross.ui;

import com.ez.graphs.viewer.srvcross.internal.Messages;
import com.ez.graphs.viewer.srvcross.ui.CrossOptionPage;
import com.ez.graphs.viewer.srvcross.ui.CrossPrjInputGUI;
import com.ez.graphs.viewer.srvcross.ui.CrossPrjsCollector;
import com.ez.graphs.viewer.srvcross.ui.CrossProgramsCollector;
import com.ez.graphs.viewer.srvcross.ui.CrossSrvWizard;
import com.ez.graphs.viewer.srvcross.ui.CrossSrvWizardDialog;
import com.ez.graphs.viewer.srvcross.ui.SelectCrossPrjsAndOptionPage;
import com.ez.graphs.viewer.srvcross.ui.SelectExcludedCrossPrjsPage;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.gui.filters.AbstractProjectInputsFilter;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ez.report.application.ui.wizard.PrepareReportWizard;
import com.ez.report.application.ui.wizard.ReportWizardDialog;
import com.ez.report.application.ui.wizard.SelectProgramsPage;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.model.segments.EZSourceProgramIDSg;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.srvcross.core.utils.CrossUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSrvInputsFilter
extends AbstractProjectInputsFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossSrvInputsFilter.class);
    private PrepareReportWizard wizard;
    private CrossPrjsCollector collector;
    public static final String SELECTED_PROGRAMS = "selectedPrograms";
    public static final String AVAILABLE_PROGRAMS = "availablePrograms";
    public static final String SELECTED_PROJECTS = "excludedProjects";
    public static final String AVAILABLE_PROJECTS = "toBeConsideredProjects";
    public static final String ALLOW_PROGRAM_LVL_PAGE = "option to show wizard page with input as prg lvl";
    public static final String WIZARD_ON_PROJECTS = "wizard started on projects not program";
    private String prjName = null;
    private EZSourceProgramIDSg prgSg = null;

    protected ReportWizardDialog getWizardDialog(PrepareReportWizard wiz, Shell shell) {
        CrossSrvWizardDialog dialog = new CrossSrvWizardDialog(shell, (IWizard)wiz);
        return dialog;
    }

    protected PrepareReportWizard getWizard() {
        if (this.wizard == null) {
            this.wizard = new CrossSrvWizard();
            String wizardName = Messages.getString(CrossSrvInputsFilter.class, "wizard.title");
            this.wizard.setWindowTitle(wizardName);
            if (this.prjName != null && this.prgSg != null) {
                String pageTitle = Messages.getString(CrossSrvInputsFilter.class, "oPage.title");
                String pageDesc = Messages.getString(CrossSrvInputsFilter.class, "oPage.description");
                CrossOptionPage optionPage = new CrossOptionPage("limit, direction options for cross");
                optionPage.setTitle(pageTitle);
                optionPage.setDescription(pageDesc);
                this.wizard.addPage((IWizardPage)optionPage);
                try {
                    List cPrjs = CrossUtils.getCrossPrjs(CrossPrjsCollector.getAvailableMainframeProjects());
                    ArrayList<CrossPrjInputGUI> av = new ArrayList<CrossPrjInputGUI>();
                    ArrayList<CrossPrjInputGUI> sel = new ArrayList<CrossPrjInputGUI>();
                    for (Triplet p : cPrjs) {
                        CrossPrjInputGUI.CrossProjectInput prj = new CrossPrjInputGUI.CrossProjectInput((String)p.getFirst());
                        prj.guid = (String)p.getSecond();
                        prj.pId = (String)p.getThird();
                        if (((String)p.getFirst()).equals(this.prjName)) {
                            sel.add(new CrossPrjInputGUI(prj));
                            continue;
                        }
                        av.add(new CrossPrjInputGUI(prj));
                    }
                    this.wizard.set("selected resources", sel);
                    this.wizard.set("available resources", av);
                    ProgramInput pi = new ProgramInput(this.prgSg.getListableName(), this.prgSg.getTypeId(), this.prgSg.getProgramId());
                    pi.setAncestorDBId(this.prgSg.getAncestorId());
                    ArrayList<ProgramInput> prgList = new ArrayList<ProgramInput>();
                    prgList.add(pi);
                    this.wizard.set(SELECTED_PROGRAMS, prgList);
                }
                catch (Exception e) {
                    optionPage.setErrorMessage("Cross service " + e);
                    this.wizard.set("key for page with errror msg", (Object)Boolean.TRUE);
                }
            } else {
                SelectCrossPrjsAndOptionPage selectProjsPage = new SelectCrossPrjsAndOptionPage("applications name page", true, true, true);
                selectProjsPage.setResourcesCollector(this.collector);
                selectProjsPage.setTitle(Messages.getString(CrossSrvInputsFilter.class, "pageTitle"));
                selectProjsPage.setLeftGroupLabel(Messages.getString(CrossSrvInputsFilter.class, "available.projects.label"));
                selectProjsPage.setRightGroupLabel(Messages.getString(CrossSrvInputsFilter.class, "sel.projects.label"));
                selectProjsPage.setDescription(Messages.getString(CrossSrvInputsFilter.class, "pageDesc"));
                selectProjsPage.setErrMsgNoResource(Messages.getString(CrossSrvInputsFilter.class, "err.message"));
                this.wizard.addPage(selectProjsPage);
                SelectProgramsPage selectPrgsPage = new SelectProgramsPage("programs page", true, false);
                selectPrgsPage.setSelectedPropName(SELECTED_PROGRAMS);
                selectPrgsPage.setAvailablePropName(AVAILABLE_PROGRAMS);
                selectPrgsPage.setDescription(Messages.getString(CrossSrvInputsFilter.class, "pageDesc.prg"));
                selectPrgsPage.setTitle(Messages.getString(CrossSrvInputsFilter.class, "pageTitle.prg"));
                CrossProgramsCollector pc = new CrossProgramsCollector();
                selectPrgsPage.setResourcesCollector((ResourcesCollector)pc);
                this.wizard.addPage((IWizardPage)selectPrgsPage);
            }
            SelectExcludedCrossPrjsPage exclProjsPage = new SelectExcludedCrossPrjsPage("Cross projects to be excluded");
            CrossPrjsCollector exclCollector = new CrossPrjsCollector();
            exclProjsPage.setResourcesCollector(exclCollector);
            exclProjsPage.setTitle(Messages.getString(CrossSrvInputsFilter.class, "excl.pageTitle"));
            exclProjsPage.setLeftGroupLabel(Messages.getString(CrossSrvInputsFilter.class, "excl.available.projects.label"));
            exclProjsPage.setRightGroupLabel(Messages.getString(CrossSrvInputsFilter.class, "excl.sel.projects.label"));
            exclProjsPage.setDescription(Messages.getString(CrossSrvInputsFilter.class, "excl.pageDesc"));
            exclProjsPage.setErrMsgNoResource(Messages.getString(CrossSrvInputsFilter.class, "excl.err.message"));
            exclProjsPage.setSelectedPropName(SELECTED_PROJECTS);
            exclProjsPage.setAvailablePropName(AVAILABLE_PROJECTS);
            this.wizard.addPage(exclProjsPage);
        }
        return this.wizard;
    }

    public boolean filter(AbstractAnalysis analysis) {
        List anInputs = analysis.getContextListValue("ANALYSIS_TYPE_INPUTS");
        if (analysis.getContextValue(WIZARD_ON_PROJECTS) != null && ((Boolean)analysis.getContextValue(WIZARD_ON_PROJECTS)).booleanValue()) {
            List inputs = analysis.getContextListValue("input_list");
            this.collector = new CrossPrjsCollector(inputs);
        } else {
            EZEntityID prgInputType = ((EZObjectType)anInputs.get(0)).getEntID();
            EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)prgInputType.getSegment(EZSourceProjectIDSg.class);
            this.prgSg = (EZSourceProgramIDSg)prgInputType.getSegment(EZSourceProgramIDSg.class);
            this.prjName = prjSg.getProjectName();
        }
        return super.filter(analysis);
    }

    protected void processWizardData(PrepareReportWizard wizard, AbstractAnalysis analysis) throws Exception {
        this.preparePrjsData(wizard, analysis);
        List selPrgs = (List)wizard.getValue(SELECTED_PROGRAMS);
        L.debug("selected programs in wizard {}", (Object)selPrgs);
        analysis.addContextValue("selected programs as input", (Object)selPrgs);
        List exclPrjs = (List)wizard.getValue(SELECTED_PROJECTS);
        L.debug("excluded projects in wizard {}", (Object)exclPrjs);
        analysis.addContextValue("excluded cross projects", (Object)exclPrjs);
    }

    private void preparePrjsData(PrepareReportWizard wizard, AbstractAnalysis analysis) {
        List selPrjs = (List)wizard.getValue("selected resources");
        analysis.addContextValue("input_list", (Object)selPrjs);
        analysis.addContextValue("AUDIT_PROJ_NAMES", selPrjs.stream().map(CrossPrjInputGUI::getName).collect(Collectors.toList()));
        List avPrjs = (List)wizard.getValue("available resources");
        HashSet allPrjs = new HashSet();
        allPrjs.addAll(selPrjs);
        allPrjs.addAll(avPrjs);
        analysis.addContextValue("All cross projects filtered by the workspace restrictions", allPrjs);
    }
}

