/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross.ui;

import com.ez.common.ui.listselection.ImageObj4Wizard;
import com.ez.internal.utils.Pair;
import com.ez.report.application.model.ProgramInput;
import com.ez.report.application.ui.collectors.ProgramInputsFactory4Wizard;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ibm.ad.srvcross.core.utils.CrossUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossProgramsCollector
implements ResourcesCollector<ProgramInput> {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossProgramsCollector.class);
    private String pID;
    private List<ImageObj4Wizard> availableImages;

    public List collect(boolean useFilters, Set apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        List resources = null;
        if (this.availableImages != null) {
            this.availableImages.clear();
        }
        ProgramInputsFactory4Wizard factory = ProgramInputsFactory4Wizard.getInstance();
        String endpoint = CrossUtils.getQueryResultEndpoint();
        if (endpoint != null && !endpoint.isEmpty()) {
            String request = CrossUtils.prepareURL((String)endpoint, (Pair[])new Pair[]{new Pair((Object)"spName", (Object)"spRep_GetResourceDetails"), new Pair((Object)"params", (Object)"5,0"), new Pair((Object)"varParams1", (Object)this.pID)});
            JsonArray data = CrossUtils.runRequest((String)request);
            ArrayList<String[]> programs = new ArrayList<String[]>();
            int i = 0;
            while (i < data.size()) {
                JsonObject resInfo = data.getJsonObject(i);
                JsonValue path = (JsonValue)resInfo.get((Object)"PathStr");
                String pName = resInfo.getString("ResourceName");
                if (JsonValue.ValueType.NULL.equals((Object)path.getValueType())) {
                    L.debug("skip program {} because hasn't path", (Object)pName);
                } else {
                    String pTypeId = resInfo.getString("ResourceSubTypeID");
                    String pId = resInfo.getString("ResourceID");
                    JsonValue ancestorObj = (JsonValue)resInfo.get((Object)"ResourceAncestorName");
                    String ancestor = null;
                    if (!ancestorObj.equals(JsonValue.NULL)) {
                        ancestor = resInfo.getString("ResourceAncestorName");
                    }
                    String[] stringArray = new String[5];
                    stringArray[0] = pName;
                    stringArray[1] = pTypeId;
                    stringArray[3] = pId;
                    stringArray[4] = ancestor;
                    String[] info = stringArray;
                    programs.add(info);
                }
                ++i;
            }
            String[][] prgArray = new String[programs.size()][];
            programs.toArray((T[])prgArray);
            resources = factory.buildProgramInputs(prgArray);
            this.availableImages = factory.getAvailableImages();
        } else {
            L.warn("request results endpoint is not configured in CCS");
        }
        return resources;
    }

    public List<ImageObj4Wizard> getAvailableImages() {
        return this.availableImages;
    }

    public void setCrossPrjId(String pID) {
        this.pID = pID;
    }
}

