/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross.ui;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.common.ui.listselection.Listable;
import com.ez.graphs.viewer.srvcross.ui.CrossPrjInputGUI;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.report.application.ui.collectors.ResourcesCollector;
import com.ibm.ad.srvcross.core.utils.CrossUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossPrjsCollector
implements ResourcesCollector {
    public static final String COPYRIGHT = "Licensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger L = LoggerFactory.getLogger(CrossPrjsCollector.class);
    private List<ProjectInfo> selList;
    private List<Listable> selPrjs = new ArrayList<Listable>();

    public CrossPrjsCollector() {
        this.selList = null;
    }

    public CrossPrjsCollector(List<ProjectInfo> selList) {
        this.selList = selList;
    }

    public List collect(boolean useFilters, Set apps, String prjName, IProgressMonitor pMonitor) throws Exception {
        ArrayList<CrossPrjInputGUI> prjs = new ArrayList<CrossPrjInputGUI>();
        Set<String> allPrjs = CrossPrjsCollector.getAvailableMainframeProjects();
        List cPrjs = CrossUtils.getCrossPrjs(allPrjs);
        if (cPrjs != null) {
            for (Triplet p : cPrjs) {
                CrossPrjInputGUI.CrossProjectInput prj = new CrossPrjInputGUI.CrossProjectInput((String)p.getFirst());
                prj.guid = (String)p.getSecond();
                prj.pId = (String)p.getThird();
                if (this.isSelected((String)p.getFirst())) {
                    this.selPrjs.add((Listable)new CrossPrjInputGUI(prj));
                    continue;
                }
                prjs.add(new CrossPrjInputGUI(prj));
            }
        }
        return prjs;
    }

    public static Set<String> getAvailableMainframeProjects() {
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        List projects = service.getProjects();
        HashSet<String> allPrjs = new HashSet<String>();
        for (ProjectInfo pInfo : projects) {
            if (pInfo.isEclipse()) continue;
            allPrjs.add(pInfo.getName());
        }
        return allPrjs;
    }

    private boolean isSelected(String name) {
        if (this.selList == null) {
            return false;
        }
        for (ProjectInfo pi : this.selList) {
            if (!name.equals(pi.getName())) continue;
            return true;
        }
        return false;
    }

    public List getAvailableImages() {
        return null;
    }

    public List<Listable> getSelPrjs() {
        return this.selPrjs;
    }
}

