/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross.ui;

import com.ez.graphs.viewer.srvcross.internal.Messages;
import com.ez.mainframe.gui.utils.Utils;
import com.ez.mainframe.model.Direction;
import com.ez.report.application.ui.wizard.AbstractWizardPage;
import com.ez.workspace.preferences.WorkspacePrefUtils;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class CrossOptionPage
extends AbstractWizardPage {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private Button backwardButton;
    private Button forwardButton;
    private Button limitCheckboxButton;
    private Button limitResourcesButton;
    private Text thresholdLimit;
    private Label thresholdLimitLbl;
    private static final String errorMsg = Messages.getString(CrossOptionPage.class, "level.thresold.error");
    private String limitGroupText = null;
    private String limitButtonText = null;
    public static final String PAGE_NOT_FINISH = "key for page with errror msg";
    private boolean showLimitResources = true;
    private boolean showSelectDirection = true;
    private boolean showLimitCg = true;
    private String directionGroupText = null;

    public CrossOptionPage(String pageName) {
        super(pageName);
    }

    protected void createContent(Composite composite) {
        ChoiceSelection cs = new ChoiceSelection();
        Composite fakeParent = new Composite(composite, composite.getStyle());
        GridData data = new GridData(4);
        data.horizontalIndent = 45;
        fakeParent.setLayoutData((Object)data);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 50;
        gl.marginRight = 5;
        fakeParent.setLayout((Layout)gl);
        if (this.showSelectDirection || this.showLimitCg) {
            this.createDirectionGroup(fakeParent, cs);
        }
        if (this.showLimitResources) {
            this.createRestrictionsGroup(fakeParent, cs);
        }
    }

    private void createRestrictionsGroup(Composite parent, ChoiceSelection cs) {
        Group limitGroup = new Group(parent, parent.getStyle());
        if (this.limitGroupText != null) {
            limitGroup.setText(this.limitGroupText);
        } else {
            limitGroup.setText(Messages.getString(CrossOptionPage.class, "limit.group.txt"));
        }
        GridData data = new GridData(4);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 16384;
        limitGroup.setLayoutData((Object)data);
        FormLayout fl = new FormLayout();
        limitGroup.setLayout((Layout)fl);
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        boolean value = store.getBoolean("callgraphWithoutResources");
        this.limitResourcesButton = new Button((Composite)limitGroup, 32);
        if (this.limitButtonText != null) {
            this.limitResourcesButton.setText(this.limitButtonText);
        } else {
            this.limitResourcesButton.setText(Messages.getString(CrossOptionPage.class, "limit.resources.btn.txt"));
        }
        FormData fdata2 = new FormData();
        fdata2.top = new FormAttachment((Control)this.limitCheckboxButton, 15, 16384);
        this.limitResourcesButton.setLayoutData((Object)fdata2);
        this.limitResourcesButton.addSelectionListener((SelectionListener)cs);
        this.limitResourcesButton.setSelection(value);
        this.wizard.set("graph without resources", (Object)value);
        final Group resGroup = new Group((Composite)limitGroup, 0);
        GridLayout gl = new GridLayout(4, false);
        resGroup.setLayout((Layout)gl);
        resGroup.setText("Resources");
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(83, 0);
        fd.top = new FormAttachment((Control)this.limitResourcesButton, 5);
        resGroup.setLayoutData((Object)fd);
        resGroup.setEnabled(!value);
        for (final String lbl : Utils.resourceTypesLbl.keySet()) {
            Button button = new Button((Composite)resGroup, 32);
            button.setText(lbl);
            boolean isChecked = store.getBoolean(lbl);
            this.addResStateToWizard(lbl, isChecked);
            button.setSelection(isChecked);
            button.setEnabled(!value);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button sourceBtn = (Button)e.getSource();
                    CrossOptionPage.this.addResStateToWizard(lbl, sourceBtn.getSelection());
                }
            });
        }
        this.limitResourcesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                resGroup.setEnabled(!CrossOptionPage.this.limitResourcesButton.getSelection());
                Control[] controlArray = resGroup.getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.setEnabled(!CrossOptionPage.this.limitResourcesButton.getSelection());
                    ++n2;
                }
            }
        });
    }

    private void addResStateToWizard(String btnLbl, boolean btnState) {
        HashMap<String, Boolean> states = this.wizard.getMap("graph resources checked or not");
        if (states == null) {
            states = new HashMap<String, Boolean>();
            this.wizard.set("graph resources checked or not", states);
        }
        states.put(btnLbl, btnState);
    }

    private void createDirectionGroup(Composite parent, ChoiceSelection cs) {
        Group directionGroup = new Group(parent, parent.getStyle());
        if (this.directionGroupText != null) {
            directionGroup.setText(this.directionGroupText);
        } else {
            directionGroup.setText(Messages.getString(((Object)((Object)this)).getClass(), "direction.group.txt"));
        }
        GridData data = new GridData(4);
        directionGroup.setLayoutData((Object)data);
        GridLayout gl = new GridLayout(3, true);
        gl.horizontalSpacing = 100;
        directionGroup.setLayout((Layout)gl);
        if (this.showSelectDirection) {
            this.forwardButton = new Button((Composite)directionGroup, 16);
            this.forwardButton.setText(Messages.getString(CrossOptionPage.class, "forward.btn.txt"));
            this.forwardButton.addSelectionListener((SelectionListener)cs);
            this.forwardButton.setData((Object)Direction.FORWARD);
            this.forwardButton.setSelection(true);
            this.wizard.set("graph direction: forward or backward or both", (Object)Direction.FORWARD);
            this.backwardButton = new Button((Composite)directionGroup, 16);
            this.backwardButton.setText(Messages.getString(CrossOptionPage.class, "backward.btn.txt"));
            this.backwardButton.addSelectionListener((SelectionListener)cs);
            this.backwardButton.setData((Object)Direction.BACKWARD);
            this.backwardButton.setSelection(false);
        }
        if (this.showLimitCg) {
            Composite fakeGr = new Composite((Composite)directionGroup, parent.getStyle());
            data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.grabExcessVerticalSpace = true;
            data.horizontalSpan = 3;
            data.minimumWidth = 480;
            fakeGr.setLayoutData((Object)data);
            FormLayout fl = new FormLayout();
            fakeGr.setLayout((Layout)fl);
            this.createLimitGroup(fakeGr, cs);
        }
    }

    private void createLimitGroup(Composite comp, ChoiceSelection cs) {
        Label sep = null;
        if (this.showSelectDirection) {
            sep = new Label(comp, 258);
            sep.setAlignment(16384);
            FormData fdata = new FormData();
            fdata.left = new FormAttachment(0, 0);
            fdata.right = new FormAttachment(100, 0);
            fdata.top = new FormAttachment((Control)comp, 10);
            sep.setLayoutData((Object)fdata);
        }
        IPreferenceStore store = WorkspacePrefUtils.getPreferenceStore();
        int levelLimit = store.getInt("callgraphLimitExceed");
        boolean isLimited = store.getBoolean("callgraphLevelsLimitedPreference");
        this.limitCheckboxButton = new Button(comp, 32);
        if (this.limitButtonText != null) {
            this.limitCheckboxButton.setText(this.limitButtonText);
        } else {
            this.limitCheckboxButton.setText(Messages.getString(CrossOptionPage.class, "limit.cg.btn.txt"));
        }
        FormData fdata = new FormData();
        fdata.top = new FormAttachment((Control)(sep != null ? sep : comp), 15);
        this.limitCheckboxButton.setLayoutData((Object)fdata);
        this.limitCheckboxButton.addSelectionListener((SelectionListener)cs);
        this.limitCheckboxButton.setSelection(isLimited);
        this.wizard.set("is graph limited", (Object)isLimited);
        this.thresholdLimitLbl = new Label(comp, 0);
        this.thresholdLimitLbl.setText(Messages.getString(CrossOptionPage.class, "level.threshold.txt"));
        fdata = new FormData();
        fdata.top = new FormAttachment((Control)this.limitCheckboxButton, 15);
        this.thresholdLimitLbl.setLayoutData((Object)fdata);
        this.thresholdLimit = new Text(comp, 2048);
        this.thresholdLimit.setText("" + levelLimit);
        this.wizard.set("limit number for graph levels", (Object)(isLimited ? Integer.valueOf(levelLimit) : null));
        fdata = new FormData();
        fdata.top = new FormAttachment((Control)this.limitCheckboxButton, 15);
        fdata.left = new FormAttachment((Control)this.thresholdLimitLbl, 5);
        fdata.right = new FormAttachment(100, 0);
        this.thresholdLimit.setLayoutData((Object)fdata);
        this.thresholdLimit.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrossOptionPage.this.catchThresholdLimit();
                CrossOptionPage.this.setPageComplete(CrossOptionPage.this.isPageComplete());
            }
        });
        this.thresholdLimitLbl.setEnabled(isLimited);
        this.thresholdLimit.setEnabled(isLimited);
    }

    private void catchThresholdLimit() {
        block6: {
            String text = this.thresholdLimit.getText();
            Integer threshold = null;
            try {
                try {
                    threshold = Integer.valueOf(text);
                    if (threshold < 0) {
                        this.setErrorMessage(errorMsg);
                        break block6;
                    }
                    this.setErrorMessage(null);
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(errorMsg);
                    this.wizard.set("limit number for graph levels", (Object)threshold);
                }
            }
            finally {
                this.wizard.set("limit number for graph levels", (Object)threshold);
            }
        }
    }

    public boolean isPageComplete() {
        boolean ret = true;
        if (this.showSelectDirection && this.wizard.getValue("graph direction: forward or backward or both") == null) {
            ret = false;
        }
        if (ret && this.showLimitCg && Boolean.TRUE.equals(this.wizard.getValue("is graph limited")) && this.wizard.getValue("limit number for graph levels") == null) {
            ret = false;
        }
        return ret;
    }

    class ChoiceSelection
    implements SelectionListener {
        ChoiceSelection() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button b = (Button)e.getSource();
            if ((b.equals(CrossOptionPage.this.backwardButton) || b.equals(CrossOptionPage.this.forwardButton)) && b.getSelection()) {
                Direction direction = (Direction)b.getData();
                CrossOptionPage.this.wizard.set("graph direction: forward or backward or both", (Object)direction);
            }
            if (b.equals(CrossOptionPage.this.limitCheckboxButton)) {
                boolean isCgLimited = CrossOptionPage.this.limitCheckboxButton.getSelection();
                CrossOptionPage.this.wizard.set("is graph limited", (Object)isCgLimited);
                CrossOptionPage.this.thresholdLimit.setEnabled(isCgLimited);
                if (isCgLimited) {
                    CrossOptionPage.this.catchThresholdLimit();
                } else {
                    CrossOptionPage.this.wizard.set("limit number for graph levels", null);
                    CrossOptionPage.this.setErrorMessage(null);
                }
            }
            if (b.equals(CrossOptionPage.this.limitResourcesButton)) {
                boolean isResourcesLimited = CrossOptionPage.this.limitResourcesButton.getSelection();
                CrossOptionPage.this.wizard.set("graph without resources", (Object)isResourcesLimited);
            }
            CrossOptionPage.this.setPageComplete(CrossOptionPage.this.isPageComplete());
        }
    }
}

