/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross;

import com.ez.cobol.callgraph.CallgraphEdgeLegendInfo;
import com.ez.cobol.callgraph.nodes.MainframeSourceNode;
import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.gdb.core.itf.IODBAdminService;
import com.ez.gdb.core.utils.ConnectionUtils;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.callgraph.programcallgraph.CallGraphModel;
import com.ez.graphs.viewer.callgraph.programcallgraph.CgBuilder;
import com.ez.graphs.viewer.callgraph.utils.GraphUtils;
import com.ez.graphs.viewer.srvcross.CrossSrvGraphAnalysis;
import com.ez.graphs.viewer.srvcross.EZCrossObjectType;
import com.ez.graphs.viewer.utils.GraphsErrorLog;
import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.data.callgraph.ResourceLink;
import com.ez.mainframe.data.results.ResultElementType;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.mainframe.data.utils.Utils;
import com.ez.mainframe.gui.properties.GenericProgramRelatedNode;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProgramType;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.mainframe.model.StatementNode;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ExportAsCSV;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.IGraphNodeLegendInfo;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSEEdge;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.graphicaldrawing.awt.TSEColor;
import com.tomsawyer.graphicaldrawing.awt.TSESVGImage;
import com.tomsawyer.graphicaldrawing.builder.TSNodeBuilder;
import com.tomsawyer.graphicaldrawing.complexity.TSENestingManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSrvGraphModel
extends CallGraphModel {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossSrvGraphModel.class);
    private static final String prjInventoryLbl = Messages.getString(CrossSrvGraphModel.class, (String)"prj.inv");
    public static final String PRJ_CROSS_ID_ATTR = "ProjectID";
    public static final String INPUT_PRJS_SB_ATTR = "input cross projects ids";
    public static final String SELECTED_PRJS_SB_ATTR = "selected cross projects ids";
    public static final String FILTERED_RESOURCES_SB_ATTR = "selected resources with cross prj id and resource type";
    public static final String INPUT_PROGRAM_KEYS = "getKey for selected programs from a single project";
    public static final String INPUT_PROGRAM_IDS = "sid selected programs from a single project";
    private static final String EXTERNAL_COBOL_TYPE = "2500001";
    private static final String EXTERNAL_PL1_TYPE = "2500002";
    private static final String EXTERNAL_CICSTRANSACTION_TYPE = "2000014";
    private static final String EXTERNAL_IMSTRANSACTION_TYPE = "2000020";
    private static final String QUOTE = "'";
    private static final String SEPARATOR = ",";
    private Map<String, String> programsAncestorMap = new HashMap<String, String>();
    private Map<String, TextSelectionInFile> programsStmtMap = new HashMap<String, TextSelectionInFile>();
    private Map<EZSourceProjectIDSg, Set<Integer>> prgForInternalCg = new HashMap<EZSourceProjectIDSg, Set<Integer>>();
    private Map<EZSourceProjectIDSg, Set<String>> tranForInternalCg = new HashMap<EZSourceProjectIDSg, Set<String>>();
    private Map<EZSourceProjectIDSg, Set<Integer>> prgNotToBeDisplayed = new HashMap<EZSourceProjectIDSg, Set<Integer>>();
    private Map<EZSourceProjectIDSg, Boolean> internalCgStatus = new HashMap<EZSourceProjectIDSg, Boolean>();

    public CrossSrvGraphModel(AnalysisGraphManager graphManager, Direction cgDirection, AbstractSharedAnalysis analysis) {
        super(graphManager, cgDirection, (AbstractSharedAnalysis)((CrossSrvGraphAnalysis)analysis));
        this.isSrvCross = true;
        this.initialize();
    }

    private void initialize() {
        if (!TSESVGImage.isBatikInitialized()) {
            TSESVGImage.initBatik();
        }
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
    }

    protected void initGraph() {
        this.graph = (TSEGraph)((AnalysisGraphManager)this.graphManager).addGraph();
        this.outForGISV.clear();
        TSNodeBuilder nodeBuilder = this.graphManager.getNodeBuilder();
        nodeBuilder.setResizability(3);
        ArrayList<Class<ExportAsCSV>> impl = new ArrayList<Class<ExportAsCSV>>();
        impl.add(ExportAsCSV.class);
        this.graphManager.setAttribute("extraExportListImplementors", impl);
        Direction direction = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        this.graphManager.setAttribute("graph direction", (Object)direction.ordinal());
        Boolean isCgLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (isCgLimited != null && isCgLimited.booleanValue()) {
            this.graphManager.setAttribute("graph limitation", (Object)((Integer)this.analysis.getContextValue("limit number for graph levels")));
        }
        this.graphManager.setAttribute("startedOnPrgs", (Object)((Boolean)this.analysis.hasContextKey(INPUT_PROGRAM_IDS) != false && !this.analysis.getContextSetValue(INPUT_PROGRAM_IDS).isEmpty() ? 1 : 0));
        this.graphManager.setAttribute("isCrossSrv", (Object)Boolean.TRUE);
        this.graphManager.setAttribute("IS_CROSS_ANALYSIS_GRAPH", (Object)Boolean.TRUE);
        this.graphManager.setAttribute("markPrjAsInput", this.analysis.getContextValue("input_project_names"));
        this.graphManager.setAttribute("Projects_TS_map", new HashMap());
        this.graphManager.setRestoreMetaEdgeStateIfPossible(true);
        this.analysis.addContextValue("PROGRAM_CALLGRAPH", (Object)Boolean.TRUE);
        this.prgForInternalCg.clear();
        this.prgNotToBeDisplayed.clear();
        this.tranForInternalCg.clear();
        this.internalCgStatus.clear();
    }

    /*
     * Unable to fully structure code
     */
    public void loadGraph(IProgressMonitor monitor) {
        block23: {
            pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            pmonitor.setTaskName(Messages.getString(CrossSrvGraphModel.class, (String)"loading.graph"));
            this.initGraph();
            this.programsAncestorMap.clear();
            this.programsStmtMap.clear();
            data = (JsonArray)this.analysis.getContextValue("data from SP_PROJECT_RELATION_DETAILS");
            if (data == null) break block23;
            piMap = (Map)this.analysis.getContextValue("all projects");
            allPrjsMap = TSGraphUtils.computeAllPrj(piMap.values());
            prjTSMap = (Map)this.graphManager.getAttributeValue("Projects_TS_map");
            this.prepareProgramsDetails();
            inputPrjs = this.analysis.getContextSetValue("input_project_names");
            isCgWithoutResources = (Boolean)this.analysis.getContextValue("graph without resources");
            isCgWithoutResources = isCgWithoutResources == null ? false : isCgWithoutResources;
            rStates = (Map)this.analysis.getContextValue("graph resources checked or not");
            cicsTranCheck = (Boolean)rStates.get("CICS Transaction");
            imsTranCheck = (Boolean)rStates.get("IMS");
            i = 0;
            while (i < data.size()) {
                block26: {
                    block24: {
                        block25: {
                            resInfo = data.getJsonObject(i);
                            fromPId = resInfo.getString("ProjectFromID");
                            fromPName = resInfo.getString("ProjectFromName");
                            toPId = resInfo.getString("ProjectToID");
                            toPName = resInfo.getString("ProjectToName");
                            fromResID = resInfo.getString("ResourceFromID");
                            fromResName = resInfo.getString("ResourceFromName");
                            fromResTypeID = resInfo.getString("ResourceFromTypeID");
                            fromSubTypeID = resInfo.getString("ResourceFromSubTypeID");
                            toResID = resInfo.getString("ResourceToID");
                            toResName = resInfo.getString("ResourceToName");
                            toResTypeID = resInfo.getString("ResourceToTypeID");
                            toSubTypeID = resInfo.getString("ResourceToSubTypeID");
                            if (isCgWithoutResources.booleanValue()) break block24;
                            if (cicsTranCheck.booleanValue() || !toResTypeID.equals("14")) break block25;
                            CrossSrvGraphModel.L.debug("CICS Transaction not check ; ignore {}", (Object)resInfo);
                            break block26;
                        }
                        if (imsTranCheck.booleanValue() || !toResTypeID.equals("20")) ** GOTO lbl-1000
                        CrossSrvGraphModel.L.debug("IMS not check ; ignore {}", (Object)resInfo);
                        break block26;
                    }
                    if (toResTypeID.equals("14") || toResTypeID.equals("20")) {
                        CrossSrvGraphModel.L.debug("Callgraph without resources ; ignore {}", (Object)resInfo);
                    } else lbl-1000:
                    // 2 sources

                    {
                        fromPrjIdSg = (EZSourceProjectIDSg)allPrjsMap.get(fromPName);
                        fromG = TSGraphUtils.getOrCreatePrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (EZSourceProjectIDSg)fromPrjIdSg, (boolean)false);
                        ((TSENode)prjTSMap.get(fromPName)).setAttribute("ProjectID", (Object)fromPId);
                        fromNode = this.getOrCreateTSNode(fromG, fromResID, fromResName, fromSubTypeID, this.isProgram(fromResTypeID));
                        toPrjIdSg = (EZSourceProjectIDSg)allPrjsMap.get(toPName);
                        toG = TSGraphUtils.getOrCreatePrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (EZSourceProjectIDSg)toPrjIdSg, (boolean)false);
                        ((TSENode)prjTSMap.get(toPName)).setAttribute("ProjectID", (Object)toPId);
                        isPrg = this.isProgram(toResTypeID);
                        toNode = this.getOrCreateTSNode(toG, toResID, toResName, toSubTypeID, isPrg);
                        prjForCg = fromPrjIdSg;
                        resIdForCg = fromResID;
                        resNameForCg = fromResName;
                        resTypeForCg = fromResTypeID;
                        if (Direction.doForward((Direction)this.cgDirection)) {
                            prjForCg = toPrjIdSg;
                            resIdForCg = toResID;
                            resNameForCg = toResName;
                            resTypeForCg = toResTypeID;
                            linkResTypeID = resInfo.getString("ResourceLinkTypeID");
                            if (this.isProgram(linkResTypeID)) {
                                linkResID = resInfo.getString("ResourceLinkID");
                                notToShowPrgs = this.prgNotToBeDisplayed.get(fromPrjIdSg);
                                if (notToShowPrgs == null) {
                                    notToShowPrgs = new HashSet<Integer>();
                                    this.prgNotToBeDisplayed.put(fromPrjIdSg, notToShowPrgs);
                                }
                                notToShowPrgs.add(Integer.valueOf(linkResID));
                            }
                        }
                        if (isPrg = this.isProgram(resTypeForCg)) {
                            prgs = this.prgForInternalCg.get(prjForCg);
                            if (prgs == null) {
                                prgs = new HashSet<Integer>();
                                this.prgForInternalCg.put(prjForCg, prgs);
                            }
                            prgs.add(Integer.valueOf(resIdForCg));
                        } else {
                            trans = this.tranForInternalCg.get(prjForCg);
                            if (trans == null) {
                                trans = new HashSet<String>();
                                this.tranForInternalCg.put(prjForCg, trans);
                            }
                            trans.add("'".concat(resNameForCg).concat("'"));
                        }
                        if (Direction.doForward((Direction)this.cgDirection)) {
                            if (inputPrjs.contains(fromPName) && this.isProgram(fromResTypeID)) {
                                prgs = this.prgForInternalCg.get(allPrjsMap.get(fromPName));
                                if (prgs == null) {
                                    prgs = new HashSet<Integer>();
                                    this.prgForInternalCg.put((EZSourceProjectIDSg)allPrjsMap.get(fromPName), prgs);
                                }
                                prgs.add(Integer.valueOf(fromResID));
                            }
                        } else if (inputPrjs.contains(toPName) && this.isProgram(toResTypeID)) {
                            prgs = this.prgForInternalCg.get(allPrjsMap.get(toPName));
                            if (prgs == null) {
                                prgs = new HashSet<Integer>();
                                this.prgForInternalCg.put((EZSourceProjectIDSg)allPrjsMap.get(toPName), prgs);
                            }
                            prgs.add(Integer.valueOf(toResID));
                        }
                        stmtId = resInfo.getString("OriginID");
                        flag = resInfo.getString("Flag");
                        pfromSubTypeID = this.normalizeSubType(fromSubTypeID);
                        this.makeCallExtEdge(fromNode, toNode, fromPName, pfromSubTypeID, stmtId, "1".equals(flag));
                    }
                }
                ++i;
            }
            pmonitor.setWorkRemaining(70);
            this.programsStmtMap.clear();
            this.programsAncestorMap.clear();
            GraphAnalysisJob.createMetaEdges((TSEGraphManager)this.graphManager);
            sumData = (JsonArray)this.analysis.getContextValue("data from SP_PROJECT_SUMMARY");
            if (sumData != null) {
                i = 0;
                while (i < sumData.size()) {
                    resInfo = sumData.getJsonObject(i);
                    fromPName = resInfo.getString("ProjectFromName");
                    toPName = resInfo.getString("ProjectToName");
                    weight = resInfo.getString("NumberOfRelations");
                    fNode = (TSENode)prjTSMap.get(fromPName);
                    edge = this.graphManager.getMetaEdge((TSDNode)fNode, (TSDNode)(tNode = (TSENode)prjTSMap.get(toPName)));
                    if (edge != null) {
                        lbl = edge.addLabel();
                        lbl.setName((Object)weight);
                    } else {
                        CrossSrvGraphModel.L.debug("edge doesn't exist); was filtered by programs selection from input");
                    }
                    ++i;
                }
            }
            if (!this.analysis.getContextSetValue("getKey for selected programs from a single project").isEmpty()) {
                selectedPrjs = (Set)this.analysis.getContextValue("input_project_names");
                prjName = (String)selectedPrjs.iterator().next();
                sg = (EZSourceProjectIDSg)allPrjsMap.get(prjName);
                ss = this.prgForInternalCg.get(sg);
                if (ss == null) {
                    ss = new HashSet<Integer>();
                    this.prgForInternalCg.put(sg, ss);
                }
                ss.addAll(this.analysis.getContextSetValue("sid selected programs from a single project"));
                this.buildInternalCg((EZSourceProjectIDSg)allPrjsMap.get(prjName), pmonitor.newChild(50));
                iNode = (TSENode)prjTSMap.get(prjName);
                TSENestingManager.expand((TSDNode)iNode);
                GraphAnalysisJob.createMetaEdges((TSEGraphManager)this.graphManager);
            }
        }
        if (this.graph.nodeSet.size() == 0) {
            node = (TSENode)this.graph.addNode();
            node.setName((Object)Messages.getString(CrossSrvGraphModel.class, (String)"noresults.node.name"));
            CrossSrvGraphModel.L.debug("no results for cross graph with service ");
            return;
        }
        pmonitor.setWorkRemaining(0);
    }

    protected Set<String> getInputOrids() {
        return null;
    }

    protected void buildInternalCgs(IProgressMonitor pmonitor) {
        HashSet<EZSourceProjectIDSg> allPrjs = new HashSet<EZSourceProjectIDSg>();
        allPrjs.addAll(this.prgForInternalCg.keySet());
        allPrjs.addAll(this.tranForInternalCg.keySet());
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)(100 * allPrjs.size()));
        monitor.setTaskName(Messages.getString(CrossSrvGraphModel.class, (String)"collectingData.taskName"));
        for (EZSourceProjectIDSg prjIdSg : allPrjs) {
            this.buildInternalCg(prjIdSg, monitor.newChild(100));
        }
        monitor.setWorkRemaining(0);
    }

    protected void buildInternalCg(EZSourceProjectIDSg prjIdSg, SubMonitor monitor) {
        boolean ok;
        this.ezsourcePrj = prjIdSg.getProjectInfo();
        String prjName = prjIdSg.getProjectName();
        if (this.internalCgStatus.containsKey(prjIdSg)) {
            L.debug("do not build again internal callgraph for project {}; already drawn", (Object)prjName);
            return;
        }
        SubMonitor pmonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        pmonitor.setTaskName(Messages.getString(CrossSrvGraphModel.class, (String)"buildingCg.taskName", (Object[])new String[]{prjName}));
        IODBAdminService service = (IODBAdminService)ServiceUtils.getService(IODBAdminService.class);
        if (service != null && !(ok = service.hasDatabase(prjName))) {
            L.warn("can't access gdb for project {}", (Object)prjName);
            GraphsErrorLog.warn((String)Messages.getString(CrossSrvGraphModel.class, (String)"gdb.not.found", (Object[])new String[]{prjName}), null);
            return;
        }
        Properties env = ConnectionUtils.getODBSettings((String)prjName);
        this.dbg = ConnectionUtils.getNoTxGraph((Properties)env);
        try {
            Set<String> tranInfo = this.tranForInternalCg.get(prjIdSg);
            HashSet backFromTran = new HashSet();
            HashSet forwFromTran = new HashSet();
            HashSet prgSIDs = new HashSet();
            HashSet<String> idsSet = new HashSet<String>();
            if (tranInfo != null) {
                StringBuilder tranSb = new StringBuilder();
                String str = tranInfo.toString();
                tranSb.append(str.substring(1, str.length() - 1));
                idsSet.addAll(this.createTransactionContext(prjName, this.dbg, tranSb, backFromTran, forwFromTran, prgSIDs, false));
            }
            HashSet back = new HashSet();
            HashSet forw = new HashSet();
            if (this.cgDirection.equals((Object)Direction.BACKWARD)) {
                back.addAll(backFromTran);
                L.debug("programs sid executing one of the transactions {} in project {}", tranInfo, (Object)prjName);
                if (this.prgForInternalCg.get(prjIdSg) != null) {
                    back.addAll(this.prgForInternalCg.get(prjIdSg));
                }
            } else {
                forw.addAll(forwFromTran);
                L.debug("programs sid mapped with transaction {} in project {}", tranInfo, (Object)prjName);
                if (this.prgForInternalCg.get(prjIdSg) != null) {
                    forw.addAll(this.prgForInternalCg.get(prjIdSg));
                }
            }
            CgBuilder cgb = new CgBuilder(prjName, this.dbg, this.analysis, this.cgDirection, false);
            prgSIDs.addAll(forw);
            prgSIDs.addAll(back);
            String query = "select @rid.asString() as prgRid from Program where sid in ? ";
            CloseableIterable res1 = (CloseableIterable)this.dbg.command((OCommandRequest)new OCommandSQL(query)).execute(new Object[]{prgSIDs});
            if (res1.iterator().hasNext()) {
                for (OrientElement elem : res1) {
                    String rid = (String)elem.getProperty("prgRid");
                    idsSet.add(rid);
                }
            }
            cgb.computeCg(back, forw, new HashSet(), idsSet, pmonitor.newChild(20));
            this.cg = TSGraphUtils.getOrCreatePrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (EZSourceProjectIDSg)prjIdSg, (boolean)true);
            HashMap tsLevels = (HashMap)this.cg.getAttributeValue("levelMap");
            if (tsLevels != null) {
                tsLevels.clear();
            } else {
                tsLevels = new HashMap();
                this.cg.setAttribute("levelMap", tsLevels);
            }
            HashMap prgRIDs = new HashMap();
            this.cg.setAttribute("PROGRAM_TS_NODES", prgRIDs);
            HashMap tsNodes = (HashMap)this.cg.getAttributeValue("TS nodes per project");
            if (tsNodes == null) {
                tsNodes = new HashMap();
                this.cg.setAttribute("TS nodes per project", tsNodes);
            }
            pmonitor.worked(70);
            if (pmonitor.isCanceled()) {
                return;
            }
            if (!pmonitor.isCanceled() && !forw.isEmpty()) {
                pmonitor.setTaskName(Messages.getString(CrossSrvGraphModel.class, (String)"draw.forward", (Object[])new String[]{prjName}));
                if (this.prgNotToBeDisplayed.containsKey(prjIdSg)) {
                    this.cg.setAttribute("PROGRAM_EXCLUDED_FROM_GRAPH", this.prgNotToBeDisplayed.get(prjIdSg));
                }
                Map forwardPrg = (Map)this.analysis.removeContextValue(CgBuilder.getKey((String)prjName, (String)"programs_Info_forward"));
                L.debug("drawing forward internal callgraph {} ", forwardPrg.keySet());
                this.drawPrgCallgraph(forwardPrg, true, (IProgressMonitor)pmonitor.newChild(10));
            }
            if (!pmonitor.isCanceled() && !back.isEmpty()) {
                pmonitor.setTaskName(Messages.getString(CrossSrvGraphModel.class, (String)"draw.backward", (Object[])new String[]{prjName}));
                Map backwardPrg = (Map)this.analysis.removeContextValue(CgBuilder.getKey((String)prjName, (String)"programs_Info_backward"));
                L.debug("drawing backward internal callgraph {} ", backwardPrg.keySet());
                this.drawPrgCallgraph(backwardPrg, false, (IProgressMonitor)pmonitor.newChild(10));
            }
            this.drawTranToMappedPrg(prjName);
            for (String res : GraphUtils.resourceTypes) {
                this.buildResources(this.cg, prjName, res, (IProgressMonitor)pmonitor.newChild(10));
            }
            this.doJCLInCg(monitor.newChild(10));
            this.internalCgStatus.put(prjIdSg, Boolean.TRUE);
        }
        finally {
            ConnectionUtils.releaseGraph((OrientBaseGraph)this.dbg, (Properties)env);
            this.dbg = null;
        }
        this.createCustomHLayoutCommand((TSDGraph)this.cg);
        pmonitor.worked(10);
        this.findAnnotations(pmonitor.newChild(10));
    }

    protected boolean shouldNotDrawTSNode(Vertex v) {
        Set excluded;
        boolean ret = false;
        Integer resId = (Integer)v.getProperty("sid");
        if (this.cg.hasAttribute("PROGRAM_EXCLUDED_FROM_GRAPH") && (excluded = (Set)this.cg.getAttributeValue("PROGRAM_EXCLUDED_FROM_GRAPH")) != null && excluded.contains(resId)) {
            L.debug("in project {} , resource {} was not drawn because was found in another project", (Object)this.ezsourcePrj.getName(), (Object)resId);
            ret = true;
        }
        return ret;
    }

    private void prepareProgramsDetails() {
        JsonArray data = (JsonArray)this.analysis.getContextValue("data from SP_GETRESOURCES");
        if (data != null) {
            int i = 0;
            while (i < data.size()) {
                JsonValue pathObj;
                JsonObject resInfo = data.getJsonObject(i);
                String prjName = resInfo.getString("ProjectName");
                String pTypeId = resInfo.getString("ResourceSubTypeID");
                String pId = resInfo.getString("ResourceID");
                String key = TSGraphUtils.getKey((String)prjName, (String)pId, (String)pTypeId);
                JsonValue ancestorObj = (JsonValue)resInfo.get((Object)"ResourceAncestorName");
                String ancestor = null;
                if (!ancestorObj.equals(JsonValue.NULL)) {
                    ancestor = resInfo.getString("ResourceAncestorName");
                    this.programsAncestorMap.put(key, ancestor);
                }
                if (!(pathObj = (JsonValue)resInfo.get((Object)"PathStr")).equals(JsonValue.NULL)) {
                    String path = resInfo.getString("PathStr");
                    String sr = resInfo.getString("StartRow");
                    String edId = this.normalizeSubType(pTypeId);
                    this.programsStmtMap.put(key, new TextSelectionInFile(path, edId, new String[]{sr}));
                } else {
                    L.debug("path not found for the project {}, programid  {}", (Object)prjName, (Object)pId);
                }
                ++i;
            }
        }
    }

    private String normalizeSubType(String subTypeID) {
        if (EXTERNAL_COBOL_TYPE.equals(subTypeID)) {
            return String.valueOf(ProgramType.COBOL.getProgramTypeId());
        }
        if (EXTERNAL_PL1_TYPE.equals(subTypeID)) {
            return String.valueOf(ProgramType.PL1.getProgramTypeId());
        }
        if (EXTERNAL_CICSTRANSACTION_TYPE.equals(subTypeID)) {
            return String.valueOf(14);
        }
        if (EXTERNAL_IMSTRANSACTION_TYPE.equals(subTypeID)) {
            return String.valueOf(20);
        }
        return subTypeID;
    }

    private boolean isProgram(String typeID) {
        return String.valueOf(5).equals(typeID) || EXTERNAL_COBOL_TYPE.equals(typeID) || EXTERNAL_PL1_TYPE.equals(typeID);
    }

    private void drawInputNodes() {
        Map startPrj = (Map)this.analysis.getContextValue("cross input projects");
        if (startPrj != null) {
            for (String projectName : startPrj.keySet()) {
                String crossPid = (String)startPrj.get(projectName);
                this.makePrjTSNode(projectName, crossPid);
            }
        }
    }

    public List<TSEGraph> getGraphs() {
        ArrayList<TSEGraph> graphsList = new ArrayList<TSEGraph>();
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        Set childGraphs = (Set)this.graphManager.getAttributeValue("child_graphs");
        if (childGraphs != null) {
            graphsList.addAll(childGraphs);
            graphsList.add(mainGraph);
        } else {
            graphsList.add(mainGraph);
        }
        return graphsList;
    }

    private TSENode getOrCreateTSNode(TSEGraph gr, String resID, String resName, String resType, boolean isPrg) {
        String key;
        Map tsNodes = (Map)gr.getAttributeValue("TS nodes per project");
        TSENode node = (TSENode)tsNodes.get(key = TSGraphUtils.getKey((String)((String)gr.getAttributeValue("mainframe project name")), (String)(isPrg ? resID : resName), (String)resType));
        if (node == null) {
            node = (TSENode)gr.addNode();
            String ancestor = this.programsAncestorMap.get(key);
            if (ancestor != null) {
                resName = ancestor.concat(":").concat(resName);
            }
            node.setName((Object)resName);
            String iTypeID = this.normalizeSubType(resType);
            Integer resTypeId = Integer.valueOf(iTypeID);
            node.setAttribute("resource type id", (Object)resTypeId);
            node.setAttribute("program id", (Object)Integer.valueOf(resID));
            this.setResourceUIStyle((TSNode)node, resTypeId, isPrg);
            String lbl = TSGraphUtils.getNodeLegendInfo((boolean)isPrg, (Integer)resTypeId).getLegendLabel();
            node.setTooltipText(lbl.concat(": ").concat(resName));
            this.setNodeUI(node);
            tsNodes.put(key, node);
            this.putEntriesInGISV(this.graphManager, lbl, node);
            if (this.analysis.getContextSetValue(INPUT_PROGRAM_KEYS).contains(key)) {
                node.setAttribute("Text_Color", (Object)TSEColor.blue);
                node.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
            }
            if (isPrg) {
                this.setPrgFileAttribute(node, key);
                node.setAttribute("program_type", (Object)Boolean.TRUE);
            } else {
                node.setAttribute("Node_Mainframe", (Object)new GenericProgramRelatedNode(resName, ResultElementType.TRANSACTION.getDisplayName()));
                node.setAttribute("resourceType", (Object)resTypeId);
            }
        }
        return node;
    }

    public void setResourceUIStyle(TSNode tsNode, Integer resTypeID, boolean isPrg) {
        IGraphNodeLegendInfo info = TSGraphUtils.getNodeLegendInfo((boolean)isPrg, (Integer)resTypeID);
        TSEColor textColor = TSGraphUtils.getTextColor((boolean)isPrg, (Integer)resTypeID);
        tsNode.setAttribute("class_name", (Object)info.getNodeTypeClass());
        String imgPath = info.getGraphImagePath();
        TSGraphUtils.setNodeUI((TSNode)tsNode, (String)imgPath, (TSEColor)info.getTSEColor(), (TSEColor)textColor);
        if (this.nodeTypesSetForLegend != null) {
            this.nodeTypesSetForLegend.add(info);
        }
    }

    public void setNodeUI(TSENode node) {
        TSESVGImage img = (TSESVGImage)node.getAttributeValue("uiImage");
        if (this.uiStyle == 2 && img != null) {
            node.setAttribute("uiStyle", (Object)"svg");
            node.setAttribute("Text_Color", (Object)TSEColor.black);
        } else {
            node.setAttribute("uiStyle", (Object)"!svg");
        }
        if (node.hasAttribute("node is input for callgraph")) {
            node.setAttribute("Text_Color", (Object)TSEColor.blue);
        }
    }

    private void setPrgFileAttribute(TSENode node, String key) {
        TextSelectionInFile infoSel = this.programsStmtMap.get(key);
        if (infoSel != null) {
            HashSet<TextSelectionInFile> infoSelSet = new HashSet<TextSelectionInFile>();
            infoSelSet.add(infoSel);
            node.setAttribute("FILE", infoSelSet);
            node.setAttribute("GOTOSOURCE", (Object)true);
            String programType = Utils.getPrgType((String)infoSel.getPrgType().toString());
            MainframeSourceNode prgNode = new MainframeSourceNode(programType, infoSel.getFileName());
            node.setAttribute("Node_Mainframe", (Object)prgNode);
        }
    }

    private void makePrjTSNode(String projectName, String crosPrjId) {
        TSEGraph prjGraph = TSGraphUtils.getPrjChildGraph((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (String)projectName, (boolean)false);
        if (prjGraph == null) {
            Map map = (Map)this.analysis.getContextValue("all projects");
            ProjectInfo pi = (ProjectInfo)map.get(projectName);
            TSENode prjNode = TSGraphUtils.makePrjTSNode((TSEGraphManager)this.graphManager, (TSEGraph)this.graph, (ProjectInfo)pi);
            this.putEntriesInGISV(prjInventoryLbl, prjNode);
            prjNode.setAttribute(PRJ_CROSS_ID_ATTR, (Object)crosPrjId);
            Map prjTSMap = (Map)this.graphManager.getAttributeValue("Projects_TS_map");
            prjTSMap.put(projectName, prjNode);
            this.markStartNode((TSNode)prjNode);
        }
    }

    public TSEEdge makeCallExtEdge(TSENode sourceNode, TSENode node, String sourcePrjName, String editorId, String stmtPos, boolean isApiCall) {
        TSEEdge e = null;
        if (!TSGraphUtils.extCallEdgeExists((TSENode)sourceNode, (TSENode)node) && (e = (TSEEdge)this.graphManager.addEdge((TSNode)sourceNode, (TSNode)node)) != null) {
            CallgraphEdgeLegendInfo edgeType = CallgraphEdgeLegendInfo.EXT_CALL;
            TSEColor edgeColor = edgeType.getTSEColor();
            this.edgeTypesSetForLegend.add(edgeType);
            e.setAttribute("Color", (Object)edgeColor);
            String stmtType = ResourceLink.FAKE_STMT_TYPE_FOR_EXT_CALL_STRING;
            StatementNode sn = new StatementNode(stmtType);
            e.setAttribute("Statement Node_Mainframe", (Object)sn);
            e.setAttribute("GOTOSOURCE", (Object)true);
            e.setAttribute("statement info id", (Object)stmtPos);
            e.setAttribute("mainframe project name", (Object)sourcePrjName);
            e.setAttribute("editor type id", (Object)editorId);
        }
        return e;
    }

    private void putEntriesInGISV(String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes = (HashSet<TSENode>)this.outForGISV.get(inventoryCategory);
        if (nodes == null) {
            nodes = new HashSet<TSENode>();
            this.outForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    public EZObjectType getApplicableInputType(TSNode gNode) {
        EZObjectType objType = super.getApplicableInputType(gNode);
        if (gNode != null) {
            objType = gNode.hasAttribute("APPLICABLE_INPUT") ? (EZObjectType)gNode.getAttributeValue("APPLICABLE_INPUT") : (gNode.hasAttribute("is ts node for project") ? TSGraphUtils.makePrjInputType((TSNode)gNode) : TSGraphUtils.makeResInputType((TSNode)gNode));
            gNode.setAttribute("APPLICABLE_INPUT", (Object)objType);
        }
        return objType;
    }

    public EZObjectType getApplicableInputType(List<TSNode> nodelist) {
        List selectedNodes = this.graphManager.selectedNodes();
        StringBuilder pSb = new StringBuilder();
        HashSet<String> selPrjIds = new HashSet<String>();
        for (TSENode node : selectedNodes) {
            if (!node.hasAttribute(PRJ_CROSS_ID_ATTR)) continue;
            String pId = (String)node.getAttributeValue(PRJ_CROSS_ID_ATTR);
            if (pSb.length() > 0) {
                pSb.append(";");
            }
            pSb.append(pId);
            selPrjIds.add(pId);
        }
        Map inputPrjMap = (Map)this.analysis.getContextValue("cross input projects");
        EZCrossObjectType objType = new EZCrossObjectType(inputPrjMap.values(), selPrjIds);
        objType.addProperty(SELECTED_PRJS_SB_ATTR, pSb);
        objType.addProperty(INPUT_PRJS_SB_ATTR, this.analysis.getContextValue(INPUT_PRJS_SB_ATTR));
        objType.addProperty("all projects", this.analysis.getContextValue("all projects"));
        objType.addProperty("input_project_names", this.analysis.getContextValue("input_project_names"));
        objType.addProperty("graph direction: forward or backward or both", this.analysis.getContextValue("graph direction: forward or backward or both"));
        objType.addProperty("is graph limited", this.analysis.getContextValue("is graph limited"));
        objType.addProperty("limit number for graph levels", this.analysis.getContextValue("limit number for graph levels"));
        return objType;
    }

    private void markStartNode(TSNode prjNode) {
        prjNode.setAttribute("Text_Color", (Object)TSEColor.blue);
        prjNode.setAttribute("node is input for callgraph", (Object)Boolean.TRUE);
    }

    protected void putEntriesInGISV(TSEGraphManager gmanager, String inventoryCategory, TSENode tsNode) {
        HashSet<TSENode> nodes;
        TSENode category = (TSENode)tsNode.getOwnerGraph().getParent();
        HashMap<String, HashSet<TSENode>> currentOutForGISV = (HashMap<String, HashSet<TSENode>>)this.outForGISV.get(category);
        if (currentOutForGISV == null) {
            currentOutForGISV = new HashMap<String, HashSet<TSENode>>();
            this.outForGISV.put(category, currentOutForGISV);
        }
        if ((nodes = (HashSet<TSENode>)currentOutForGISV.get(inventoryCategory)) == null) {
            nodes = new HashSet<TSENode>();
            currentOutForGISV.put(inventoryCategory, nodes);
        }
        nodes.add(tsNode);
    }

    public void dispose() {
        this.prgForInternalCg = null;
        this.prgNotToBeDisplayed = null;
        this.tranForInternalCg = null;
        this.internalCgStatus = null;
        super.dispose();
    }
}

