/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross;

import com.ez.analysis.base.projects.service.IProjectsService;
import com.ez.cobol.callgraph.MainframeMouseActionsHook;
import com.ez.cobol.callgraph.utils.TSGraphUtils;
import com.ez.common.ui.listselection.Listable;
import com.ez.graphs.internal.Messages;
import com.ez.graphs.viewer.srvcross.CrossMouseActionsHook;
import com.ez.graphs.viewer.srvcross.CrossSrvGraphModel;
import com.ez.graphs.viewer.srvcross.ui.CrossPrjInputGUI;
import com.ez.graphs.viewer.utils.SharedImages;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Triplet;
import com.ez.mainframe.gui.graphs.AnnotatedGraphJob;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProgramInputNoGUI;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.EZFitInCanvasCommand;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.job.GraphTSJobAdapter;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphFilterInfo;
import com.ez.workspace.analysis.graph.model.GraphInfo;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.analysis.graph.mouseHook.EZMouseTool;
import com.ez.workspace.analysis.graph.mouseHook.MouseActionsHook;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.srvcross.core.utils.CrossUtils;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.graphicaldrawing.TSEGraph;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.command.TSCommand;
import com.tomsawyer.interactive.command.editing.TSELayoutCommand;
import com.tomsawyer.interactive.tool.TSToolInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSrvGraphAnalysisJob
extends AnnotatedGraphJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossSrvGraphAnalysisJob.class);
    private MainframeMouseActionsHook mouseActionsHook = null;
    private Direction cgDirection;
    private Boolean isCgLimited;
    private Integer cgLimitation = null;

    public CrossSrvGraphAnalysisJob(EZEntityID id) {
        super(id);
        this.mouseActionsHook = new CrossMouseActionsHook(id, (GraphAnalysisJob)this);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphInfo = new CrossGraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        this.gfi = new GraphFilterInfo();
        this.graphInfo.setGraphFilterInfo(this.gfi);
        this.cgDirection = (Direction)this.analysis.getContextValue("graph direction: forward or backward or both");
        L.debug("cross callgraph direction: {}", (Object)this.cgDirection);
        this.isCgLimited = (Boolean)this.analysis.getContextValue("is graph limited");
        if (this.isCgLimited != null && this.isCgLimited.booleanValue()) {
            this.cgLimitation = (Integer)this.analysis.getContextValue("limit number for graph levels");
            L.debug("callgraph has limit: {}", (Object)this.cgLimitation);
        } else {
            L.debug("callgraph is unlimited");
        }
        this.graphModel = new CrossSrvGraphModel(new AnalysisGraphManager(), this.cgDirection, this.analysis);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider((MouseActionsHook)this.mouseActionsHook);
            icp.setHasExport(true);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
            this.addAnnContentProvider((MouseActionsHook)this.mouseActionsHook);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
        this.canvas.getToolManager().register("mouse", (TSToolInterface)new EZMouseTool((MouseActionsHook)this.mouseActionsHook));
        this.canvas.getToolManager().setDefaultTool(this.canvas.getToolManager().getTool("mouse"));
        this.mouseActionsHook.setAnalysis(this.analysis);
        this.mouseActionsHook.setSelectJob(this.selectJob);
        this.mouseActionsHook.setGraphInfo((GraphInfo)this.graphInfo);
        this.mouseActionsHook.setGraphModel(this.graphModel);
    }

    public void makeGraphActions() {
        super.makeGraphActions();
        this.createEdgesActions();
    }

    protected void computeResults(AbstractAnalysisGraphModel model, IProgressMonitor pmonitor) {
        L.debug("cross applications graph using cross service - computeResults");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
        monitor.setTaskName(Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"collectingData.taskName"));
        super.computeResults(model, (IProgressMonitor)monitor.newChild(50));
        List prjs = this.analysis.getContextListValue("input_list");
        List exclPrjs = this.analysis.getContextListValue("excluded cross projects");
        HashMap<String, String> inpProjects = new HashMap<String, String>();
        HashMap<String, ProjectInfo> allProjects = new HashMap<String, ProjectInfo>();
        String prjName = null;
        for (CrossPrjInputGUI pInput : prjs) {
            prjName = pInput.getListableName();
            inpProjects.put(prjName, pInput.getPid());
        }
        HashMap<String, String> exclProjects = new HashMap<String, String>();
        if (exclPrjs != null) {
            for (CrossPrjInputGUI pExcl : exclPrjs) {
                prjName = pExcl.getListableName();
                exclProjects.put(prjName, pExcl.getPid());
                L.debug("project excluded by the user {} from cross computation", (Object)prjName);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        IProjectsService service = (IProjectsService)ServiceUtils.getService(IProjectsService.class);
        List projects = service.getProjects();
        StringBuilder ids = new StringBuilder();
        StringBuilder eIds = new StringBuilder();
        for (ProjectInfo pInfo : projects) {
            String crossPId;
            if (pInfo.isEclipse()) continue;
            if (inpProjects.keySet().contains(pInfo.getName())) {
                crossPId = (String)inpProjects.get(pInfo.getName());
                if (ids.length() > 0) {
                    ids.append(";");
                }
                ids.append(crossPId);
            }
            if (exclProjects.keySet().contains(pInfo.getName())) {
                crossPId = (String)exclProjects.get(pInfo.getName());
                if (eIds.length() > 0) {
                    eIds.append(";");
                }
                eIds.append(crossPId);
            }
            allProjects.put(pInfo.getName(), pInfo);
        }
        this.analysis.addContextValue("cross input projects", inpProjects);
        this.analysis.addContextValue("all projects", allProjects);
        this.analysis.addContextValue("input_project_names", inpProjects.keySet());
        this.analysis.addContextValue("input cross projects ids", (Object)ids);
        this.prepareInfoForAllCrossPrj();
        try {
            String endpoint = CrossUtils.getQueryResultEndpoint();
            if (endpoint != null && !endpoint.isEmpty()) {
                List rPrjs = CrossUtils.getCrossPrjs(null);
                for (Triplet rCrossPrj : rPrjs) {
                    String name = (String)rCrossPrj.getFirst();
                    if (allProjects.keySet().contains(name)) continue;
                    String pid = (String)rCrossPrj.getThird();
                    if (eIds.length() > 0) {
                        eIds.append(";");
                    }
                    eIds.append(pid);
                    L.debug("project {} excluded by the user acces workspace projects from cross computation", (Object)prjName);
                }
                StringBuilder prgInfos = this.extractPrgInfo(prjName, ids);
                ArrayList<Pair<String, String>> pList = new ArrayList<Pair<String, String>>();
                Integer cgLimit = this.isCgLimited != null && this.isCgLimited != false ? this.cgLimitation : -1;
                String directionParam = this.cgDirection.equals((Object)Direction.FORWARD) ? "1" : "0";
                pList.add(new Pair((Object)"params", (Object)(String.valueOf(directionParam.concat(",")) + cgLimit)));
                pList.add(new Pair((Object)"varParams1", (Object)ids.toString()));
                if (eIds.length() > 0) {
                    pList.add(new Pair((Object)"varParams2", (Object)eIds.toString()));
                }
                if (prgInfos.length() > 0) {
                    pList.add(new Pair((Object)"varParams3", (Object)prgInfos.toString()));
                }
                String request = this.makeRequest(endpoint, (Pair<String, String>)new Pair((Object)"spName", (Object)"spRep_ProjectRelationSummary"), pList, pList.size());
                JsonArray data = CrossUtils.runRequest((String)request);
                this.analysis.addContextValue("data from SP_PROJECT_SUMMARY", (Object)data);
                this.doRequestForPrograms(endpoint, data);
                String detRequest = this.makeRequest(endpoint, (Pair<String, String>)new Pair((Object)"spName", (Object)"spRep_ProjectRelationDetails"), pList, pList.size());
                L.debug("cross project data starting from {} projects", (Object)ids);
                JsonArray detData = CrossUtils.runRequest((String)detRequest);
                this.analysis.addContextValue("data from SP_PROJECT_RELATION_DETAILS", (Object)detData);
            } else {
                L.warn("request result endpoint is not filled in CCS");
            }
        }
        catch (Exception e) {
            L.debug("while querying cross repository", (Throwable)e);
            throw new RuntimeException("Could not obtain information from cross repository ", e);
        }
    }

    private String makeRequest(String endpoint, Pair<String, String> firstPair, List<Pair<String, String>> pList, int pListSize) {
        switch (pListSize) {
            case 2: {
                return CrossUtils.prepareURL((String)endpoint, (Pair[])new Pair[]{firstPair, pList.get(0), pList.get(1)});
            }
            case 3: {
                return CrossUtils.prepareURL((String)endpoint, (Pair[])new Pair[]{firstPair, pList.get(0), pList.get(1), pList.get(2)});
            }
            case 4: {
                return CrossUtils.prepareURL((String)endpoint, (Pair[])new Pair[]{firstPair, pList.get(0), pList.get(1), pList.get(2), pList.get(3)});
            }
        }
        return null;
    }

    private void doRequestForPrograms(String endpoint, JsonArray sumData) throws Exception {
        if (sumData == null || sumData.size() == 0) {
            return;
        }
        HashSet<String> prjsIds = new HashSet<String>();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < sumData.size()) {
            JsonObject resInfo = sumData.getJsonObject(i);
            String fromPId = resInfo.getString("ProjectFromID");
            String toPId = resInfo.getString("ProjectToID");
            if (!prjsIds.contains(fromPId)) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(fromPId);
                prjsIds.add(fromPId);
            }
            if (!prjsIds.contains(toPId)) {
                if (sb.length() > 0) {
                    sb.append(";");
                }
                sb.append(toPId);
                prjsIds.add(toPId);
            }
            ++i;
        }
        String request = CrossUtils.prepareURL((String)endpoint, (Pair[])new Pair[]{new Pair((Object)"spName", (Object)"spRep_GetResourceDetails"), new Pair((Object)"params", (Object)"5,1"), new Pair((Object)"varParams1", (Object)sb.toString())});
        JsonArray data = CrossUtils.runRequest((String)request);
        this.analysis.addContextValue("data from SP_GETRESOURCES", (Object)data);
    }

    private void prepareInfoForAllCrossPrj() {
        Set all = this.analysis.getContextSetValue("All cross projects filtered by the workspace restrictions");
        HashMap<String, String> crossInfo = new HashMap<String, String>();
        for (CrossPrjInputGUI c : all) {
            crossInfo.put(c.getListableName(), c.getPid());
        }
        this.analysis.addContextValue("all cross projects", crossInfo);
    }

    private StringBuilder extractPrgInfo(String prjName, StringBuilder ids) {
        List selPrgs = this.analysis.getContextListValue("selected programs as input");
        StringBuilder prgInfos = new StringBuilder();
        HashSet<String> prgKeys = new HashSet<String>();
        HashSet<Integer> prgIds = new HashSet<Integer>();
        if (selPrgs != null) {
            Iterator iterator = selPrgs.iterator();
            while (iterator.hasNext()) {
                ProgramInputNoGUI prg = (ProgramInputNoGUI)iterator.next();
                prgInfos.append(ids.toString());
                prgInfos.append(",");
                prgInfos.append(prg.getResourceID());
                prgInfos.append(",5");
                if (iterator.hasNext()) {
                    prgInfos.append(";");
                }
                prgKeys.add(TSGraphUtils.getKey((String)prjName, (String)String.valueOf(prg.getResourceID()), (String)String.valueOf(prg.getTypeCode())));
                prgIds.add(prg.getResourceID());
            }
        }
        this.analysis.addContextValue("getKey for selected programs from a single project", prgKeys);
        this.analysis.addContextValue("sid selected programs from a single project", prgIds);
        return prgInfos;
    }

    protected List<TSCommand> doLayout(int type) {
        TSEGraph mainGraph = (TSEGraph)this.graphManager.getMainDisplayGraph();
        TSCommand layoutCommand = super.doLayout(type, mainGraph);
        ArrayList<TSCommand> cmds = new ArrayList<TSCommand>();
        cmds.add(layoutCommand);
        return cmds;
    }

    class CrossGraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2022.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        GraphFilterInfo gfi;
        String tabName;

        public CrossGraphInfo(EZEntityID id) {
            super(id);
            this.gfi = null;
            SharedImages.registerImage((String)"programCallgraph", (String)"icons/programcall.png");
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }

        public void disposeImage() {
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = SharedImages.getImage((String)"programCallgraph");
            }
            return this.image;
        }

        public String getText() {
            this.text = this.getText(true);
            return super.getText();
        }

        public String getText(boolean truncate) {
            List inputs = CrossSrvGraphAnalysisJob.this.analysis.getContextListValue("input_list");
            Pair<String, StringBuffer> pair = this.parseNames(truncate, inputs);
            StringBuffer buf = (StringBuffer)pair.getSecond();
            String inputsTextCount = (String)pair.getFirst();
            List selPrgs = CrossSrvGraphAnalysisJob.this.analysis.getContextListValue("selected programs as input");
            if (selPrgs != null) {
                pair = this.parseNames(truncate, selPrgs);
                StringBuffer pbuf = (StringBuffer)pair.getSecond();
                String pinputsTextCount = (String)pair.getFirst();
                if (pinputsTextCount.isEmpty()) {
                    buf.append(Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"prg.tab.name", (Object[])new String[]{pbuf.toString()}));
                } else {
                    buf.append(Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"prg.tab.with.name", (Object[])new String[]{pbuf.toString(), pinputsTextCount}));
                }
            }
            this.tabName = inputsTextCount.isEmpty() ? Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"tab.name", (Object[])new String[]{buf.toString()}) : Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"tab.name.with.more", (Object[])new String[]{buf.toString(), inputsTextCount});
            return this.tabName;
        }

        private Pair<String, StringBuffer> parseNames(boolean truncate, List<Listable> inputs) {
            StringBuffer buf = new StringBuffer();
            String inputsTextCount = "";
            if (inputs != null) {
                int idx = 0;
                int all = inputs.size();
                for (Listable input : inputs) {
                    if (truncate && idx >= 10) {
                        inputsTextCount = String.valueOf(inputsTextCount) + (all - idx);
                        break;
                    }
                    ++idx;
                    buf.append(input.getListableName());
                    if (inputs.indexOf(input) == inputs.size() - 1) continue;
                    buf.append(", ");
                }
            }
            return new Pair((Object)inputsTextCount, (Object)buf);
        }

        public String getTooltip() {
            StringBuffer buf = new StringBuffer(this.tabName);
            if (CrossSrvGraphAnalysisJob.this.cgDirection != null) {
                if (CrossSrvGraphAnalysisJob.this.isCgLimited != null && CrossSrvGraphAnalysisJob.this.isCgLimited.booleanValue()) {
                    buf.append(Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"tooltip.text.cgDir.cgLim", (Object[])new String[]{CrossSrvGraphAnalysisJob.this.cgDirection.toString(), CrossSrvGraphAnalysisJob.this.cgLimitation.toString()}));
                } else {
                    buf.append(Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"tooltip.text.cgDir", (Object[])new String[]{CrossSrvGraphAnalysisJob.this.cgDirection.toString()}));
                }
            } else if (CrossSrvGraphAnalysisJob.this.isCgLimited != null && CrossSrvGraphAnalysisJob.this.isCgLimited.booleanValue()) {
                buf.append(Messages.getString(CrossSrvGraphAnalysisJob.class, (String)"tooltip.text.cgLim", (Object[])new String[]{CrossSrvGraphAnalysisJob.this.cgLimitation.toString()}));
            }
            return buf.toString();
        }

        public GraphFilterInfo getGraphFilterInfo() {
            return this.gfi;
        }

        public void setGraphFilterInfo(GraphFilterInfo gfi) {
            this.gfi = gfi;
        }

        public void dispose() {
            this.gfi = null;
            if (CrossSrvGraphAnalysisJob.this.legend != null) {
                CrossSrvGraphAnalysisJob.this.legend.dispose();
                CrossSrvGraphAnalysisJob.this.legend = null;
            }
            super.dispose();
        }
    }

    public class ExpandAllCrossAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2020.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public ExpandAllCrossAction() {
            super((GraphTSJobAdapter)CrossSrvGraphAnalysisJob.this);
        }

        public void execute(IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(GraphAnalysisJob.class, (String)"expand.task.text"));
            ((CrossSrvGraphModel)CrossSrvGraphAnalysisJob.this.graphModel).buildInternalCgs((IProgressMonitor)monitor.newChild(70));
            CrossSrvGraphAnalysisJob.this.graphModel.getGraph().expandAll();
            ArrayList<Object> cmds = new ArrayList<Object>();
            TSCommand layout = CrossSrvGraphAnalysisJob.this.doLayout(CrossSrvGraphAnalysisJob.this.currentLayoutType, (TSEGraph)CrossSrvGraphAnalysisJob.this.graphManager.getMainDisplayGraph());
            ((TSELayoutCommand)layout).setLayoutAnimated(false);
            cmds.add(layout);
            EZFitInCanvasCommand fit = new EZFitInCanvasCommand(CrossSrvGraphAnalysisJob.this.canvas);
            cmds.add(fit);
            CrossSrvGraphAnalysisJob.this.transmitCommands(cmds);
            CrossSrvGraphAnalysisJob.createMetaEdges((TSEGraphManager)CrossSrvGraphAnalysisJob.this.graphManager);
            monitor.done();
        }
    }

    public class ExpandCrossAction
    extends GraphTSJobAdapter.ProgressAction {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
        private TSENode nodeToExpand;

        public ExpandCrossAction(GraphInfo graphInfo) {
            super((GraphTSJobAdapter)CrossSrvGraphAnalysisJob.this, graphInfo);
        }

        public void execute(IProgressMonitor pmonitor) {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)pmonitor, (int)100);
            monitor.setTaskName(Messages.getString(GraphAnalysisJob.class, (String)"expand.task.text"));
            EZSourceProjectIDSg prjIdSg = (EZSourceProjectIDSg)this.nodeToExpand.getAttributeValue("MAINFRAME_PROJECT_ID_SG");
            ((CrossSrvGraphModel)CrossSrvGraphAnalysisJob.this.graphModel).buildInternalCg(prjIdSg, monitor.newChild(70));
            TSNestingManager.expand((TSDNode)this.nodeToExpand);
            ArrayList<Object> cmds = new ArrayList<Object>();
            TSCommand layout = CrossSrvGraphAnalysisJob.this.doLayout(CrossSrvGraphAnalysisJob.this.currentLayoutType, (TSEGraph)CrossSrvGraphAnalysisJob.this.graphManager.getMainDisplayGraph());
            ((TSELayoutCommand)layout).setLayoutAnimated(false);
            cmds.add(layout);
            EZFitInCanvasCommand fit = new EZFitInCanvasCommand(CrossSrvGraphAnalysisJob.this.canvas);
            cmds.add(fit);
            CrossSrvGraphAnalysisJob.this.transmitCommands(cmds);
            CrossSrvGraphAnalysisJob.createMetaEdges((TSEGraphManager)CrossSrvGraphAnalysisJob.this.graphManager);
            monitor.done();
        }

        public void setNodeToExpand(TSENode nodeToExpand) {
            this.nodeToExpand = nodeToExpand;
        }
    }
}

