/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross;

import com.ez.graphs.MainframeGraphAnalysis;
import com.ez.graphs.viewer.srvcross.CrossSrvGraphAnalysisJob;
import com.ez.graphs.viewer.srvcross.ui.CrossSrvInputsFilter;
import com.ez.internal.analysis.AnalysisType;
import com.ez.internal.analysis.config.inputs.EZSourceProgram;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.id.EZSegment;
import com.ez.mainframe.filters.InputsFilter;
import com.ez.mainframe.model.Direction;
import com.ez.mainframe.model.ProjectInfo;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.AbstractSharedAnalysis;
import com.ez.workspace.analysis.EZAnalysis;
import com.ez.workspace.analysis.job.AbstractAnalysisJob;
import com.ez.workspace.model.EZWorkspace;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSrvGraphAnalysis
extends MainframeGraphAnalysis {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossSrvGraphAnalysis.class);
    private CrossSrvGraphAnalysisJob job;

    protected AbstractAnalysisJob getJob(EZEntityID id) {
        if (this.job == null) {
            EZWorkspace wk = EZWorkspace.getInstance();
            this.job = (CrossSrvGraphAnalysisJob)wk.getJob(id, CrossSrvGraphAnalysisJob.class);
        }
        this.job.setAnalysis((AbstractSharedAnalysis)this);
        return this.job;
    }

    public void setInputs(List inputs) {
        ArrayList<ProjectInfo> list = new ArrayList<ProjectInfo>();
        boolean startedOnPrjs = true;
        for (Object inpObj : inputs) {
            EZSourceProjectIDSg prjSg;
            if (inpObj instanceof EZSourceProjectInputType) {
                EZSourceProjectInputType prjInputType = (EZSourceProjectInputType)inpObj;
                prjSg = (EZSourceProjectIDSg)prjInputType.getEntID().getSegment(EZSourceProjectIDSg.class);
                list.add(prjSg.getProjectInfo());
                continue;
            }
            startedOnPrjs = false;
            EZSourceProgram pInputType = (EZSourceProgram)inpObj;
            prjSg = (EZSourceProjectIDSg)pInputType.getEntID().getSegment(EZSourceProjectIDSg.class);
            list.add(prjSg.getProjectInfo());
        }
        this.addContextValue("wizard started on projects not program", startedOnPrjs);
        if (this.getContextValue("ANALYSIS_TYPE_INPUTS") == null) {
            this.addContextValue("ANALYSIS_TYPE_INPUTS", inputs);
        }
        if (!list.isEmpty()) {
            this.addContextValue("input_list", list);
        } else {
            L.warn("Cross applications (using cross service) analysis without valid input");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractAnalysis)) {
            return false;
        }
        AbstractAnalysis a2 = (AbstractAnalysis)obj;
        boolean ret = this.type.equals((Object)a2.getType());
        if (ret) {
            Direction cgDirection1 = (Direction)this.getContextValue("graph direction: forward or backward or both");
            Direction cgDirection2 = (Direction)a2.getContextValue("graph direction: forward or backward or both");
            ret = cgDirection1.equals((Object)cgDirection2);
            Boolean limitResources = (Boolean)this.getContextValue("graph without resources");
            limitResources = limitResources == null ? false : limitResources;
            Boolean limitResources1 = (Boolean)a2.getContextValue("graph without resources");
            if (!limitResources.equals(limitResources1 = Boolean.valueOf(limitResources1 == null ? false : limitResources1))) {
                ret = false;
            }
            if (!limitResources.booleanValue()) {
                Map r1 = (Map)this.getContextValue("graph resources checked or not");
                Map r2 = (Map)a2.getContextValue("graph resources checked or not");
                if (r1 == null || r2 == null || !r1.values().toString().equals(r2.values().toString())) {
                    return false;
                }
            }
            if (ret) {
                Boolean isLimited1 = (Boolean)this.getContextValue("is graph limited");
                isLimited1 = isLimited1 == null ? false : isLimited1;
                Boolean isLimited2 = (Boolean)a2.getContextValue("is graph limited");
                if (!isLimited1.equals(isLimited2 = Boolean.valueOf(isLimited2 == null ? false : isLimited2))) {
                    ret = false;
                }
                if (ret && isLimited1.booleanValue()) {
                    Integer cgLimitation1 = (Integer)this.getContextValue("limit number for graph levels");
                    Integer cgLimitation2 = (Integer)a2.getContextValue("limit number for graph levels");
                    if (cgLimitation1.intValue() != cgLimitation2.intValue()) {
                        ret = false;
                    }
                }
                if (ret) {
                    Set inputs2;
                    Set inputs1 = this.getContextSetValue("All cross projects filtered by the workspace restrictions");
                    ret = inputs1.equals(inputs2 = a2.getContextSetValue("All cross projects filtered by the workspace restrictions"));
                    if (ret) {
                        List start1 = this.getContextListValue("input_list");
                        List start2 = a2.getContextListValue("input_list");
                        ret = start1.equals(start2);
                    }
                    if (ret) {
                        List selPrgs1 = this.getContextListValue("selected programs as input");
                        List selPrgs2 = a2.getContextListValue("selected programs as input");
                        ret = selPrgs1 == null ? selPrgs2 == null : selPrgs1.equals(selPrgs2);
                    }
                    if (ret) {
                        List cPrjs1 = this.getContextListValue("excluded cross projects");
                        List cPrjs2 = a2.getContextListValue("excluded cross projects");
                        ret = cPrjs1 == null ? cPrjs2 == null : cPrjs1.equals(cPrjs2);
                    }
                }
            }
        }
        return ret;
    }

    public String getLabelType() {
        return this.getType().getName();
    }

    protected EZEntityID makeID() {
        EZEntityID id = new EZEntityID();
        AnalysisIDSegment sg = new AnalysisIDSegment((EZAnalysis)this);
        id.addSegment((EZSegment)sg);
        return id;
    }

    protected AnalysisType getAnalysisType() {
        return AnalysisType.EZ_CROSS_APPS_SRV_CALL_GRAPH;
    }

    protected InputsFilter getInputsFilter() {
        CrossSrvInputsFilter iFilter = new CrossSrvInputsFilter();
        return iFilter;
    }
}

