/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross;

import com.ez.internal.analysis.config.inputs.EZObjectType;
import com.ez.internal.analysis.config.inputs.EZSourceProjectInputType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.mainframe.filters.MultipleMainframeProjectFilter;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.srvcross.core.itf.ICrossService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossSrvAnalysisFilter
extends MultipleMainframeProjectFilter {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\ufffd Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossSrvAnalysisFilter.class);

    public boolean checkAnalysisAvailability(Collection inputs) {
        boolean ret;
        ArrayList<EZSourceProjectInputType> toCheck = inputs;
        boolean bl = ret = this.countProjects(toCheck) > 0;
        if (!ret) {
            boolean bl2 = ret = inputs.size() == 1;
            if (ret) {
                EZObjectType ot = (EZObjectType)inputs.iterator().next();
                if (ot.getProperty("program occur") != null && ((Boolean)ot.getProperty("program occur")).booleanValue()) {
                    toCheck = new ArrayList<EZSourceProjectInputType>();
                    EZSourceProjectIDSg prjSg = (EZSourceProjectIDSg)ot.getEntID().getSegment(EZSourceProjectIDSg.class);
                    EZSourceProjectInputType pInputType = new EZSourceProjectInputType();
                    pInputType.setName(prjSg.getProjectName());
                    pInputType.addProperty("PROJECT_INFO", (Object)prjSg.getProjectInfo());
                    toCheck.add(pInputType);
                } else {
                    ret = false;
                }
            }
        }
        if (ret) {
            ret = this.checkProjectsDefinition(toCheck);
            if (ret) {
                ret = this.checkParameters(toCheck);
            }
            if (ret) {
                ret = this.checkCrossInfo((Collection<EZSourceProjectInputType>)toCheck);
            }
        }
        return ret;
    }

    private boolean checkCrossInfo(Collection<EZSourceProjectInputType> inputs) {
        boolean ret = false;
        ICrossService service = (ICrossService)ServiceUtils.getService(ICrossService.class);
        if (service != null) {
            L.trace("analysis filter: cross service={}", (Object)service);
            Iterator<EZSourceProjectInputType> it = inputs.iterator();
            while (!ret && it.hasNext()) {
                ret = service.hasCross(it.next().getName());
            }
        }
        return ret;
    }
}

