/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.srvcross;

import com.ez.graphs.viewer.odb.ui.ResolutionBasedMouseHook;
import com.ez.graphs.viewer.srvcross.CrossSrvGraphAnalysisJob;
import com.ez.graphs.viewer.srvcross.internal.Messages;
import com.ez.internal.id.EZEntityID;
import com.ez.internal.utils.Pair;
import com.ez.mainframe.data.utils.TextSelectionInFile;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.model.segments.EZSourceProjectIDSg;
import com.ibm.ad.srvcross.core.utils.CrossUtils;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.complexity.TSNestingManager;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graphicaldrawing.TSENode;
import com.tomsawyer.interactive.swing.overview.TSEOverviewComponent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.Separator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrossMouseActionsHook
extends ResolutionBasedMouseHook {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2019.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(CrossMouseActionsHook.class);
    private CrossSrvGraphAnalysisJob job;
    private CrossSrvGraphAnalysisJob.ExpandCrossAction expandAction = null;
    private GraphAnalysisJob.CollapseAction collapseAction = null;
    private CrossSrvGraphAnalysisJob.ExpandAllCrossAction expandAllApps = null;
    private GraphAnalysisJob.CollapseAllAction collapseAllApps = null;

    public CrossMouseActionsHook(EZEntityID entityId, GraphAnalysisJob job) {
        super(entityId);
        this.job = (CrossSrvGraphAnalysisJob)job;
    }

    protected String getInputProjectsName(TSGraphMember tsMember) {
        String inputProjectName = null;
        if (tsMember != null && tsMember.getOwnerGraph().hasAttribute("mainframe project name")) {
            inputProjectName = (String)tsMember.getOwnerGraph().getAttributeValue("mainframe project name");
        } else {
            L.warn("mainframe project not set for {} ts member", tsMember != null ? tsMember.getName() : "which is null");
        }
        return inputProjectName;
    }

    public List getRightClickContributions(TSENode node) {
        ArrayList<Separator> contextItems = new ArrayList<Separator>();
        this.addExpandNodeAction(node, contextItems);
        this.addCollapseNodeAction(node, contextItems);
        contextItems.add(new Separator());
        contextItems.addAll(super.getRightClickContributions(node));
        return contextItems;
    }

    public List getRightClickContributions() {
        ArrayList<Separator> contextItems = new ArrayList<Separator>();
        this.addExpandAllAction(contextItems);
        this.addCollapseAllAction(contextItems);
        if (this.allowPrgLvl()) {
            contextItems.add(new Separator());
            List sel = this.graphManager.selectedNodes();
            ArrayList<TSNode> sel2 = new ArrayList<TSNode>();
            sel2.addAll(sel);
            this.addAnalysisActions(sel2, contextItems);
        }
        contextItems.add(new Separator());
        contextItems.addAll(super.getRightClickContributions());
        return contextItems;
    }

    private boolean allowPrgLvl() {
        List selectedNodes = this.graphManager.selectedNodes();
        int count = 0;
        for (TSENode node : selectedNodes) {
            if (node.hasAttribute("ProjectID")) {
                ++count;
            }
            if (count <= 1) continue;
            return true;
        }
        return false;
    }

    protected void addAnalysisActions(List<TSNode> tsNodeList, List contextItems) {
        super.addAnalysisActions(tsNodeList, contextItems);
    }

    protected void addCollapseNodeAction(TSENode node, List contextItems) {
        if (node != null && node.hasAttribute("is ts node for project") && node.isExpanded()) {
            if (this.collapseAction == null) {
                this.collapseAction = new GraphAnalysisJob.CollapseAction((GraphAnalysisJob)this.job);
            }
            this.collapseAction.setChecked(false);
            this.collapseAction.overview = (TSEOverviewComponent)this.graphInfo.getOverviewComponent();
            EZSourceProjectIDSg sg = (EZSourceProjectIDSg)node.getAttributeValue("MAINFRAME_PROJECT_ID_SG");
            this.collapseAction.toCollapseNode = node;
            String collapseLabel = Messages.getString(CrossMouseActionsHook.class, "collapse.text", new String[]{sg.getProjectName()});
            this.collapseAction.setText(collapseLabel);
            this.collapseAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.collapseAction));
        }
    }

    protected void addExpandNodeAction(TSENode node, List contextItems) {
        if (node != null && node.hasAttribute("is ts node for project") && !node.isExpanded()) {
            if (this.expandAction == null) {
                CrossSrvGraphAnalysisJob crossSrvGraphAnalysisJob = this.job;
                ((Object)((Object)crossSrvGraphAnalysisJob)).getClass();
                this.expandAction = new CrossSrvGraphAnalysisJob.ExpandCrossAction(crossSrvGraphAnalysisJob, this.graphInfo);
            }
            this.expandAction.setChecked(false);
            this.expandAction.setNodeToExpand(node);
            String expandLabel = Messages.getString(CrossMouseActionsHook.class, "expand.text", new String[]{node.getText()});
            this.expandAction.setText(expandLabel);
            this.expandAction.setEnabled(true);
            contextItems.add(new ActionContributionItem((IAction)this.expandAction));
        }
    }

    protected void addExpandAllAction(List contextItems) {
        if (this.expandAllApps == null) {
            this.expandAllApps = new CrossSrvGraphAnalysisJob.ExpandAllCrossAction(this.job);
        }
        this.expandAllApps.setChecked(false);
        String expandLabel = Messages.getString(CrossMouseActionsHook.class, "expand.all.text");
        this.expandAllApps.setText(expandLabel);
        this.expandAllApps.setEnabled(TSNestingManager.hasCollapsedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        if (this.expandAllApps != null) {
            contextItems.add(new ActionContributionItem((IAction)this.expandAllApps));
        }
    }

    protected void addCollapseAllAction(List contextItems) {
        if (this.collapseAllApps == null) {
            this.collapseAllApps = new GraphAnalysisJob.CollapseAllAction((GraphAnalysisJob)this.job);
        }
        this.collapseAllApps.setChecked(false);
        String collaspseLabel = Messages.getString(CrossMouseActionsHook.class, "collapse.all.text");
        this.collapseAllApps.setText(collaspseLabel);
        this.collapseAllApps.setEnabled(TSNestingManager.hasExpandedNodes((TSDGraph)this.graphManager.getMainDisplayGraph()));
        if (this.collapseAllApps != null) {
            contextItems.add(new ActionContributionItem((IAction)this.collapseAllApps));
        }
    }

    public Object overrideTSMemberAttribute(TSGraphMember tsMember, String attr) {
        if (("GOTOSOURCE".equals(attr) || "HAS_PROPERTIES_IN_PROPVIEW".equals(attr)) && !tsMember.hasAttribute("FILE")) {
            String endpoint = CrossUtils.getQueryResultEndpoint();
            String prjName = (String)tsMember.getAttributeValue("mainframe project name");
            String origId = (String)tsMember.getAttributeValue("statement info id");
            if (endpoint != null && !endpoint.isEmpty() && prjName != null && origId != null) {
                try {
                    Map inputPrjMap = (Map)this.analysis.getContextValue("all cross projects");
                    String crossPrjId = (String)inputPrjMap.get(prjName);
                    String req = CrossUtils.prepareURL((String)endpoint, (Pair[])new Pair[]{new Pair((Object)"spName", (Object)"spRep_GetStatementPositionDetails"), new Pair((Object)"params", (Object)(String.valueOf(crossPrjId) + "," + origId))});
                    JsonArray vsData = CrossUtils.runRequest((String)req);
                    HashSet<TextSelectionInFile> set = new HashSet<TextSelectionInFile>();
                    int i = 0;
                    while (i < vsData.size()) {
                        JsonObject resInfo = vsData.getJsonObject(i);
                        String sr = resInfo.getString("StartRow");
                        String path = resInfo.getString("PathStr");
                        String edId = (String)tsMember.getAttributeValue("editor type id");
                        set.add(new TextSelectionInFile(path, edId, new String[]{sr}));
                        ++i;
                    }
                    tsMember.setAttribute("FILE", set);
                }
                catch (Exception e) {
                    L.debug("while querying cross repository; no view source available", (Throwable)e);
                }
            }
        }
        return super.overrideTSMemberAttribute(tsMember, attr);
    }

    public void dispose() {
        if (this.expandAction != null) {
            this.expandAction.dispose();
            this.expandAction = null;
        }
        if (this.collapseAction != null) {
            this.collapseAction.dispose();
            this.collapseAction = null;
        }
        if (this.expandAllApps != null) {
            this.expandAllApps.dispose();
            this.expandAllApps = null;
        }
        if (this.collapseAllApps != null) {
            this.collapseAllApps.dispose();
            this.collapseAllApps = null;
        }
        super.dispose();
    }
}

