/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ad.ann.core;

import com.ez.ezdao.api.DatabaseInfo;
import com.ez.ezdao.api.DatabaseInfoBuilder;
import com.ez.ezdao.impl.DataConnectionFactory;
import com.ez.ezdao.impl.DataOperation;
import com.ez.ezsource.connection.EZSourceConnection;
import com.ez.ezsource.connection.ServerType;
import com.ez.internal.utils.ServiceUtils;
import com.ez.internal.utils.Version;
import com.ibm.ad.ann.core.AnnotationsConnDetailsService;
import com.ibm.ad.ann.core.EZSCAdapter;
import com.ibm.ad.db.createdb.CreateDBUtils;
import com.ibm.ad.db.createdb.Db2LuwCreateDBUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsDBUtils {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2024.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private static final Logger L = LoggerFactory.getLogger(AnnotationsDBUtils.class);
    private static final String ANNDBNAME_SQLSERV = "EZ#Annotations";
    private static final String ANNDBNAME_DB2Z = "EZANNOT";
    private static final String[] ANNDB_VERSIONS = new String[]{"1.0", "1.1"};
    private static final String SCHEMA_NAME = "<schema_name>";
    private static final String DB_NAME = "<db_name>";
    private static AnnotationsDBUtils _INSTANCE = null;
    DataConnectionFactory f = AnnotationsDBUtils.initFactory();

    private AnnotationsDBUtils() {
    }

    public static AnnotationsDBUtils getInstance() {
        if (_INSTANCE == null) {
            _INSTANCE = new AnnotationsDBUtils();
        }
        return _INSTANCE;
    }

    public static boolean checkDatabase(DataConnectionFactory f, DatabaseInfo annotsInfo) throws Exception {
        if (CreateDBUtils.isDb2Luw((String)annotsInfo.getServerType())) {
            return Db2LuwCreateDBUtils.checkDbExists((DataConnectionFactory)f, (DatabaseInfo)annotsInfo);
        }
        return AnnotationsDBUtils.checkDatabase(f, annotsInfo, false);
    }

    public static boolean checkOrCreateDatabase(DataConnectionFactory f, DatabaseInfo annotsInfo) throws Exception {
        if (CreateDBUtils.isDb2Luw((String)annotsInfo.getServerType())) {
            return AnnotationsDBUtils.createDatabaseOnLuw(f, annotsInfo);
        }
        return AnnotationsDBUtils.checkDatabase(f, annotsInfo, true);
    }

    private static boolean checkDatabase(DataConnectionFactory f, DatabaseInfo annotsInfo, boolean checkAndCreate) throws Exception {
        Exception ex;
        boolean ok;
        block11: {
            if (f == null) {
                L.warn("no connectionFactory set for annotations repo!");
                throw new RuntimeException("no connectionFactory set for annotations repo. cannot continue");
            }
            if (annotsInfo == null) {
                L.warn("no settings for annotations repo in CCS");
                throw new RuntimeException("no info related with annotations repo. cannot continue");
            }
            ok = true;
            DataOperation c = null;
            ex = null;
            try {
                try {
                    DatabaseInfoBuilder dbibm = DatabaseInfoBuilder.from((DatabaseInfo)annotsInfo);
                    dbibm.setDatabase("master");
                    DatabaseInfo dbim = dbibm.build();
                    c = AnnotationsDBUtils.createConnection(f, dbim, true);
                    if (c != null) {
                        EZSCAdapter conn = new EZSCAdapter(c);
                        ServerType dbEngine = CreateDBUtils.getServerType((DatabaseInfo)annotsInfo);
                        String dbName = AnnotationsDBUtils.getDatabaseName(annotsInfo, dbEngine);
                        ok = CreateDBUtils.checkDbExistence((EZSourceConnection)conn, (DatabaseInfo)annotsInfo, (String)dbName);
                        if (checkAndCreate) {
                            ok = !ok ? AnnotationsDBUtils.createOrUseAnnDB(conn, annotsInfo) : AnnotationsDBUtils.upgradeSchema(conn, dbEngine, dbName);
                        }
                    } else {
                        L.warn("cannot obtain a connection to check annotation's repo existence");
                        ok = false;
                    }
                }
                catch (Exception e) {
                    L.error("could not check annotation database successfuly ", (Throwable)e);
                    ok = false;
                    ex = e;
                    AnnotationsDBUtils.releaseConnection(f, c);
                    break block11;
                }
            }
            catch (Throwable throwable) {
                AnnotationsDBUtils.releaseConnection(f, c);
                throw throwable;
            }
            AnnotationsDBUtils.releaseConnection(f, c);
        }
        if (ex != null) {
            throw ex;
        }
        return ok;
    }

    private static boolean createOrUseAnnDB(EZSourceConnection conn, DatabaseInfo annotsInfo) {
        String query;
        boolean ok = false;
        String oldDB = null;
        ServerType dbEngine = CreateDBUtils.getServerType((DatabaseInfo)annotsInfo);
        String dbName = AnnotationsDBUtils.getDatabaseName(annotsInfo, dbEngine);
        String storageGroup = annotsInfo.getStorageGroup();
        boolean isSqlServ = ServerType.SqlServer.equals((Object)dbEngine);
        if (isSqlServ) {
            query = "select db_name()";
            String[][] rez = conn.executeSQL(query);
            oldDB = rez[0][0];
        }
        try {
            query = AnnotationsDBUtils.getCreateDBSqlString(dbEngine, dbName, storageGroup);
            conn.executeUpdate(query);
            if (isSqlServ) {
                query = "use " + dbName;
                conn.executeUpdate(query);
            }
            AnnotationsDBUtils.createSchema(conn, annotsInfo);
            query = "insert into Version values ('" + ANNDB_VERSIONS[ANNDB_VERSIONS.length - 1] + "')";
            conn.executeInsert(query);
            L.debug("created database {}", (Object)dbName);
            ok = true;
        }
        catch (Exception e) {
            L.error("while creating db", (Throwable)e);
            ok = false;
        }
        if (isSqlServ) {
            query = "use " + oldDB;
            conn.executeUpdate(query);
        }
        return ok;
    }

    private static String getCreateDBSqlString(ServerType dbEngine, String dbName, String storageGroup) {
        String sqlStr = "create database " + dbName;
        if (ServerType.Db2Z.equals((Object)dbEngine)) {
            if (storageGroup != null && !storageGroup.isEmpty()) {
                sqlStr = String.valueOf(sqlStr) + " STOGROUP " + storageGroup.toUpperCase();
            }
            sqlStr = String.valueOf(sqlStr) + " CCSID UNICODE";
        }
        return sqlStr;
    }

    private static boolean createDatabaseOnLuw(DataConnectionFactory f, DatabaseInfo annotsInfo) throws Exception {
        Exception ex;
        EZSCAdapter conn;
        DataOperation c;
        boolean ok;
        block13: {
            if (f == null) {
                L.warn("no connectionFactory set for annotations repo!");
                throw new RuntimeException("no connectionFactory set for annotations repo. cannot continue");
            }
            if (annotsInfo == null) {
                L.warn("no settings for annotations repo in CCS");
                throw new RuntimeException("no info related with annotations repo. cannot continue");
            }
            ok = false;
            c = null;
            conn = null;
            ex = null;
            String dbToolDir = System.getProperty("user.dir");
            String logName = Db2LuwCreateDBUtils.generateDbToolLogName();
            try {
                logName = Paths.get(dbToolDir, "log", logName).normalize().toString();
                dbToolDir = Paths.get(dbToolDir, new String[0]).normalize().toString();
            }
            catch (Exception e) {
                L.error("Error when getting the log name for the tool to create database: ", (Throwable)e);
            }
            ok = Db2LuwCreateDBUtils.createDatabase((DataConnectionFactory)f, (DatabaseInfo)annotsInfo, (String)dbToolDir, (String)logName);
            if (ok && (c = AnnotationsDBUtils.createConnection(f, annotsInfo, true)) != null) {
                conn = new EZSCAdapter(c);
            }
            if (conn != null) break block13;
            L.error("Cannot connect to database {}.", (Object)annotsInfo.getDatabase());
            AnnotationsDBUtils.releaseConnection(f, c);
            return false;
        }
        try {
            try {
                ok = Db2LuwCreateDBUtils.checkSchemaExists(conn, (String)annotsInfo.getSchema());
                if (!ok) {
                    AnnotationsDBUtils.createSchema(conn, annotsInfo);
                    ok = true;
                } else {
                    ServerType dbEngine = CreateDBUtils.getServerType((DatabaseInfo)annotsInfo);
                    String dbName = AnnotationsDBUtils.getDatabaseName(annotsInfo, dbEngine);
                    ok = AnnotationsDBUtils.upgradeSchema(conn, dbEngine, dbName);
                }
            }
            catch (Exception e) {
                L.error("Error while creating or setting up Annotation database ", (Throwable)e);
                ok = false;
                ex = e;
                AnnotationsDBUtils.releaseConnection(f, c);
            }
        }
        catch (Throwable throwable) {
            AnnotationsDBUtils.releaseConnection(f, c);
            throw throwable;
        }
        AnnotationsDBUtils.releaseConnection(f, c);
        if (ex != null) {
            throw ex;
        }
        return ok;
    }

    private static void createSchema(EZSourceConnection conn, DatabaseInfo annotsInfo) {
        L.debug("creating schema");
        ServerType dbengine = CreateDBUtils.getServerType((DatabaseInfo)annotsInfo);
        String fileName = AnnotationsDBUtils.getSqlScriptsLocation(dbengine);
        if (fileName != null) {
            fileName = String.valueOf(fileName) + "create_annotations_db.sql";
            String sqlSeparator = CreateDBUtils.getSqlSeparator((ServerType)dbengine);
            String dbName = AnnotationsDBUtils.getDatabaseName(annotsInfo, dbengine);
            String schemaName = annotsInfo.getSchema();
            List<String> stmts = AnnotationsDBUtils.readStatements(fileName, sqlSeparator);
            for (String query : stmts) {
                query = query.replaceAll(SCHEMA_NAME, schemaName);
                query = query.replaceAll(DB_NAME, dbName);
                conn.executeUpdate(query);
            }
        } else {
            L.warn("file not found for createTables; dbengine={}", (Object)dbengine.getName());
        }
    }

    private static boolean upgradeSchema(EZSourceConnection conn, ServerType dbEngine, String dbName) {
        Version cVer = AnnotationsDBUtils.getDBVer(conn, dbEngine, dbName);
        boolean ok = false;
        if (cVer == null) {
            L.error("database {} does not have proper structure", (Object)dbName);
            ok = false;
        } else {
            Version latest = new Version(ANNDB_VERSIONS[ANNDB_VERSIONS.length - 1]);
            if (latest.compareTo(cVer) > 0) {
                int i = 0;
                while (i < ANNDB_VERSIONS.length - 1) {
                    Version v = new Version(ANNDB_VERSIONS[i]);
                    if (v.compareTo(cVer) >= 0 && v.compareTo(latest) < 0) {
                        AnnotationsDBUtils.applyUpgrade(v.toString(), ANNDB_VERSIONS[i + 1], conn, dbEngine);
                    }
                    ++i;
                }
            }
            ok = true;
        }
        return ok;
    }

    private static void applyUpgrade(String from, String to, EZSourceConnection conn, ServerType dbEngine) {
        String location = AnnotationsDBUtils.getSqlScriptsLocation(dbEngine);
        String upgradeFile = String.valueOf(location) + String.format("upgrade-%s-%s.sql", from, to);
        L.debug("upgrading from v.{} to v.{} using file {}", new Object[]{from, to, upgradeFile});
        String sqlSeparator = CreateDBUtils.getSqlSeparator((ServerType)dbEngine);
        List<String> stmts = AnnotationsDBUtils.readStatements(upgradeFile, sqlSeparator);
        for (String query : stmts) {
            conn.executeUpdate(query);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<String> readStatements(String file, String sqlSeparator) {
        LinkedList<String> stmts = new LinkedList<String>();
        InputStream is = AnnotationsDBUtils.class.getResourceAsStream(file);
        if (is != null) {
            try {
                try {
                    String query;
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        boolean commentLine = line.trim().startsWith("--");
                        if (line.trim().equalsIgnoreCase(sqlSeparator)) {
                            String query2 = sb.toString();
                            sb.delete(0, sb.length());
                            if (query2.trim().isEmpty()) continue;
                            stmts.add(query2);
                            continue;
                        }
                        if (commentLine) continue;
                        sb.append(line).append("\n");
                    }
                    if (sb.length() <= 0 || (query = sb.toString()).trim().isEmpty()) return stmts;
                    stmts.add(query);
                    return stmts;
                }
                catch (Exception e) {
                    L.error("could not read statements", (Throwable)e);
                    try {
                        is.close();
                        return stmts;
                    }
                    catch (IOException e2) {
                        L.error("", (Throwable)e2);
                    }
                }
                return stmts;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    L.error("", (Throwable)e);
                }
            }
        }
        L.warn("could not find file {}", (Object)file);
        return stmts;
    }

    private static final String getSqlScriptsLocation(ServerType dbType) {
        String location = null;
        switch (dbType) {
            case SqlServer: {
                location = "sql/";
                break;
            }
            case Db2Z: {
                location = "sql/db2z/";
                break;
            }
            case Db2: {
                location = "sql/db2/";
                break;
            }
        }
        if (location == null) {
            throw new RuntimeException("no location for sqlScripts; serverType=" + dbType);
        }
        return location;
    }

    private static Version getDBVer(EZSourceConnection conn, ServerType dbEngine, String dbName) {
        Version v = null;
        String query = null;
        if (ServerType.SqlServer.equals((Object)dbEngine)) {
            query = "use " + dbName;
            conn.executeUpdate(query);
        }
        query = "select version from Version";
        try {
            String[][] rez = conn.executeSQL(query);
            String ver = rez != null ? rez[0][0] : "-1";
            v = new Version(ver);
        }
        catch (Exception e) {
            L.error("could not get database version", (Throwable)e);
        }
        return v;
    }

    public boolean checkDatabase(DatabaseInfo annotsInfo) throws Exception {
        return AnnotationsDBUtils.checkDatabase(this.f, annotsInfo);
    }

    public static void releaseConnection(DataConnectionFactory f, DataOperation c) {
        if (f != null && c != null) {
            f.destroy(c);
        }
    }

    public void releaseConnection(DataOperation c) {
        AnnotationsDBUtils.releaseConnection(this.f, c);
    }

    public void releaseEZSConnection(EZSourceConnection annConn) {
        DataOperation dop = ((EZSCAdapter)annConn).dop;
        L.trace("releaseAnnConn: {}", (Object)dop);
        this.releaseConnection(dop);
    }

    public static DataOperation createConnection(DataConnectionFactory f, DatabaseInfo annotsInfo, boolean isCreate) {
        String dbType;
        ServerType servType;
        DataOperation c = null;
        if (f == null) {
            return null;
        }
        if (annotsInfo == null) {
            L.info("no settings for annotations repo in CCS");
            return null;
        }
        String sqlDatabase = annotsInfo.getDatabase();
        if (isCreate && ServerType.SqlServer.equals((Object)(servType = ServerType.findByName((String)(dbType = annotsInfo.getServerType()))))) {
            sqlDatabase = "master";
        }
        try {
            c = f.create(sqlDatabase, annotsInfo);
        }
        catch (Exception e) {
            L.error("could not create connection for check/create annotation database", (Throwable)e);
        }
        return c;
    }

    protected DataOperation createConnection(DatabaseInfo annotsInfo, boolean isCreate) {
        return AnnotationsDBUtils.createConnection(this.f, annotsInfo, isCreate);
    }

    private static DataConnectionFactory initFactory() {
        BaseConfiguration config = new BaseConfiguration();
        DataConnectionFactory f = new DataConnectionFactory((Configuration)config);
        return f;
    }

    public DataConnectionFactory getConnFactory() {
        return this.f;
    }

    public static String getDatabaseName(DatabaseInfo annotsInfo, ServerType dbEngine) {
        String dbName = annotsInfo.getDatabase();
        if (dbName == null) {
            L.warn("no database name for annotations in CCS; default name it will be used");
            switch (dbEngine) {
                case SqlServer: {
                    dbName = ANNDBNAME_SQLSERV;
                    break;
                }
                case Db2: 
                case Db2Z: {
                    dbName = ANNDBNAME_DB2Z;
                    break;
                }
                default: {
                    L.error("unknown database name");
                    break;
                }
            }
        } else if (ServerType.Db2Z.equals((Object)dbEngine)) {
            dbName = dbName.toUpperCase();
        }
        if (dbName == null) {
            throw new RuntimeException("no database name found for annotations repo; cannot continue!");
        }
        return dbName;
    }

    public EZSourceConnection getConnection(DatabaseInfo annotsInfo) {
        DataOperation c = this.createConnection(annotsInfo, false);
        return c != null ? new EZSCAdapter(c) : null;
    }

    public static DatabaseInfo getAnnDbInfo() {
        AnnotationsConnDetailsService srv = (AnnotationsConnDetailsService)ServiceUtils.getService(AnnotationsConnDetailsService.class);
        if (srv != null) {
            return srv.getAnnDbInfo();
        }
        L.warn("cannot find annotations repo details; connection service is null");
        return null;
    }
}

