/*
 * Decompiled with CFR 0.152.
 */
package com.ez.graphs.viewer.example;

import com.ez.common.ui.ImageDescriptorProvider;
import com.ez.graphs.viewer.Activator;
import com.ez.graphs.viewer.example.GraphModel;
import com.ez.internal.graphmodel.CloseHook;
import com.ez.internal.id.EZEntityID;
import com.ez.mainframe.gui.graphs.ContentProvider;
import com.ez.workspace.analysis.AbstractAnalysis;
import com.ez.workspace.analysis.graph.AnalysisGraphManager;
import com.ez.workspace.analysis.graph.gui.ComponentBuilderInterface;
import com.ez.workspace.analysis.graph.gui.LegendPanel;
import com.ez.workspace.analysis.graph.job.GraphAnalysisJob;
import com.ez.workspace.analysis.graph.model.AbstractAnalysisGraphModel;
import com.ez.workspace.analysis.graph.model.GraphInfoAdapter;
import com.ez.workspace.analysis.graph.model.StructureContentProvider;
import com.ez.workspace.model.segments.AnalysisIDSegment;
import com.tomsawyer.graphicaldrawing.TSEGraphManager;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.ISelectionListener;

public class TestGraphJob
extends GraphAnalysisJob {
    public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2018.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";
    private TSEGraphManager graphManager;

    public TestGraphJob(EZEntityID arg0) {
        super(arg0);
        this.initGraphDetails();
    }

    protected void initGraphDetails() {
        this.graphModel = new GraphModel(new AnalysisGraphManager());
        this.graphManager = this.graphModel.getGraphManager();
        this.graphInfo = new GraphInfo(this.id);
        this.graphInfo.setCloseHook((CloseHook)this);
        if (this.graphInfo.getContentProviders() == null) {
            ContentProvider icp = new ContentProvider(null);
            icp.setHasExport(false);
            this.graphInfo.setContentProvider((StructureContentProvider)icp);
        }
        super.initGraphDetails();
    }

    public void buildComponents(Composite composite) {
        super.buildComponents(composite);
    }

    protected void computeResults(AbstractAnalysisGraphModel arg0, IProgressMonitor arg1) {
    }

    public class GraphInfo
    extends GraphInfoAdapter {
        public static final String COPYRIGHT = "\n\nLicensed Materials - Property of IBM\n5737-B16\n\u00a9 Copyright IBM Corp. 2003, 2016.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.\n\n";

        public GraphInfo(EZEntityID id) {
            super(id);
        }

        public Image getImage() {
            if (this.image == null) {
                this.image = Activator.getImageDescriptor("icons/erd.png").createImage();
            }
            return this.image;
        }

        public String getText() {
            AbstractAnalysis analysis;
            Set set;
            StringBuffer buf = new StringBuffer();
            EZEntityID entityID = this.getID();
            AnalysisIDSegment seg = (AnalysisIDSegment)entityID.getSegment(AnalysisIDSegment.class);
            if (seg != null && (set = (analysis = (AbstractAnalysis)seg.getAnalysis()).getInputSet()) != null) {
                Iterator tIt = set.iterator();
                while (tIt.hasNext()) {
                    if (buf.length() > 0) {
                        buf.append(",");
                    }
                    buf.append((String)tIt.next());
                }
            }
            buf.append("test");
            return buf.toString();
        }

        public ComponentBuilderInterface getLegendControl() {
            return new ComponentBuilderInterface(){

                public Composite buildComponent(Composite parent) {
                    ScrolledComposite sc = new ScrolledComposite(parent, 768);
                    TestGraphJob.this.legend = new LegendPanel((Composite)sc, 0);
                    TestGraphJob.this.legend.setImageDescriptorProvider(new ImageDescriptorProvider(){

                        public ImageDescriptor getImageDescriptor(String image) {
                            return Activator.getImageDescriptor(image);
                        }
                    });
                    TestGraphJob.this.graphModel.getUIStyle();
                    sc.setContent((Control)TestGraphJob.this.legend);
                    sc.setExpandHorizontal(true);
                    sc.setExpandVertical(true);
                    TestGraphJob.this.legend.pack();
                    sc.setMinSize(TestGraphJob.this.legend.getSize());
                    return sc;
                }

                public int getPercent() {
                    int legendW = ((TestGraphJob)((GraphInfo)GraphInfo.this).TestGraphJob.this).legend.getSize().x;
                    int x = ((TestGraphJob)((GraphInfo)GraphInfo.this).TestGraphJob.this).legend.getParent().getParent().getSize().x;
                    int percent = 100 * (x - legendW) / x;
                    return percent;
                }
            };
        }

        public boolean hasLegend() {
            return false;
        }

        public ISelectionListener getSelectionListener() {
            return null;
        }
    }
}

